# Contributing to PgQueuer

First off, thank you for considering contributing to PgQueuer.

## How to Contribute

There are many ways you can contribute to PgQueuer, from writing tutorials or blog posts, improving the documentation, submitting bug reports and feature requests, or writing code which can be incorporated into PgQueuer itself.

Below you will find a set of guidelines to follow when contributing. These are mostly guidelines, not rules, so use your best judgment and feel free to propose changes to this document.

### Reporting Bugs

Before submitting bug reports, please check the issue list to avoid duplicating issues. When you are creating a bug report, please include as many details as possible by filling out the provided template. The more details you provide, the easier it will be for others to resolve the issue.

### Feature Requests

Feature requests are welcome. But take a moment to find out whether your idea fits with the scope and aims of the project. It's up to you to make a strong case to convince the project's developers of the merits of this feature. Please provide as much detail and context as possible, which includes explaining why you're requesting the feature.

### Pull Requests

Please follow these steps to have your contribution considered by the maintainers:

1. Follow all instructions in the template.
2. Follow the [style guides](#style-guides) for Python.
3. After you submit your pull request, verify that all status checks are passing.

While the prerequisites above must be satisfied prior to having your pull request reviewed, the reviewer(s) may ask you to complete additional design work, tests, or other changes before your pull request can be ultimately accepted.

## Style Guides

### Git Commit Messages

* Use the present tense ("Add feature" not "Added feature").
* Limit the first line to 72 characters or less.
* Reference issues and pull requests liberally after the first line.

### Python Styleguide

Adhere to the [PEP 8](https://pep8.org/) style guide, using `ruff` for automatic formatting. Ensure that your submissions are clean by running `ruff` before submitting a pull request. This will help maintain code consistency and readability across the project.

### Documentation Styleguide

* Use Markdown for formatting.
* Document new code based on existing documentation patterns.
* Update the README, if necessary, depending on the changes.

## Community

Discussions about PgQueuer take place on this repository's [Issues](https://github.com/janbjorge/PgQueuer/issues) and [Pull Requests](https://github.com/janbjorge/PgQueuer/pulls) sections. Anybody is welcome to join these conversations.
