# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, constr, validator

from typing import Optional

from lusid.models.annul_single_structured_data_response import AnnulSingleStructuredDataResponse
from lusid.models.get_counterparty_agreement_response import GetCounterpartyAgreementResponse
from lusid.models.get_credit_support_annex_response import GetCreditSupportAnnexResponse
from lusid.models.resource_list_of_get_counterparty_agreement_response import ResourceListOfGetCounterpartyAgreementResponse
from lusid.models.resource_list_of_get_credit_support_annex_response import ResourceListOfGetCreditSupportAnnexResponse
from lusid.models.upsert_counterparty_agreement_request import UpsertCounterpartyAgreementRequest
from lusid.models.upsert_credit_support_annex_request import UpsertCreditSupportAnnexRequest
from lusid.models.upsert_single_structured_data_response import UpsertSingleStructuredDataResponse

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class CounterpartiesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def delete_counterparty_agreement(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Counterparty Agreement to delete.")], code : Annotated[StrictStr, Field(..., description="The Counterparty Agreement to delete.")], **kwargs) -> AnnulSingleStructuredDataResponse:  # noqa: E501
        ...

    @overload
    def delete_counterparty_agreement(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Counterparty Agreement to delete.")], code : Annotated[StrictStr, Field(..., description="The Counterparty Agreement to delete.")], async_req: Optional[bool]=True, **kwargs) -> AnnulSingleStructuredDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_counterparty_agreement(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Counterparty Agreement to delete.")], code : Annotated[StrictStr, Field(..., description="The Counterparty Agreement to delete.")], async_req: Optional[bool]=None, **kwargs) -> Union[AnnulSingleStructuredDataResponse, Awaitable[AnnulSingleStructuredDataResponse]]:  # noqa: E501
        """[EARLY ACCESS] DeleteCounterpartyAgreement: Delete the Counterparty Agreement of given scope and code  # noqa: E501

        Delete the specified Counterparty Agreement from a single scope.  The response will return either detail of the deleted item, or an explanation (failure) as to why this did not succeed.                It is important to always check for any unsuccessful response.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_counterparty_agreement(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Counterparty Agreement to delete. (required)
        :type scope: str
        :param code: The Counterparty Agreement to delete. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AnnulSingleStructuredDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_counterparty_agreement_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_counterparty_agreement_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_counterparty_agreement_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Counterparty Agreement to delete.")], code : Annotated[StrictStr, Field(..., description="The Counterparty Agreement to delete.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] DeleteCounterpartyAgreement: Delete the Counterparty Agreement of given scope and code  # noqa: E501

        Delete the specified Counterparty Agreement from a single scope.  The response will return either detail of the deleted item, or an explanation (failure) as to why this did not succeed.                It is important to always check for any unsuccessful response.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_counterparty_agreement_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Counterparty Agreement to delete. (required)
        :type scope: str
        :param code: The Counterparty Agreement to delete. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AnnulSingleStructuredDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_agreement" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AnnulSingleStructuredDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/counterparties/counterpartyagreements/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_credit_support_annex(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Credit Support Annex to delete.")], code : Annotated[StrictStr, Field(..., description="The Credit Support Annex to delete.")], **kwargs) -> AnnulSingleStructuredDataResponse:  # noqa: E501
        ...

    @overload
    def delete_credit_support_annex(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Credit Support Annex to delete.")], code : Annotated[StrictStr, Field(..., description="The Credit Support Annex to delete.")], async_req: Optional[bool]=True, **kwargs) -> AnnulSingleStructuredDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_credit_support_annex(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Credit Support Annex to delete.")], code : Annotated[StrictStr, Field(..., description="The Credit Support Annex to delete.")], async_req: Optional[bool]=None, **kwargs) -> Union[AnnulSingleStructuredDataResponse, Awaitable[AnnulSingleStructuredDataResponse]]:  # noqa: E501
        """[EARLY ACCESS] DeleteCreditSupportAnnex: Delete the Credit Support Annex of given scope and code  # noqa: E501

        Delete the specified Credit Support Annex from a single scope.  The response will return either detail of the deleted item, or an explanation (failure) as to why this did not succeed.                It is important to always check for any unsuccessful response.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_credit_support_annex(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Credit Support Annex to delete. (required)
        :type scope: str
        :param code: The Credit Support Annex to delete. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AnnulSingleStructuredDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_credit_support_annex_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_credit_support_annex_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_credit_support_annex_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Credit Support Annex to delete.")], code : Annotated[StrictStr, Field(..., description="The Credit Support Annex to delete.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] DeleteCreditSupportAnnex: Delete the Credit Support Annex of given scope and code  # noqa: E501

        Delete the specified Credit Support Annex from a single scope.  The response will return either detail of the deleted item, or an explanation (failure) as to why this did not succeed.                It is important to always check for any unsuccessful response.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_credit_support_annex_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Credit Support Annex to delete. (required)
        :type scope: str
        :param code: The Credit Support Annex to delete. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AnnulSingleStructuredDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_credit_support_annex" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AnnulSingleStructuredDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/counterparties/creditsupportannexes/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_counterparty_agreement(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Counterparty Agreement to retrieve.")], code : Annotated[StrictStr, Field(..., description="The name of the Counterparty Agreement to retrieve the data for.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Counterparty Agreement. Defaults to return the latest version if not specified.")] = None, **kwargs) -> GetCounterpartyAgreementResponse:  # noqa: E501
        ...

    @overload
    def get_counterparty_agreement(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Counterparty Agreement to retrieve.")], code : Annotated[StrictStr, Field(..., description="The name of the Counterparty Agreement to retrieve the data for.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Counterparty Agreement. Defaults to return the latest version if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> GetCounterpartyAgreementResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_counterparty_agreement(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Counterparty Agreement to retrieve.")], code : Annotated[StrictStr, Field(..., description="The name of the Counterparty Agreement to retrieve the data for.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Counterparty Agreement. Defaults to return the latest version if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[GetCounterpartyAgreementResponse, Awaitable[GetCounterpartyAgreementResponse]]:  # noqa: E501
        """[EARLY ACCESS] GetCounterpartyAgreement: Get Counterparty Agreement  # noqa: E501

        Get a Counterparty Agreement from a single scope.  The response will return either the Counterparty Agreement that has been stored, or a failure explaining why the request was unsuccessful.  It is important to always check for any unsuccessful requests (failures).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_counterparty_agreement(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Counterparty Agreement to retrieve. (required)
        :type scope: str
        :param code: The name of the Counterparty Agreement to retrieve the data for. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the Counterparty Agreement. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetCounterpartyAgreementResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_counterparty_agreement_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_counterparty_agreement_with_http_info(scope, code, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_counterparty_agreement_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Counterparty Agreement to retrieve.")], code : Annotated[StrictStr, Field(..., description="The name of the Counterparty Agreement to retrieve the data for.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Counterparty Agreement. Defaults to return the latest version if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetCounterpartyAgreement: Get Counterparty Agreement  # noqa: E501

        Get a Counterparty Agreement from a single scope.  The response will return either the Counterparty Agreement that has been stored, or a failure explaining why the request was unsuccessful.  It is important to always check for any unsuccessful requests (failures).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_counterparty_agreement_with_http_info(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Counterparty Agreement to retrieve. (required)
        :type scope: str
        :param code: The name of the Counterparty Agreement to retrieve the data for. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the Counterparty Agreement. Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetCounterpartyAgreementResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_counterparty_agreement" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "GetCounterpartyAgreementResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/counterparties/counterpartyagreements/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_credit_support_annex(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Credit Support Annex to retrieve.")], code : Annotated[StrictStr, Field(..., description="The name of the Credit Support Annex to retrieve the data for.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Credit Support Annex . Defaults to return the latest version if not specified.")] = None, **kwargs) -> GetCreditSupportAnnexResponse:  # noqa: E501
        ...

    @overload
    def get_credit_support_annex(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Credit Support Annex to retrieve.")], code : Annotated[StrictStr, Field(..., description="The name of the Credit Support Annex to retrieve the data for.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Credit Support Annex . Defaults to return the latest version if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> GetCreditSupportAnnexResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_credit_support_annex(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Credit Support Annex to retrieve.")], code : Annotated[StrictStr, Field(..., description="The name of the Credit Support Annex to retrieve the data for.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Credit Support Annex . Defaults to return the latest version if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[GetCreditSupportAnnexResponse, Awaitable[GetCreditSupportAnnexResponse]]:  # noqa: E501
        """[EARLY ACCESS] GetCreditSupportAnnex: Get Credit Support Annex  # noqa: E501

        Get a Credit Support Annex from a single scope.  The response will return either the Credit Support Annex that has been stored, or a failure explaining why the request was unsuccessful.  It is important to always check for any unsuccessful requests (failures).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_credit_support_annex(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Credit Support Annex to retrieve. (required)
        :type scope: str
        :param code: The name of the Credit Support Annex to retrieve the data for. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the Credit Support Annex . Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetCreditSupportAnnexResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_credit_support_annex_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_credit_support_annex_with_http_info(scope, code, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_credit_support_annex_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Credit Support Annex to retrieve.")], code : Annotated[StrictStr, Field(..., description="The name of the Credit Support Annex to retrieve the data for.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Credit Support Annex . Defaults to return the latest version if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetCreditSupportAnnex: Get Credit Support Annex  # noqa: E501

        Get a Credit Support Annex from a single scope.  The response will return either the Credit Support Annex that has been stored, or a failure explaining why the request was unsuccessful.  It is important to always check for any unsuccessful requests (failures).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_credit_support_annex_with_http_info(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Credit Support Annex to retrieve. (required)
        :type scope: str
        :param code: The name of the Credit Support Annex to retrieve the data for. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the Credit Support Annex . Defaults to return the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetCreditSupportAnnexResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_credit_support_annex" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "GetCreditSupportAnnexResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/counterparties/creditsupportannexes/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_counterparty_agreements(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Counterparty Agreements. Defaults to latest if not specified.")] = None, **kwargs) -> ResourceListOfGetCounterpartyAgreementResponse:  # noqa: E501
        ...

    @overload
    def list_counterparty_agreements(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Counterparty Agreements. Defaults to latest if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfGetCounterpartyAgreementResponse:  # noqa: E501
        ...

    @validate_arguments
    def list_counterparty_agreements(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Counterparty Agreements. Defaults to latest if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfGetCounterpartyAgreementResponse, Awaitable[ResourceListOfGetCounterpartyAgreementResponse]]:  # noqa: E501
        """[EARLY ACCESS] ListCounterpartyAgreements: List the set of Counterparty Agreements  # noqa: E501

        List the set of Counterparty Agreements at the specified AsAt date/time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_counterparty_agreements(as_at, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the Counterparty Agreements. Defaults to latest if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfGetCounterpartyAgreementResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_counterparty_agreements_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_counterparty_agreements_with_http_info(as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def list_counterparty_agreements_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Counterparty Agreements. Defaults to latest if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListCounterpartyAgreements: List the set of Counterparty Agreements  # noqa: E501

        List the set of Counterparty Agreements at the specified AsAt date/time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_counterparty_agreements_with_http_info(as_at, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the Counterparty Agreements. Defaults to latest if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfGetCounterpartyAgreementResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_counterparty_agreements" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfGetCounterpartyAgreementResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/counterparties/counterpartyagreements', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_credit_support_annexes(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Credit Support Annexes. Defaults to latest if not specified.")] = None, **kwargs) -> ResourceListOfGetCreditSupportAnnexResponse:  # noqa: E501
        ...

    @overload
    def list_credit_support_annexes(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Credit Support Annexes. Defaults to latest if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfGetCreditSupportAnnexResponse:  # noqa: E501
        ...

    @validate_arguments
    def list_credit_support_annexes(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Credit Support Annexes. Defaults to latest if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfGetCreditSupportAnnexResponse, Awaitable[ResourceListOfGetCreditSupportAnnexResponse]]:  # noqa: E501
        """[EARLY ACCESS] ListCreditSupportAnnexes: List the set of Credit Support Annexes  # noqa: E501

        List the set of Credit Support Annexes at the specified AsAt date/time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_credit_support_annexes(as_at, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the Credit Support Annexes. Defaults to latest if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfGetCreditSupportAnnexResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_credit_support_annexes_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_credit_support_annexes_with_http_info(as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def list_credit_support_annexes_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Credit Support Annexes. Defaults to latest if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListCreditSupportAnnexes: List the set of Credit Support Annexes  # noqa: E501

        List the set of Credit Support Annexes at the specified AsAt date/time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_credit_support_annexes_with_http_info(as_at, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the Credit Support Annexes. Defaults to latest if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfGetCreditSupportAnnexResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_credit_support_annexes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfGetCreditSupportAnnexResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/counterparties/creditsupportannexes', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_counterparty_agreement(self, upsert_counterparty_agreement_request : Annotated[UpsertCounterpartyAgreementRequest, Field(..., description="The Counterparty Agreement to update or insert")], **kwargs) -> UpsertSingleStructuredDataResponse:  # noqa: E501
        ...

    @overload
    def upsert_counterparty_agreement(self, upsert_counterparty_agreement_request : Annotated[UpsertCounterpartyAgreementRequest, Field(..., description="The Counterparty Agreement to update or insert")], async_req: Optional[bool]=True, **kwargs) -> UpsertSingleStructuredDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_counterparty_agreement(self, upsert_counterparty_agreement_request : Annotated[UpsertCounterpartyAgreementRequest, Field(..., description="The Counterparty Agreement to update or insert")], async_req: Optional[bool]=None, **kwargs) -> Union[UpsertSingleStructuredDataResponse, Awaitable[UpsertSingleStructuredDataResponse]]:  # noqa: E501
        """[EARLY ACCESS] UpsertCounterpartyAgreement: Upsert Counterparty Agreement  # noqa: E501

        Update or insert Counterparty Agreement in a single scope. An item will be updated if it already exists and inserted if it does not.                The response will return the successfully updated or inserted Counterparty Agreement or failure message if unsuccessful                It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_counterparty_agreement(upsert_counterparty_agreement_request, async_req=True)
        >>> result = thread.get()

        :param upsert_counterparty_agreement_request: The Counterparty Agreement to update or insert (required)
        :type upsert_counterparty_agreement_request: UpsertCounterpartyAgreementRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertSingleStructuredDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_counterparty_agreement_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_counterparty_agreement_with_http_info(upsert_counterparty_agreement_request, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_counterparty_agreement_with_http_info(self, upsert_counterparty_agreement_request : Annotated[UpsertCounterpartyAgreementRequest, Field(..., description="The Counterparty Agreement to update or insert")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpsertCounterpartyAgreement: Upsert Counterparty Agreement  # noqa: E501

        Update or insert Counterparty Agreement in a single scope. An item will be updated if it already exists and inserted if it does not.                The response will return the successfully updated or inserted Counterparty Agreement or failure message if unsuccessful                It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_counterparty_agreement_with_http_info(upsert_counterparty_agreement_request, async_req=True)
        >>> result = thread.get()

        :param upsert_counterparty_agreement_request: The Counterparty Agreement to update or insert (required)
        :type upsert_counterparty_agreement_request: UpsertCounterpartyAgreementRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertSingleStructuredDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'upsert_counterparty_agreement_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_counterparty_agreement" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_counterparty_agreement_request'] is not None:
            _body_params = _params['upsert_counterparty_agreement_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UpsertSingleStructuredDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/counterparties/counterpartyagreements', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_credit_support_annex(self, upsert_credit_support_annex_request : Annotated[UpsertCreditSupportAnnexRequest, Field(..., description="The Credit Support Annex to update or insert")], **kwargs) -> UpsertSingleStructuredDataResponse:  # noqa: E501
        ...

    @overload
    def upsert_credit_support_annex(self, upsert_credit_support_annex_request : Annotated[UpsertCreditSupportAnnexRequest, Field(..., description="The Credit Support Annex to update or insert")], async_req: Optional[bool]=True, **kwargs) -> UpsertSingleStructuredDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_credit_support_annex(self, upsert_credit_support_annex_request : Annotated[UpsertCreditSupportAnnexRequest, Field(..., description="The Credit Support Annex to update or insert")], async_req: Optional[bool]=None, **kwargs) -> Union[UpsertSingleStructuredDataResponse, Awaitable[UpsertSingleStructuredDataResponse]]:  # noqa: E501
        """[EARLY ACCESS] UpsertCreditSupportAnnex: Upsert Credit Support Annex  # noqa: E501

        Update or insert Credit Support Annex in a single scope. An item will be updated if it already exists and inserted if it does not.                The response will return the successfully updated or inserted Credit Support Annex or failure message if unsuccessful                It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_credit_support_annex(upsert_credit_support_annex_request, async_req=True)
        >>> result = thread.get()

        :param upsert_credit_support_annex_request: The Credit Support Annex to update or insert (required)
        :type upsert_credit_support_annex_request: UpsertCreditSupportAnnexRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertSingleStructuredDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_credit_support_annex_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_credit_support_annex_with_http_info(upsert_credit_support_annex_request, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_credit_support_annex_with_http_info(self, upsert_credit_support_annex_request : Annotated[UpsertCreditSupportAnnexRequest, Field(..., description="The Credit Support Annex to update or insert")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpsertCreditSupportAnnex: Upsert Credit Support Annex  # noqa: E501

        Update or insert Credit Support Annex in a single scope. An item will be updated if it already exists and inserted if it does not.                The response will return the successfully updated or inserted Credit Support Annex or failure message if unsuccessful                It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_credit_support_annex_with_http_info(upsert_credit_support_annex_request, async_req=True)
        >>> result = thread.get()

        :param upsert_credit_support_annex_request: The Credit Support Annex to update or insert (required)
        :type upsert_credit_support_annex_request: UpsertCreditSupportAnnexRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertSingleStructuredDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'upsert_credit_support_annex_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_credit_support_annex" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_credit_support_annex_request'] is not None:
            _body_params = _params['upsert_credit_support_annex_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UpsertSingleStructuredDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/counterparties/creditsupportannexes', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
