# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist 
from lusid.models.resource_id import ResourceId

class AggregatedReturn(BaseModel):
    """
    A list of Aggregated Returns.  # noqa: E501
    """
    effective_at: datetime = Field(..., alias="effectiveAt", description="The effectiveAt for the return.")
    end_of_period: datetime = Field(..., alias="endOfPeriod", description="The end of period date. For the monthly period this will be the Month End Date.")
    opening_market_value: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="openingMarketValue", description="The opening market value.")
    closing_market_value: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="closingMarketValue", description="The closing market value.")
    metrics_value: Dict[str, Union[StrictFloat, StrictInt]] = Field(..., alias="metricsValue", description="The value for the specified metric.")
    frequency:  Optional[StrictStr] = Field(None,alias="frequency", description="Show the aggregated output returns on a Daily or Monthly period.") 
    composite_members: Optional[StrictInt] = Field(None, alias="compositeMembers", description="The number of members in the Composite on the given day.")
    composite_members_without_return: Optional[conlist(ResourceId)] = Field(None, alias="compositeMembersWithoutReturn", description="List containing Composite members which post no return on the given day.")
    warnings: Optional[conlist(StrictStr)] = Field(None, description="List of the warnings about the calculation of the aggregated return.")
    __properties = ["effectiveAt", "endOfPeriod", "openingMarketValue", "closingMarketValue", "metricsValue", "frequency", "compositeMembers", "compositeMembersWithoutReturn", "warnings"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AggregatedReturn:
        """Create an instance of AggregatedReturn from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in composite_members_without_return (list)
        _items = []
        if self.composite_members_without_return:
            for _item in self.composite_members_without_return:
                if _item:
                    _items.append(_item.to_dict())
            _dict['compositeMembersWithoutReturn'] = _items
        # set to None if opening_market_value (nullable) is None
        # and __fields_set__ contains the field
        if self.opening_market_value is None and "opening_market_value" in self.__fields_set__:
            _dict['openingMarketValue'] = None

        # set to None if closing_market_value (nullable) is None
        # and __fields_set__ contains the field
        if self.closing_market_value is None and "closing_market_value" in self.__fields_set__:
            _dict['closingMarketValue'] = None

        # set to None if frequency (nullable) is None
        # and __fields_set__ contains the field
        if self.frequency is None and "frequency" in self.__fields_set__:
            _dict['frequency'] = None

        # set to None if composite_members (nullable) is None
        # and __fields_set__ contains the field
        if self.composite_members is None and "composite_members" in self.__fields_set__:
            _dict['compositeMembers'] = None

        # set to None if composite_members_without_return (nullable) is None
        # and __fields_set__ contains the field
        if self.composite_members_without_return is None and "composite_members_without_return" in self.__fields_set__:
            _dict['compositeMembersWithoutReturn'] = None

        # set to None if warnings (nullable) is None
        # and __fields_set__ contains the field
        if self.warnings is None and "warnings" in self.__fields_set__:
            _dict['warnings'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AggregatedReturn:
        """Create an instance of AggregatedReturn from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AggregatedReturn.parse_obj(obj)

        _obj = AggregatedReturn.parse_obj({
            "effective_at": obj.get("effectiveAt"),
            "end_of_period": obj.get("endOfPeriod"),
            "opening_market_value": obj.get("openingMarketValue"),
            "closing_market_value": obj.get("closingMarketValue"),
            "metrics_value": obj.get("metricsValue"),
            "frequency": obj.get("frequency"),
            "composite_members": obj.get("compositeMembers"),
            "composite_members_without_return": [ResourceId.from_dict(_item) for _item in obj.get("compositeMembersWithoutReturn")] if obj.get("compositeMembersWithoutReturn") is not None else None,
            "warnings": obj.get("warnings")
        })
        return _obj
