# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import StrictStr, Field, BaseModel, Field 
from lusid.models.resource_id import ResourceId

class BlockAndOrderIdRequest(BaseModel):
    """
    BlockAndOrderIdRequest
    """
    destination_block_id: ResourceId = Field(..., alias="destinationBlockId")
    order_id: ResourceId = Field(..., alias="orderId")
    __properties = ["destinationBlockId", "orderId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BlockAndOrderIdRequest:
        """Create an instance of BlockAndOrderIdRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of destination_block_id
        if self.destination_block_id:
            _dict['destinationBlockId'] = self.destination_block_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_id
        if self.order_id:
            _dict['orderId'] = self.order_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BlockAndOrderIdRequest:
        """Create an instance of BlockAndOrderIdRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BlockAndOrderIdRequest.parse_obj(obj)

        _obj = BlockAndOrderIdRequest.parse_obj({
            "destination_block_id": ResourceId.from_dict(obj.get("destinationBlockId")) if obj.get("destinationBlockId") is not None else None,
            "order_id": ResourceId.from_dict(obj.get("orderId")) if obj.get("orderId") is not None else None
        })
        return _obj
