# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr 
from lusid.models.typed_resource_id import TypedResourceId

class CounterpartySignatory(BaseModel):
    """
    The counterpartyAgreement is signed by two parties, one of which is implicitly the LUSID user.  The CounterpartySignatory represents the 'other side' of the agreement.  It comprises a name and identifier for a Legal Entity in LUSID.  # noqa: E501
    """
    name:  StrictStr = Field(...,alias="name", description="A user-defined name or label for the counterparty signatory.  There is no requirement for this to match the \"displayName\" of the legal entity.") 
    legal_entity_identifier: TypedResourceId = Field(..., alias="legalEntityIdentifier")
    __properties = ["name", "legalEntityIdentifier"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CounterpartySignatory:
        """Create an instance of CounterpartySignatory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of legal_entity_identifier
        if self.legal_entity_identifier:
            _dict['legalEntityIdentifier'] = self.legal_entity_identifier.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CounterpartySignatory:
        """Create an instance of CounterpartySignatory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CounterpartySignatory.parse_obj(obj)

        _obj = CounterpartySignatory.parse_obj({
            "name": obj.get("name"),
            "legal_entity_identifier": TypedResourceId.from_dict(obj.get("legalEntityIdentifier")) if obj.get("legalEntityIdentifier") is not None else None
        })
        return _obj
