# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictFloat, StrictInt, StrictStr 

class JournalEntryLineShareClassBreakdown(BaseModel):
    """
    The apportionment from overall fund level journal entry Line to the share class.  # noqa: E501
    """
    short_code:  Optional[StrictStr] = Field(None,alias="shortCode", description="The share class identifier.") 
    apportionment_factor: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="apportionmentFactor", description="The share class apportionment factor (capital ratio).")
    local_value: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="localValue", description="This journal entry line's local value amount after apportionment is applied.")
    base_value: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="baseValue", description="This journal entry line's base value amount after apportionment is applied")
    __properties = ["shortCode", "apportionmentFactor", "localValue", "baseValue"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JournalEntryLineShareClassBreakdown:
        """Create an instance of JournalEntryLineShareClassBreakdown from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if short_code (nullable) is None
        # and __fields_set__ contains the field
        if self.short_code is None and "short_code" in self.__fields_set__:
            _dict['shortCode'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JournalEntryLineShareClassBreakdown:
        """Create an instance of JournalEntryLineShareClassBreakdown from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return JournalEntryLineShareClassBreakdown.parse_obj(obj)

        _obj = JournalEntryLineShareClassBreakdown.parse_obj({
            "short_code": obj.get("shortCode"),
            "apportionment_factor": obj.get("apportionmentFactor"),
            "local_value": obj.get("localValue"),
            "base_value": obj.get("baseValue")
        })
        return _obj
