# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, validator 
import lusid.models

class LusidInstrument(BaseModel):
    """
    Base class in the hierarchy for representing the full economic definition of instruments in LUSID.  These definitions are used to provide instrument analytics such as PV, accrual, cash flows, and risk.  This base class should not be directly instantiated; each supported InstrumentType has a corresponding inherited class.  # noqa: E501
    """
    instrument_type:  StrictStr = Field(...,alias="instrumentType", description="The available values are: QuotedSecurity, InterestRateSwap, FxForward, Future, ExoticInstrument, FxOption, CreditDefaultSwap, InterestRateSwaption, Bond, EquityOption, FixedLeg, FloatingLeg, BespokeCashFlowsLeg, Unknown, TermDeposit, ContractForDifference, EquitySwap, CashPerpetual, CapFloor, CashSettled, CdsIndex, Basket, FundingLeg, FxSwap, ForwardRateAgreement, SimpleInstrument, Repo, Equity, ExchangeTradedOption, ReferenceInstrument, ComplexBond, InflationLinkedBond, InflationSwap, SimpleCashFlowLoan, TotalReturnSwap, InflationLeg, FundShareClass, FlexibleLoan, UnsettledCash, Cash, MasteredInstrument, LoanFacility, FlexibleDeposit, FlexibleRepo") 
    __properties = ["instrumentType"]

    @validator('instrument_type')
    def instrument_type_validate_enum(cls, value):
        """Validates the enum"""

        # Finbourne have removed enum validation on all models, except for this use case:
        # Workflow and notification application SDK use the property name 'type' as the discriminator on a number of classes.
        # During instantiation, the value of 'type' is checked against the enum values, 
        

        # check it's a class that uses the 'type' property as a discriminator
        # list of classes can be found by searching for 'actual_instance: Union[' in the generated code
        if 'LusidInstrument' not in [ 
                                    # For notification application classes
                                    'AmazonSqsNotificationType',
                                    'AmazonSqsNotificationTypeResponse',
                                    'AmazonSqsPrincipalAuthNotificationType',
                                    'AmazonSqsPrincipalAuthNotificationTypeResponse',
                                    'AzureServiceBusTypeResponse',
                                    'AzureServiceBusNotificationType',
                                    'EmailNotificationType',
                                    'EmailNotificationTypeResponse',
                                    'SmsNotificationType',
                                    'SmsNotificationTypeResponse',
                                    'WebhookNotificationType',
                                    'WebhookNotificationTypeResponse',
                        
                                    # For workflow application classes
                                    'CreateChildTasksAction', 
                                    'RunWorkerAction', 
                                    'TriggerParentTaskAction',
                                    'CreateChildTasksActionResponse', 
                                    'RunWorkerActionResponse',
                                    'TriggerParentTaskActionResponse',
                                    'CreateNewTaskActivity',
                                    'UpdateMatchingTasksActivity',
                                    'CreateNewTaskActivityResponse', 
                                    'UpdateMatchingTasksActivityResponse',
                                    'Fail', 
                                    'GroupReconciliation', 
                                    'HealthCheck', 
                                    'LuminesceView', 
                                    'SchedulerJob', 
                                    'Sleep',
                                    'FailResponse', 
                                    'GroupReconciliationResponse', 
                                    'HealthCheckResponse', 
                                    'LuminesceViewResponse', 
                                    'SchedulerJobResponse', 
                                    'SleepResponse']:
           return value
        
        # Only validate the 'type' property of the class
        if "instrument_type" != "type":
            return value

        if value not in ('QuotedSecurity', 'InterestRateSwap', 'FxForward', 'Future', 'ExoticInstrument', 'FxOption', 'CreditDefaultSwap', 'InterestRateSwaption', 'Bond', 'EquityOption', 'FixedLeg', 'FloatingLeg', 'BespokeCashFlowsLeg', 'Unknown', 'TermDeposit', 'ContractForDifference', 'EquitySwap', 'CashPerpetual', 'CapFloor', 'CashSettled', 'CdsIndex', 'Basket', 'FundingLeg', 'FxSwap', 'ForwardRateAgreement', 'SimpleInstrument', 'Repo', 'Equity', 'ExchangeTradedOption', 'ReferenceInstrument', 'ComplexBond', 'InflationLinkedBond', 'InflationSwap', 'SimpleCashFlowLoan', 'TotalReturnSwap', 'InflationLeg', 'FundShareClass', 'FlexibleLoan', 'UnsettledCash', 'Cash', 'MasteredInstrument', 'LoanFacility', 'FlexibleDeposit', 'FlexibleRepo'):
            raise ValueError("must be one of enum values ('QuotedSecurity', 'InterestRateSwap', 'FxForward', 'Future', 'ExoticInstrument', 'FxOption', 'CreditDefaultSwap', 'InterestRateSwaption', 'Bond', 'EquityOption', 'FixedLeg', 'FloatingLeg', 'BespokeCashFlowsLeg', 'Unknown', 'TermDeposit', 'ContractForDifference', 'EquitySwap', 'CashPerpetual', 'CapFloor', 'CashSettled', 'CdsIndex', 'Basket', 'FundingLeg', 'FxSwap', 'ForwardRateAgreement', 'SimpleInstrument', 'Repo', 'Equity', 'ExchangeTradedOption', 'ReferenceInstrument', 'ComplexBond', 'InflationLinkedBond', 'InflationSwap', 'SimpleCashFlowLoan', 'TotalReturnSwap', 'InflationLeg', 'FundShareClass', 'FlexibleLoan', 'UnsettledCash', 'Cash', 'MasteredInstrument', 'LoanFacility', 'FlexibleDeposit', 'FlexibleRepo')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name = 'instrumentType'

    # discriminator mappings
    __discriminator_value_class_map = {
        'Basket': 'Basket',
        'Bond': 'Bond',
        'CapFloor': 'CapFloor',
        'Cash': 'Cash',
        'CashPerpetual': 'CashPerpetual',
        'CdsIndex': 'CdsIndex',
        'ComplexBond': 'ComplexBond',
        'ContractForDifference': 'ContractForDifference',
        'CreditDefaultSwap': 'CreditDefaultSwap',
        'Equity': 'Equity',
        'EquityOption': 'EquityOption',
        'EquitySwap': 'EquitySwap',
        'ExchangeTradedOption': 'ExchangeTradedOption',
        'ExoticInstrument': 'ExoticInstrument',
        'FixedLeg': 'FixedLeg',
        'FlexibleDeposit': 'FlexibleDeposit',
        'FlexibleLoan': 'FlexibleLoan',
        'FlexibleRepo': 'FlexibleRepo',
        'FloatingLeg': 'FloatingLeg',
        'ForwardRateAgreement': 'ForwardRateAgreement',
        'FundShareClass': 'FundShareClass',
        'FundingLeg': 'FundingLeg',
        'Future': 'Future',
        'FxForward': 'FxForward',
        'FxOption': 'FxOption',
        'FxSwap': 'FxSwap',
        'InflationLeg': 'InflationLeg',
        'InflationLinkedBond': 'InflationLinkedBond',
        'InflationSwap': 'InflationSwap',
        'InstrumentLeg': 'InstrumentLeg',
        'InterestRateSwap': 'InterestRateSwap',
        'InterestRateSwaption': 'InterestRateSwaption',
        'LoanFacility': 'LoanFacility',
        'MasteredInstrument': 'MasteredInstrument',
        'ReferenceInstrument': 'ReferenceInstrument',
        'Repo': 'Repo',
        'SimpleCashFlowLoan': 'SimpleCashFlowLoan',
        'SimpleInstrument': 'SimpleInstrument',
        'TermDeposit': 'TermDeposit',
        'TotalReturnSwap': 'TotalReturnSwap'
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict) -> str:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Union(Basket, Bond, CapFloor, Cash, CashPerpetual, CdsIndex, ComplexBond, ContractForDifference, CreditDefaultSwap, Equity, EquityOption, EquitySwap, ExchangeTradedOption, ExoticInstrument, FlexibleDeposit, FlexibleLoan, FlexibleRepo, ForwardRateAgreement, FundShareClass, Future, FxForward, FxOption, FxSwap, InflationLeg, InflationLinkedBond, InflationSwap, InstrumentLeg, InterestRateSwap, InterestRateSwaption, LoanFacility, MasteredInstrument, ReferenceInstrument, Repo, SimpleCashFlowLoan, SimpleInstrument, TermDeposit, TotalReturnSwap):
        """Create an instance of LusidInstrument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Union(Basket, Bond, CapFloor, Cash, CashPerpetual, CdsIndex, ComplexBond, ContractForDifference, CreditDefaultSwap, Equity, EquityOption, EquitySwap, ExchangeTradedOption, ExoticInstrument, FlexibleDeposit, FlexibleLoan, FlexibleRepo, ForwardRateAgreement, FundShareClass, Future, FxForward, FxOption, FxSwap, InflationLeg, InflationLinkedBond, InflationSwap, InstrumentLeg, InterestRateSwap, InterestRateSwaption, LoanFacility, MasteredInstrument, ReferenceInstrument, Repo, SimpleCashFlowLoan, SimpleInstrument, TermDeposit, TotalReturnSwap):
        """Create an instance of LusidInstrument from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type:
            klass = getattr(lusid.models, object_type)
            return klass.from_dict(obj)
        else:
            raise ValueError("LusidInstrument failed to lookup discriminator value from " +
                             json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                             ", mapping: " + json.dumps(cls.__discriminator_value_class_map))
