# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field 
from lusid.models.share_class_breakdown import ShareClassBreakdown
from lusid.models.share_class_details import ShareClassDetails

class ShareClassData(BaseModel):
    """
    The data for a Share Class. Includes Valuation Point Data and instrument information.  # noqa: E501
    """
    share_class_breakdown: ShareClassBreakdown = Field(..., alias="shareClassBreakdown")
    share_class_details: Optional[ShareClassDetails] = Field(None, alias="shareClassDetails")
    __properties = ["shareClassBreakdown", "shareClassDetails"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ShareClassData:
        """Create an instance of ShareClassData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of share_class_breakdown
        if self.share_class_breakdown:
            _dict['shareClassBreakdown'] = self.share_class_breakdown.to_dict()
        # override the default output from pydantic by calling `to_dict()` of share_class_details
        if self.share_class_details:
            _dict['shareClassDetails'] = self.share_class_details.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ShareClassData:
        """Create an instance of ShareClassData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ShareClassData.parse_obj(obj)

        _obj = ShareClassData.parse_obj({
            "share_class_breakdown": ShareClassBreakdown.from_dict(obj.get("shareClassBreakdown")) if obj.get("shareClassBreakdown") is not None else None,
            "share_class_details": ShareClassDetails.from_dict(obj.get("shareClassDetails")) if obj.get("shareClassDetails") is not None else None
        })
        return _obj
