# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr 

class TransactionTypeCalculation(BaseModel):
    """
    TransactionTypeCalculation
    """
    type:  StrictStr = Field(...,alias="type", description="The type of calculation to perform") 
    side:  Optional[StrictStr] = Field(None,alias="side", description="The side to which the calculation is applied") 
    formula:  Optional[StrictStr] = Field(None,alias="formula", description="The formula used to derive the total consideration amount when it is not provided on the transaction") 
    __properties = ["type", "side", "formula"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionTypeCalculation:
        """Create an instance of TransactionTypeCalculation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if side (nullable) is None
        # and __fields_set__ contains the field
        if self.side is None and "side" in self.__fields_set__:
            _dict['side'] = None

        # set to None if formula (nullable) is None
        # and __fields_set__ contains the field
        if self.formula is None and "formula" in self.__fields_set__:
            _dict['formula'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionTypeCalculation:
        """Create an instance of TransactionTypeCalculation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionTypeCalculation.parse_obj(obj)

        _obj = TransactionTypeCalculation.parse_obj({
            "type": obj.get("type"),
            "side": obj.get("side"),
            "formula": obj.get("formula")
        })
        return _obj
