"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
/**
 * Use a Lamda Function as the destination for a log subscription
 */
class LambdaDestination {
    constructor(fn) {
        this.fn = fn;
    }
    bind(scope, logGroup) {
        const arn = logGroup.logGroupArn;
        this.fn.addPermission('CanInvokeLambda', {
            principal: new iam.ServicePrincipal(`logs.amazonaws.com`),
            sourceArn: arn,
            // Using SubScription Filter as scope is okay, since every Subscription Filter has only
            // one destination.
            scope
        });
        return { arn: this.fn.functionArn };
    }
}
exports.LambdaDestination = LambdaDestination;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQXdDO0FBS3hDOztHQUVHO0FBQ0gsTUFBYSxpQkFBaUI7SUFDNUIsWUFBNkIsRUFBb0I7UUFBcEIsT0FBRSxHQUFGLEVBQUUsQ0FBa0I7SUFDakQsQ0FBQztJQUVNLElBQUksQ0FBQyxLQUFnQixFQUFFLFFBQXdCO1FBQ3BELE1BQU0sR0FBRyxHQUFHLFFBQVEsQ0FBQyxXQUFXLENBQUM7UUFFakMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsaUJBQWlCLEVBQUU7WUFDdkMsU0FBUyxFQUFFLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9CQUFvQixDQUFDO1lBQ3pELFNBQVMsRUFBRSxHQUFHO1lBQ2QsdUZBQXVGO1lBQ3ZGLG1CQUFtQjtZQUNuQixLQUFLO1NBQ04sQ0FBQyxDQUFDO1FBQ0gsT0FBTyxFQUFFLEdBQUcsRUFBRSxJQUFJLENBQUMsRUFBRSxDQUFDLFdBQVcsRUFBRSxDQUFDO0lBQ3RDLENBQUM7Q0FDRjtBQWhCRCw4Q0FnQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBsb2dzIGZyb20gJ0Bhd3MtY2RrL2F3cy1sb2dzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4vKipcbiAqIFVzZSBhIExhbWRhIEZ1bmN0aW9uIGFzIHRoZSBkZXN0aW5hdGlvbiBmb3IgYSBsb2cgc3Vic2NyaXB0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBMYW1iZGFEZXN0aW5hdGlvbiBpbXBsZW1lbnRzIGxvZ3MuSUxvZ1N1YnNjcmlwdGlvbkRlc3RpbmF0aW9uIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBmbjogbGFtYmRhLklGdW5jdGlvbikge1xuICB9XG5cbiAgcHVibGljIGJpbmQoc2NvcGU6IENvbnN0cnVjdCwgbG9nR3JvdXA6IGxvZ3MuSUxvZ0dyb3VwKTogbG9ncy5Mb2dTdWJzY3JpcHRpb25EZXN0aW5hdGlvbkNvbmZpZyB7XG4gICAgY29uc3QgYXJuID0gbG9nR3JvdXAubG9nR3JvdXBBcm47XG5cbiAgICB0aGlzLmZuLmFkZFBlcm1pc3Npb24oJ0Nhbkludm9rZUxhbWJkYScsIHtcbiAgICAgIHByaW5jaXBhbDogbmV3IGlhbS5TZXJ2aWNlUHJpbmNpcGFsKGBsb2dzLmFtYXpvbmF3cy5jb21gKSxcbiAgICAgIHNvdXJjZUFybjogYXJuLFxuICAgICAgLy8gVXNpbmcgU3ViU2NyaXB0aW9uIEZpbHRlciBhcyBzY29wZSBpcyBva2F5LCBzaW5jZSBldmVyeSBTdWJzY3JpcHRpb24gRmlsdGVyIGhhcyBvbmx5XG4gICAgICAvLyBvbmUgZGVzdGluYXRpb24uXG4gICAgICBzY29wZVxuICAgIH0pO1xuICAgIHJldHVybiB7IGFybjogdGhpcy5mbi5mdW5jdGlvbkFybiB9O1xuICB9XG59XG4iXX0=