from enum import IntEnum


class AISMessageType(IntEnum):
    """
    @summary: AIS message type name
    """
    T1_POSITION_REPORT = 1
    T2_POSITION_REPORT = 2
    T3_POSITION_REPORT = 3
    T4_BASE_STATION_REPORT = 4
    T5_SHIP_STATIC_DATA = 5
    T6_ADDRESSED_BINARY_MESSAGE = 6
    T7_BINARY_ACKNOWLEGDE = 7
    T8_BINARY_BROADCAST_MESSAGE = 8
    T9_STANDARD_SAR_AIRCRAFT_POSITION_REPORT = 9
    T10_COORDINATED_UTC_INQUIRY = 10
    T11_BASE_STATION_REPORT = 11
    T12_ADDRESSED_SAFETY_RELATED_MESSAGE = 12
    T13_BINARY_ACKNOWLEGDE = 13
    T14_SAFETY_RELATED_BROADCAST_MESSAGE = 14
    T15_INTERROGATION = 15
    T16_ASSIGNED_MODE_COMMAND = 16
    T17_GNSS_BROADCAST_BINARY_MESSAGE = 17
    T18_STANDARD_CLASS_B_POSITION_REPORT = 18
    T19_EXTENDED_CLASS_B_POSITION_REPORT = 19
    T20_DATA_LINK_MANAGEMENT = 20
    T21_AIDS_TO_NAVIGATION_REPORT = 21
    T22_CHANNEL_MANAGEMENT = 22
    T23_GROUP_ASSIGNMENT_COMMAND = 23
    T24_STATIC_DATA_REPORT = 24
    T25_SINGLE_SLOT_BINARY_MESSAGE = 25
    T26_MULTIPLE_SLOT_BINARY_MESSAGE = 26
    T27_LONG_RANG_AIS_BROADCAST_MESSAGE = 27
    
    
    