#################################################
# HolAdo (Holistic Automation do)
#
# (C) Copyright 2021-2025 by Eric Klumpp
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

# The Software is provided “as is”, without warranty of any kind, express or implied, including but not limited to the warranties of merchantability, fitness for a particular purpose and noninfringement. In no event shall the authors or copyright holders be liable for any claim, damages or other liability, whether in an action of contract, tort or otherwise, arising from, out of or in connection with the software or the use or other dealings in the Software.
#################################################

from flask.views import MethodView
from holado.common.context.session_context import SessionContext
import os
import logging

logger = logging.getLogger(__name__)


def _get_session_context():
    return SessionContext.instance()


class EnvView(MethodView):
    
    def get(self, body: list):
        try:
            return [os.getenv(name) for name in body]
        except Exception as exc:
            logger.exception(f"Failed to get environment variable values (names: {body})")
            return str(exc), 500


class LsView(MethodView):
    
    def get(self, body: dict):
        try:
            dir_path = body['path']
            extension = body.get('extension', None)
            
            if not os.path.exists(dir_path) or not os.path.isdir(dir_path):
                return f"Directory '{dir_path}' doesn't exist", 406
            
            res = []
            for filename in os.listdir(dir_path):
                if extension is not None and not filename.endswith(extension):
                    continue
                if os.path.isfile(os.path.join(dir_path, filename)):
                    res.append(filename)
            
            return res
        except Exception as exc:
            logger.exception(f"Failed to list directory (parameters: {body})")
            return str(exc), 500



