from os import path

from platformdirs import PlatformDirs

dirs = PlatformDirs("rovr", ".")  # Ah yes, my name is "."

VAR_TO_DIR = {
    "DOCUMENTS": dirs.user_documents_dir.replace("\\", "/"),
    "DOWNLOADS": dirs.user_downloads_dir.replace("\\", "/"),
    "MUSIC": dirs.user_music_dir.replace("\\", "/"),
    "PICTURES": dirs.user_pictures_dir.replace("\\", "/"),
    "DESKTOP": dirs.user_desktop_dir.replace("\\", "/"),
    "HOME": path.expanduser("~").replace("\\", "/"),
    "VIDEOS": dirs.user_videos_dir.replace("\\", "/"),
    "CONFIG": dirs.user_config_dir.replace("\\", "/"),
}

ASCII_ICONS = {
    "general": {
        "new": ["+", "green"],
        "open": ["O", "blue"],
        "save": ["S", "cyan"],
        "search": ["?", "orange"],
        "refresh": ["R", "teal"],
        "settings": ["#", "gray"],
        "close": ["X", "red"],
        "up": ["^", "white"],
        "down": ["v", "white"],
        "left": ["<", "white"],
        "right": [">", "white"],
        "home": ["~", "indigo"],
        "check": ["/", "white"],
        "copy": ["C", "white"],
        "paste": ["P", "white"],
        "cut": ["X", "white"],
        "rename": ["R", "white"],
        "delete": ["D", "red"],
        "zip": ["Z", "yellow"],
    },
    "folder": {
        "default": ["D", "#DAA520"],
        "open": ["O", "orange"],
        "empty": ["E", "yellow"],
        "home": ["~", "cyan"],
        ":/drive:": ["D", "white"],
    },
    "file": {
        "default": ["F", "#ffffff"],
    },
}

# We are kind of stuck without the ability to use surrogate Unicode characters, because I have no idea how they work...
ICONS = {
    "general": {
        "new": ["\uea7f", "green"],
        "open": ["\uf07c", "blue"],
        "save": ["\uf0c7", "cyan"],
        "search": ["\uf002", "orange"],
        "refresh": ["\uf021", "teal"],
        "settings": ["\uf013", "gray"],
        "close": ["\uf00d", "red"],
        "up": ["\uf062", "white"],
        "down": ["\uf063", "white"],
        "left": ["\uf060", "white"],
        "right": ["\uf061", "white"],
        "home": ["\uf015", "indigo"],
        "check": ["\uf00c", "green"],
        "copy": ["\uf0c5", "white"],
        "paste": ["\uf429", "white"],
        "cut": ["\uf0c4", "white"],
        "rename": ["\uf246", "white"],
        "delete": ["\uf014", "red"],
        "zip": ["\uf410", "yellow"],
    },
    "folder": {
        "default": ["\uf07b", "#DAA520"],
        "open": ["\uf07c", "orange"],
        "empty": ["\uf115", "yellow"],
        "documents": ["\uf02d", "coral"],
        "downloads": ["\uf019", "lime"],
        "music": ["\uf001", "magenta"],
        "pictures": ["\uf03e", "purple"],
        "videos": ["\uf03d", "violet"],
        "git": ["\ue5fb", "red"],
        "github": ["\uf09b", "black"],
        "hidden": ["\uf7c9", "gray"],
        "node_modules": ["\ue5fa", "green"],
        "rovr": ["\uf14e", "teal"],
        "home": ["\uf015", "cyan"],
        ":/drive:": ["\uf0a0", "white"],  # literally impossible to name a folder this
    },
    # shout out to https://github.com/acarl005/ls-go
    "file": {
        "default": ["\uf15b", "#ffffff"],
        "ai": ["\ue669", "#ce6f14"],
        "android": ["\uf17b", "#a7c83f"],
        "apple": ["\ue711", "#78909c"],
        "asm": ["\ue6ab", "#ff7844"],
        "audio": ["\uf001", "#ee524f"],
        "binary": ["\uf471", "#ff7844"],
        "c": ["\ue649", "#0188d2"],
        "cfg": ["\ue615", "#8B8B8B"],
        "clj": ["\ue76a", "#68b338"],
        "conf": ["\ue615", "#8B8B8B"],
        "cpp": ["\ue646", "#0188d2"],
        "css": ["\uf13c", "#2d53e5"],
        "dart": ["\ue64c", "#03589b"],
        "db": ["\uf1c0", "#FF8400"],
        "deb": ["\ue77d", "#ab0836"],
        "doc": ["\ue6a5", "#295394"],
        "dockerfile": ["\uf21f", "#099cec"],
        "ebook": ["\uf02d", "#67b500"],
        "env": ["\uf462", "#eed645"],
        "f": ["\uf24f", "#8e44ad"],
        "font": ["\uf031", "#3498db"],
        "fs": ["\ue7a7", "#2ecc71"],
        "gb": ["\ue272", "#f1c40f"],
        "gform": ["\uf298", "#9b59b6"],
        "git": ["\ue702", "#e67e22"],
        "go": ["\ue627", "#6ed8e5"],
        "graphql": ["\ue662", "#e74c3c"],
        "groovy": ["\ue775", "#2ecc71"],
        "gruntfile.js": ["\ue74c", "#3498db"],
        "gulpfile.js": ["\ue610", "#e67e22"],
        "gv": ["\ue225", "#9b59b6"],
        "h": ["\uf0fd", "#3498db"],
        "haml": ["\ue664", "#9b59b6"],
        "hs": ["\ue777", "#2980b9"],
        "html": ["\uf13b", "#e67e22"],
        "hx": ["\ue666", "#e74c3c"],
        "ics": ["\uf073", "#f1c40f"],
        "image": ["\uf1c5", "#e74c3c"],
        "iml": ["\ue7b5", "#3498db"],
        "ini": ["\ue615", "#f1c40f"],
        "ino": ["\ue255", "#2ecc71"],
        "iso": ["\uede9", "#f1c40f"],
        "jade": ["\ue66c", "#9b59b6"],
        "java": ["\ue738", "#5382a1"],
        "jenkinsfile": ["\ue767", "#e74c3c"],
        "jl": ["\ue624", "#2ecc71"],
        "js": ["\ue781", "#f39c12"],
        "json": ["\ue60b", "#f1c40f"],
        "jsx": ["\ue7ba", "#e67e22"],
        "key": ["\uf43d", "#f1c40f"],
        "ko": ["\uebc6", "#9b59b6"],
        "kt": ["\ue634", "#2980b9"],
        "less": ["\ue758", "#3498db"],
        "lock": ["\uf023", "#f1c40f"],
        "log": ["\uf18d", "#7f8c8d"],
        "lua": ["\ue620", "#e74c3c"],
        "maintainers": ["\uf0c0", "#7f8c8d"],
        "makefile": ["\ue20f", "#3498db"],
        "markdown": ["\uf48a", "#7f8c8d"],
        "mjs": ["\ue718", "#f39c12"],
        "ml": ["\ue82d", "#2ecc71"],
        "mustache": ["\ue60f", "#e67e22"],
        "nc": ["\U000f02c1", "#f1c40"],
        "nim": ["\ue677", "#3498db"],
        "nix": ["\uf313", "#f39c12"],
        "npmignore": ["\ue71e", "#e74c3c"],
        "package": ["\U000f03d7", "#9b59b6"],
        "passwd": ["\uf023", "#f1c40f"],
        "patch": ["\uf440", "#e67e22"],
        "pdf": ["\uf1c1", "#d35400"],
        "php": ["\ue608", "#9b59b6"],
        "pl": ["\ue7a1", "#3498db"],
        "prisma": ["\ue684", "#9b59b6"],
        "ppt": ["\uf1c4", "#c0392b"],
        "psd": ["\ue7b8", "#3498db"],
        "py": ["\ue606", "#FFD43B"],
        "r": ["\ue68a", "#9b59b6"],
        "rb": ["\ue21e", "#9b59b6"],
        "rdb": ["\ue76d", "#9b59b6"],
        "rpm": ["\uf17c", "#d35400"],
        "rs": ["\ue7a8", "#f39c12"],
        "rss": ["\uf09e", "#c0392b"],
        "rst": ["\U000f016b", "#2ecc71"],
        "rubydoc": ["\ue73b", "#e67e22"],
        "sass": ["\ue603", "#e74c3c"],
        "scala": ["\ue737", "#e67e22"],
        "shell": ["\uf489", "#2ecc71"],
        "shp": ["\U000f065e", "#f1c40f"],
        "sol": ["\U000f086a", "#3498db"],
        "sqlite": ["\ue7c4", "#27ae60"],
        "styl": ["\ue600", "#e74c3c"],
        "svelte": ["\ue697", "#ff3e00"],
        "swift": ["\ue755", "#ff6f61"],
        "tex": ["\u222b", "#9b59b6"],
        "text": ["\uf15c", "ffffff"],
        "tf": ["\ue69a", "#2ecc71"],
        "toml": ["\U000f016a", "#f39c12"],
        "ts": ["\U000f06e6", "#2980b9"],
        "twig": ["\ue61c", "#9b59b6"],
        "txt": ["\uf15c", "#7f8c8d"],
        "vagrantfile": ["\ue21e", "#3498db"],
        "video": ["\uf03d", "#c0392b"],
        "vim": ["\ue62b", "#019833"],
        "vue": ["\ue6a0", "#41b883"],
        "windows": ["\uf17a", "#4a90e2"],
        "xls": ["\uf1c3", "#27ae60"],
        "xml": ["\ue796", "#3498db"],
        "yml": ["\ue601", "#f39c12"],
        "*": ["\ue8eb", "#f36c62"],
        "zig": ["\ue6a9", "#9b59b6"],
        "zip": ["\uf410", "#e74c3c"],
    },
}

FOLDER_MAP = {
    # documents
    "documents": "documents",
    "docs": "documents",
    # downloads
    "downloads": "downloads",
    "download": "downloads",
    # music
    "music": "music",
    "audio": "music",
    "songs": "music",
    "sounds": "music",
    # pictures
    "pictures": "pictures",
    "photos": "pictures",
    "images": "pictures",
    "assets": "pictures",
    "textures": "pictures",
    # videos
    "videos": "videos",
    "movies": "videos",
    # git
    ".git": "git",
    ".github": "github",
    # other stuff
    "node_modules": "node_modules",
    "rovr": "rovr",
    "home": "home",
}

FILE_MAP = {
    # Text files
    ".txt": "txt",
    ".log": "log",
    ".md": "markdown",
    ".markdown": "markdown",
    ".rst": "rst",
    ".text": "text",
    # Image files
    ".jpg": "image",
    ".jpeg": "image",
    ".png": "image",
    ".gif": "image",
    ".bmp": "image",
    ".svg": "image",
    ".webp": "image",
    ".psd": "psd",
    ".ai": "ai",
    # Audio files
    ".mp3": "audio",
    ".wav": "audio",
    ".flac": "audio",
    ".ogg": "audio",
    ".m4a": "audio",
    ".opus": "audio",
    # Video files
    ".mp4": "video",
    ".avi": "video",
    ".mkv": "video",
    ".mov": "video",
    # Document files
    ".pdf": "pdf",
    ".doc": "doc",
    ".ppt": "ppt",
    ".xls": "xls",
    ".gform": "gform",
    ".key": "key",
    ".ics": "ics",
    # Ebook files
    ".ebook": "ebook",
    # Archive files
    ".zip": "zip",
    ".rar": "zip",
    ".tar": "zip",
    ".tar.gz": "zip",
    ".tgz": "zip",
    ".tar.bz2": "zip",
    ".tbz2": "zip",
    ".tar.xz": "zip",
    ".7z": "zip",
    ".deb": "deb",
    ".rpm": "rpm",
    ".iso": "iso",
    # Programming languages
    ".py": "py",
    ".pyc": "py",
    ".pyw": "py",
    ".js": "js",
    ".mjs": "mjs",
    ".jsx": "jsx",
    ".ts": "ts",
    ".tsx": "ts",
    ".html": "html",
    ".htm": "html",
    ".css": "css",
    ".tcss": "css",
    ".scss": "sass",
    ".sass": "sass",
    ".less": "less",
    ".styl": "styl",
    ".json": "json",
    ".go": "go",
    ".rs": "rs",
    ".rlib": "rs",
    ".c": "c",
    ".h": "h",
    ".cs": "c",
    ".cpp": "cpp",
    ".cc": "cpp",
    ".hpp": "cpp",
    ".java": "java",
    ".jar": "java",
    ".kt": "kt",
    ".kts": "kt",
    ".hs": "hs",
    ".lhs": "hs",
    ".swift": "swift",
    ".vue": "vue",
    ".php": "php",
    ".rb": "rb",
    ".pl": "pl",
    ".lua": "lua",
    ".clj": "clj",
    ".groovy": "groovy",
    ".dart": "dart",
    ".f": "f",
    ".fs": "fs",
    ".r": "r",
    ".rdb": "rdb",
    ".scala": "scala",
    ".sol": "sol",
    ".svelte": "svelte",
    ".vim": "vim",
    ".zig": "zig",
    ".nim": "nim",
    ".nix": "nix",
    ".ml": "ml",
    ".hx": "hx",
    ".haml": "haml",
    ".jade": "jade",
    ".twig": "twig",
    ".mustache": "mustache",
    ".tex": "tex",
    ".sh": "shell",
    ".shell": "shell",
    ".zsh": "shell",
    ".bash": "shell",
    ".fish": "shell",
    ".asm": "asm",
    # Config files
    ".ini": "ini",
    ".conf": "conf",
    ".cfg": "cfg",
    ".yaml": "yaml",
    ".yml": "yml",
    ".toml": "toml",
    ".lock": "lock",
    ".env": "env",
    ".npmrc": "npmignore",
    ".editorconfig": "conf",
    # Git
    ".gitignore": "git",
    ".gitattributes": "git",
    ".gitmodules": "git",
    # Binary files
    ".bin": "binary",
    ".exe": "windows",
    ".dll": "windows",
    ".so": "binary",
    ".o": "binary",
    # Certificates
    ".crt": "key",
    ".pem": "key",
    ".cer": "key",
    # Other
    ".patch": "patch",
    ".diff": "patch",
    ".db": "db",
    ".sqlite": "sqlite",
    ".xml": "xml",
    ".iml": "iml",
    ".graphql": "graphql",
    ".prisma": "prisma",
    ".tf": "tf",
    ".font": "font",
    ".gb": "gb",
    ".glp": "glp",
    ".gv": "gv",
    ".ino": "ino",
    ".ko": "ko",
    ".nc": "nc",
    ".shp": "shp",
}

EXT_TO_LANG_MAP = {
    ".py": "python",
    ".md": "markdown",
    ".json": "json",
    ".toml": "toml",
    ".yaml": "yaml",
    ".yml": "yaml",
    ".html": "html",
    ".css": "css",
    ".js": "javascript",
    ".rs": "rust",
    ".go": "go",
    ".sql": "sql",
    ".java": "java",
    ".sh": "bash",
    ".xml": "xml",
    ".lock": "toml",
}

FILES_MAP = {
    "pyproject.toml": "package",
    "cargo.lock": "package",
    "package.json": "package",
    "package-lock.json": "package",
    "dockerfile": "dockerfile",
    "gruntfile.js": "gruntfile.js",
    "gulpfile.js": "gulpfile.js",
    "makefile": "makefile",
    "vagrantfile": "vagrantfile",
    "jenkinsfile": "jenkinsfile",
    ".npmignore": "npmignore",
    "npmignore": "npmignore",
    "maintainers": "maintainers",
    "rubydoc": "rubydoc",
    "gemfile": "rb",
    "gemfile.lock": "lock",
    "passwd": "passwd",
    "py.typed": "py",
}

ARCHIVE_EXTENSIONS = [
    ".zip",
    ".tar",
    ".gz",
    ".bz2",
    ".xz",
    ".7z",
]

PIL_EXTENSIONS = [
    # reminder that stuff can also not work, just remove it if it doesnt work
    ".avif",
    ".bmp",
    ".dds",
    ".eps",
    ".ps",
    ".gif",
    ".icns",
    ".ico",
    ".im",
    ".jpg",
    ".jpeg",
    ".jpe",
    ".msp",
    ".pcx",
    ".png",
    ".pbm",
    ".pgm",
    ".ppm",
    ".pnm",
    ".sgi",
    ".rgb",
    ".rgba",
    ".bw",
    ".spi",
    ".tga",
    ".tif",
    ".tiff",
    ".webp",
    ".xbm",
    ".j2k",
    ".jp2",
    ".jpx",
    ".j2c",
    ".jxr",
    ".wdp",
    ".apng",
    ".fit",
    ".fits",
    ".flif",
    ".ftex",
    ".heic",
    ".heif",
    ".mim",
    ".mpo",
    ".psd",
    ".palm",
    ".pxr",
    ".qoi",
    ".tim",
]


TOGGLE_BUTTON_ICONS = {
    "left": " ",
    "right": "",
    "inner": "\ue640",
    "inner_filled": "\uf4a7",
}

ASCII_TOGGLE_BUTTON_ICONS = {
    "left": " ",
    "right": "",
    "inner": "O",
    "inner_filled": "X",
}

BORDER_BOTTOM = {
    "ascii": "-",
    "blank": " ",
    "dashed": "╍",
    "double": "═",
    "heavy": "━",
    "hidden": " ",
    "none": " ",
    "hkey": "▁",
    "inner": "▀",
    "outer": "▄",
    "panel": "▁",
    "round": "─",
    "solid": "─",
    "tall": "▁",
    "thick": "▄",
    "vkey": "▔",
    "wide": "▔",
}

SPINNER = ["\\", "|", "/", "-"]
