# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
try:
    from pydantic.v1 import BaseModel, Field, StrictStr, constr, validator
except ImportError:
    from pydantic import BaseModel, Field, StrictStr, constr, validator

class CopyPartSource(BaseModel):
    """
    CopyPartSource
    """
    repository: StrictStr = Field(...)
    ref: StrictStr = Field(...)
    path: StrictStr = Field(...)
    range: Optional[constr(strict=True)] = Field(None, description="Range of bytes to copy")
    __properties = ["repository", "ref", "path", "range"]

    @validator('range')
    def range_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^bytes=((\d*-\d*,? ?)+)$", value):
            raise ValueError(r"must validate the regular expression /^bytes=((\d*-\d*,? ?)+)$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CopyPartSource:
        """Create an instance of CopyPartSource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CopyPartSource:
        """Create an instance of CopyPartSource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CopyPartSource.parse_obj(obj)

        _obj = CopyPartSource.parse_obj({
            "repository": obj.get("repository"),
            "ref": obj.get("ref"),
            "path": obj.get("path"),
            "range": obj.get("range")
        })
        return _obj


