# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
try:
    from pydantic.v1 import BaseModel, Field, StrictStr, conlist
except ImportError:
    from pydantic import BaseModel, Field, StrictStr, conlist

class IcebergLocalTable(BaseModel):
    """
    IcebergLocalTable
    """
    namespace: conlist(StrictStr) = Field(..., description="Reference to one or more levels of a namespace")
    table: StrictStr = Field(..., description="Remote table name")
    repository_id: StrictStr = Field(..., description="lakeFS repository ID")
    reference_id: StrictStr = Field(..., description="lakeFS reference ID (branch or commit)")
    __properties = ["namespace", "table", "repository_id", "reference_id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IcebergLocalTable:
        """Create an instance of IcebergLocalTable from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergLocalTable:
        """Create an instance of IcebergLocalTable from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IcebergLocalTable.parse_obj(obj)

        _obj = IcebergLocalTable.parse_obj({
            "namespace": obj.get("namespace"),
            "table": obj.get("table"),
            "repository_id": obj.get("repository_id"),
            "reference_id": obj.get("reference_id")
        })
        return _obj


