# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



try:
    from pydantic.v1 import BaseModel, Field
except ImportError:
    from pydantic import BaseModel, Field
from lakefs_sdk.models.iceberg_local_table import IcebergLocalTable
from lakefs_sdk.models.iceberg_remote_table import IcebergRemoteTable

class IcebergPullRequest(BaseModel):
    """
    IcebergPullRequest
    """
    source: IcebergRemoteTable = Field(...)
    destination: IcebergLocalTable = Field(...)
    __properties = ["source", "destination"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IcebergPullRequest:
        """Create an instance of IcebergPullRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of source
        if self.source:
            _dict['source'] = self.source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of destination
        if self.destination:
            _dict['destination'] = self.destination.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergPullRequest:
        """Create an instance of IcebergPullRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IcebergPullRequest.parse_obj(obj)

        _obj = IcebergPullRequest.parse_obj({
            "source": IcebergRemoteTable.from_dict(obj.get("source")) if obj.get("source") is not None else None,
            "destination": IcebergLocalTable.from_dict(obj.get("destination")) if obj.get("destination") is not None else None
        })
        return _obj


