# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
try:
    from pydantic.v1 import BaseModel, Field, StrictBool
except ImportError:
    from pydantic import BaseModel, Field, StrictBool
from lakefs_sdk.models.iceberg_local_table import IcebergLocalTable
from lakefs_sdk.models.iceberg_remote_table import IcebergRemoteTable

class IcebergPushRequest(BaseModel):
    """
    IcebergPushRequest
    """
    source: IcebergLocalTable = Field(...)
    destination: IcebergRemoteTable = Field(...)
    force_update: Optional[StrictBool] = Field(False, description="Override exiting table in remote if exists")
    create_namespace: Optional[StrictBool] = Field(False, description="Creates namespace in remote catalog if not exist")
    __properties = ["source", "destination", "force_update", "create_namespace"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IcebergPushRequest:
        """Create an instance of IcebergPushRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of source
        if self.source:
            _dict['source'] = self.source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of destination
        if self.destination:
            _dict['destination'] = self.destination.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergPushRequest:
        """Create an instance of IcebergPushRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IcebergPushRequest.parse_obj(obj)

        _obj = IcebergPushRequest.parse_obj({
            "source": IcebergLocalTable.from_dict(obj.get("source")) if obj.get("source") is not None else None,
            "destination": IcebergRemoteTable.from_dict(obj.get("destination")) if obj.get("destination") is not None else None,
            "force_update": obj.get("force_update") if obj.get("force_update") is not None else False,
            "create_namespace": obj.get("create_namespace") if obj.get("create_namespace") is not None else False
        })
        return _obj


