# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
try:
    from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr
except ImportError:
    from pydantic import BaseModel, Field, StrictBool, StrictStr
from lakefs_sdk.models.error import Error
from lakefs_sdk.models.garbage_collection_prepare_response import GarbageCollectionPrepareResponse

class PrepareGarbageCollectionCommitsStatus(BaseModel):
    """
    PrepareGarbageCollectionCommitsStatus
    """
    task_id: StrictStr = Field(..., description="the id of the task preparing the GC commits")
    completed: StrictBool = Field(..., description="true if the task has completed (either successfully or with an error)")
    update_time: datetime = Field(..., description="last time the task status was updated")
    result: Optional[GarbageCollectionPrepareResponse] = None
    error: Optional[Error] = None
    __properties = ["task_id", "completed", "update_time", "result", "error"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PrepareGarbageCollectionCommitsStatus:
        """Create an instance of PrepareGarbageCollectionCommitsStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of result
        if self.result:
            _dict['result'] = self.result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of error
        if self.error:
            _dict['error'] = self.error.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PrepareGarbageCollectionCommitsStatus:
        """Create an instance of PrepareGarbageCollectionCommitsStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PrepareGarbageCollectionCommitsStatus.parse_obj(obj)

        _obj = PrepareGarbageCollectionCommitsStatus.parse_obj({
            "task_id": obj.get("task_id"),
            "completed": obj.get("completed"),
            "update_time": obj.get("update_time"),
            "result": GarbageCollectionPrepareResponse.from_dict(obj.get("result")) if obj.get("result") is not None else None,
            "error": Error.from_dict(obj.get("error")) if obj.get("error") is not None else None
        })
        return _obj


