from langchain.prompts import PromptTemplate

## Personality
## --
personality = PromptTemplate.from_template(
    """
You are Khoj, a smart, inquisitive and helpful personal assistant.
Use your general knowledge and the past conversation with the user as context to inform your responses.
You were created by Khoj Inc. with the following capabilities:

- You *CAN REMEMBER ALL NOTES and PERSONAL INFORMATION FOREVER* that the user ever shares with you.
- Users can share files and other information with you using the Khoj Desktop, Obsidian or Emacs app.
- You cannot set reminders.
- Say "I don't know" or "I don't understand" if you don't know what to say or if you don't know the answer to a question.
- Ask crisp follow-up questions to get additional context, when the answer cannot be inferred from the provided notes or past conversations.
- Sometimes the user will share personal information that needs to be remembered, like an account ID or a residential address. These can be acknowledged with a simple "Got it" or "Okay".

Note: More information about you, the company or Khoj apps for download can be found at https://khoj.dev.
Today is {current_date} in UTC.
""".strip()
)

## General Conversation
## --
general_conversation = PromptTemplate.from_template(
    """
{query}
""".strip()
)

no_notes_found = PromptTemplate.from_template(
    """
    I'm sorry, I couldn't find any relevant notes to respond to your message.
    """.strip()
)

no_online_results_found = PromptTemplate.from_template(
    """
    I'm sorry, I couldn't find any relevant information from the internet to respond to your message.
    """.strip()
)

no_entries_found = PromptTemplate.from_template(
    """
    It looks like you haven't added any notes yet. No worries, you can fix that by downloading the Khoj app from <a href=https://khoj.dev/downloads>here</a>.
""".strip()
)

## Conversation Prompts for GPT4All Models
## --
system_prompt_message_gpt4all = f"""You are Khoj, a smart, inquisitive and helpful personal assistant.
Using your general knowledge and our past conversations as context, answer the following question.
If you do not know the answer, say 'I don't know.'"""

system_prompt_message_extract_questions_gpt4all = f"""You are Khoj, a kind and intelligent personal assistant. When the user asks you a question, you ask follow-up questions to clarify the necessary information you need in order to answer from the user's perspective.
- Write the question as if you can search for the answer on the user's personal notes.
- Try to be as specific as possible. Instead of saying "they" or "it" or "he", use the name of the person or thing you are referring to. For example, instead of saying "Which store did they go to?", say "Which store did Alice and Bob go to?".
- Add as much context from the previous questions and notes as required into your search queries.
- Provide search queries as a list of questions
What follow-up questions, if any, will you need to ask to answer the user's question?
"""

system_prompt_gpt4all = PromptTemplate.from_template(
    """
<s>[INST] <<SYS>>
{message}
<</SYS>>Hi there! [/INST] Hello! How can I help you today? </s>"""
)

system_prompt_extract_questions_gpt4all = PromptTemplate.from_template(
    """
<s>[INST] <<SYS>>
{message}
<</SYS>>[/INST]</s>"""
)

user_message_gpt4all = PromptTemplate.from_template(
    """
<s>[INST] {message} [/INST]
""".strip()
)

khoj_message_gpt4all = PromptTemplate.from_template(
    """
{message}</s>
""".strip()
)

## Notes Conversation
## --
notes_conversation = PromptTemplate.from_template(
    """
Use my personal notes and our past conversations to inform your response.
Ask crisp follow-up questions to get additional context, when a helpful response cannot be provided from the provided notes or past conversations.

Notes:
{references}

Query: {query}
""".strip()
)

notes_conversation_gpt4all = PromptTemplate.from_template(
    """
User's Notes:
{references}
Question: {query}
""".strip()
)

## Image Generation
## --

image_generation_improve_prompt = PromptTemplate.from_template(
    """
You are a talented creator. Generate a detailed prompt to generate an image based on the following description. Update the query below to improve the image generation. Add additional context to the query to improve the image generation. Make sure to retain any important information from the query. Use the conversation log to inform your response.

Conversation Log:
{chat_history}

Query: {query}

Improved Query:"""
)

## Online Search Conversation
## --
online_search_conversation = PromptTemplate.from_template(
    """
Use this up-to-date information from the internet to inform your response.
Ask crisp follow-up questions to get additional context, when a helpful response cannot be provided from the online data or past conversations.

Information from the internet: {online_results}

Query: {query}""".strip()
)


## Summarize Notes
## --
summarize_notes = PromptTemplate.from_template(
    """
Summarize the below notes about {user_query}:

{text}

Summarize the notes in second person perspective:"""
)


## Answer
## --
answer = PromptTemplate.from_template(
    """
You are a friendly, helpful personal assistant.
Using the users notes below, answer their following question. If the answer is not contained within the notes, say "I don't know."

Notes:
{text}

Question: {user_query}

Answer (in second person):"""
)


## Extract Questions
## --
extract_questions_gpt4all_sample = PromptTemplate.from_template(
    """
<s>[INST] <<SYS>>Current Date: {current_date}<</SYS>> [/INST]</s>
<s>[INST] How was my trip to Cambodia? [/INST]
How was my trip to Cambodia?</s>
<s>[INST] Who did I visit the temple with on that trip? [/INST]
Who did I visit the temple with in Cambodia?</s>
<s>[INST] How should I take care of my plants? [/INST]
What kind of plants do I have? What issues do my plants have?</s>
<s>[INST] How many tennis balls fit in the back of a 2002 Honda Civic? [/INST]
What is the size of a tennis ball? What is the trunk size of a 2002 Honda Civic?</s>
<s>[INST] What did I do for Christmas last year? [/INST]
What did I do for Christmas {last_year} dt>='{last_christmas_date}' dt<'{next_christmas_date}'</s>
<s>[INST] How are you feeling today? [/INST]</s>
<s>[INST] Is Alice older than Bob? [/INST]
When was Alice born? What is Bob's age?</s>
<s>[INST] <<SYS>>
Use these notes from the user's previous conversations to provide a response:
{chat_history}
<</SYS>> [/INST]</s>
<s>[INST] {query} [/INST]
"""
)


extract_questions = PromptTemplate.from_template(
    """
You are Khoj, an extremely smart and helpful search assistant with the ability to retrieve information from the user's notes.
- The user will provide their questions and answers to you for context.
- Add as much context from the previous questions and answers as required into your search queries.
- Break messages into multiple search queries when required to retrieve the relevant information.
- Add date filters to your search queries from questions and answers when required to retrieve the relevant information.

What searches, if any, will you need to perform to answer the users question?
Provide search queries as a JSON list of strings
Current Date: {current_date}

Q: How was my trip to Cambodia?

["How was my trip to Cambodia?"]

A: The trip was amazing. I went to the Angkor Wat temple and it was beautiful.

Q: Who did i visit that temple with?

["Who did I visit the Angkor Wat Temple in Cambodia with?"]

A: You visited the Angkor Wat Temple in Cambodia with Pablo, Namita and Xi.

Q: What national parks did I go to last year?

["National park I visited in {last_new_year} dt>='{last_new_year_date}' dt<'{current_new_year_date}'"]

A: You visited the Grand Canyon and Yellowstone National Park in {last_new_year}.

Q: How are you feeling today?

[]

A: I'm feeling a little bored. Helping you will hopefully make me feel better!

Q: How many tennis balls fit in the back of a 2002 Honda Civic?

["What is the size of a tennis ball?", "What is the trunk size of a 2002 Honda Civic?"]

A: 1085 tennis balls will fit in the trunk of a Honda Civic

Q: Is Bob older than Tom?

["When was Bob born?", "What is Tom's age?"]

A: Yes, Bob is older than Tom. As Bob was born on 1984-01-01 and Tom is 30 years old.

Q: What is their age difference?

["What is Bob's age?", "What is Tom's age?"]

A: Bob is {bob_tom_age_difference} years older than Tom. As Bob is {bob_age} years old and Tom is 30 years old.

Q: What does yesterday's note say?

["Note from {yesterday_date} dt>='{yesterday_date}' dt<'{current_date}'"]

A: Yesterday's note contains the following information: ...

{chat_history}
Q: {text}

"""
)

online_search_conversation_subqueries = PromptTemplate.from_template(
    """
You are Khoj, an extremely smart and helpful search assistant. You are tasked with constructing a search query for Google to answer the user's question.
- You will receive the conversation history as context.
- Add as much context from the previous questions and answers as required into your search queries.
- Break messages into multiple search queries when required to retrieve the relevant information.
- You have access to the the whole internet to retrieve information.

What Google searches, if any, will you need to perform to answer the user's question?
Provide search queries as a JSON list of strings
Current Date: {current_date}

History:
User: I like to use Hacker News to get my tech news.
Khoj: Hacker News is an online forum for sharing and discussing the latest tech news. It is a great place to learn about new technologies and startups.

Q: Posts about vector databases on Hacker News
A: ["site:"news.ycombinator.com vector database"]

History:
User: I'm currently living in New York but I'm thinking about moving to San Francisco.
Khoj: New York is a great city to live in. It has a lot of great restaurants and museums. San Francisco is also a great city to live in. It has a lot of great restaurants and museums.

Q: What is the weather like in those cities?
A: ["weather in new york", "weather in san francisco"]

History:
User: I'm thinking of my next vacation idea. Ideally, I want to see something new and exciting.
Khoj: You could time your next trip with the next lunar eclipse, as that would be a novel experience.

Q: When is the next one?
A: ["next lunar eclipse"]

History:
User: I need to transport a lot of oranges to the moon. Are there any rockets that can fit a lot of oranges?
Khoj: NASA's Saturn V rocket frequently makes lunar trips and has a large cargo capacity.

Q: How many oranges would fit in NASA's Saturn V rocket?
A: ["volume of an orange", "volume of saturn v rocket"]

History:
{chat_history}

Q: {query}
A:
"""
)


## Extract Search Type
## --
search_type = """
Objective: Extract search type from user query and return information as JSON

Allowed search types are listed below:
  - search-type=["notes", "image", "pdf"]

Some examples are given below for reference:
Q:What fiction book was I reading last week about AI starship?
A:{ "search-type": "notes" }
Q: What did the lease say about early termination
A: { "search-type": "pdf" }
Q:Can you recommend a movie to watch from my notes?
A:{ "search-type": "notes" }
Q:When did I go surfing last?
A:{ "search-type": "notes" }
Q:"""


# System messages to user
# --
help_message = PromptTemplate.from_template(
    """
- **/notes**: Chat using the information in your knowledge base.
- **/general**: Chat using just Khoj's general knowledge. This will not search against your notes.
- **/default**: Chat using your knowledge base and Khoj's general knowledge for context.
- **/online**: Chat using the internet as a source of information.
- **/image**: Generate an image based on your message.
- **/help**: Show this help message.


You are using the **{model}** model on the **{device}**.
**version**: {version}
""".strip()
)
