/*
 * Decompiled with CFR 0.152.
 */
package neqsim.chemicalreactions.chemicalequilibrium;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import neqsim.chemicalreactions.ChemicalReactionOperations;
import neqsim.chemicalreactions.chemicalequilibrium.ReferencePotComparator;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.commons.math3.optim.MaxIter;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NoFeasibleSolutionException;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LinearProgrammingChemicalEquilibrium
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(LinearProgrammingChemicalEquilibrium.class);
    double[] xEts = null;
    double[][] Amatrix;
    double[] chemRefPot;
    ComponentInterface[] components;
    double[] numbering;
    String[] elements;
    int changes = 0;
    int minChanges = 0;
    int maxChanges = 0;
    ChemicalReactionOperations operations;

    public LinearProgrammingChemicalEquilibrium(double[] chemRefPot, ComponentInterface[] components, String[] elements, ChemicalReactionOperations operations, int phase) {
        int i;
        this.operations = operations;
        this.chemRefPot = chemRefPot;
        this.components = components;
        this.elements = elements;
        this.changes = elements.length;
        this.minChanges = elements.length;
        this.maxChanges = components.length;
        for (i = 0; i < components.length; ++i) {
            components[i].setReferencePotential(chemRefPot[i]);
        }
        if (operations.calcChemRefPot(phase) != null) {
            System.arraycopy(operations.calcChemRefPot(phase), 0, this.chemRefPot, 0, this.chemRefPot.length);
            for (i = 0; i < components.length; ++i) {
                components[i].setReferencePotential(chemRefPot[i]);
            }
        } else {
            do {
                System.out.println("shifting primary components.....");
                this.changePrimaryComponents();
            } while (operations.calcChemRefPot(phase) == null);
            System.arraycopy(operations.calcChemRefPot(phase), 0, this.chemRefPot, 0, this.chemRefPot.length);
            for (i = 0; i < components.length; ++i) {
                components[i].setReferencePotential(chemRefPot[i]);
            }
            Arrays.sort(components, new ReferencePotComparator());
            for (i = 0; i < components.length; ++i) {
                chemRefPot[i] = components[i].getReferencePotential();
            }
        }
        this.Amatrix = this.calcA();
    }

    public double[][] calcA() {
        int A_size = this.components.length - this.operations.getReactionList().getChemicalReactionList().size();
        if (this.elements.length < this.components.length - this.operations.getReactionList().getChemicalReactionList().size()) {
            A_size = this.elements.length;
        }
        A_size = this.elements.length;
        double[][] A = new double[A_size + 1][this.components.length];
        double[][] Am = new double[A_size][this.components.length];
        for (int k = 0; k < A_size; ++k) {
            for (int i = 0; i < this.components.length; ++i) {
                for (int j = 0; j < this.components[i].getElements().getElementNames().length; ++j) {
                    if (!this.components[i].getElements().getElementNames()[j].equals(this.elements[k])) continue;
                    A[k][i] = this.components[i].getElements().getElementCoefs()[j];
                    Am[k][i] = this.components[i].getElements().getElementCoefs()[j];
                }
            }
        }
        for (int i = 0; i < this.components.length; ++i) {
            A[A_size][i] = this.components[i].getIonicCharge();
        }
        return A;
    }

    public double[][] getA() {
        return this.Amatrix;
    }

    public double[] getRefPot() {
        return this.chemRefPot;
    }

    public void changePrimaryComponents() {
        if (this.changes == this.maxChanges && this.minChanges >= 0) {
            this.changes = this.minChanges--;
        }
        ComponentInterface tempComp = this.components[this.minChanges - 1].clone();
        this.components[this.minChanges - 1] = this.components[this.changes].clone();
        this.components[this.changes] = tempComp;
        ++this.changes;
    }

    public void calcx(Matrix atemp, Matrix lagrangeTemp) {
    }

    public double[] generateInitialEstimates(SystemInterface system, double[] bVector, double inertMoles, int phase) {
        int i;
        double rhs = 0.0;
        Matrix mutemp = new Matrix(this.chemRefPot, 1).times(1.0 / (8.3144621 * system.getPhase(phase).getTemperature())).copy();
        double[] v = new double[this.components.length + 1];
        for (i = 0; i < this.components.length; ++i) {
            v[i + 1] = mutemp.get(0, i);
        }
        LinearObjectiveFunction f = new LinearObjectiveFunction(v, 0.0);
        ArrayList<LinearConstraint> cons = new ArrayList<LinearConstraint>();
        for (int j = 0; j < bVector.length; ++j) {
            for (i = 0; i < this.components.length; ++i) {
                v[i + 1] = this.Amatrix[j][i];
            }
            rhs = bVector[j];
            cons.add(new LinearConstraint(v, Relationship.EQ, rhs));
        }
        NonNegativeConstraint nonneg = new NonNegativeConstraint(true);
        LinearConstraintSet consSet = new LinearConstraintSet(cons);
        SimplexSolver solver = new SimplexSolver();
        PointValuePair optimal = null;
        try {
            optimal = solver.optimize(new MaxIter(1000), f, consSet, GoalType.MINIMIZE, nonneg);
        }
        catch (NoFeasibleSolutionException ex) {
            logger.error("no feasible solution", (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            logger.error("linear optimization failed", (Throwable)ex);
            return null;
        }
        int compNumb = system.getPhase(phase).getNumberOfComponents();
        double[] lp_solution = new double[compNumb];
        double[] temp = optimal.getPoint();
        for (i = 0; i < compNumb - (compNumb - this.components.length); ++i) {
            lp_solution[i] = temp[i + 1];
        }
        return lp_solution;
    }
}

