/*
 * Decompiled with CFR 0.152.
 */
package neqsim.chemicalreactions.chemicalreaction;

import Jama.Matrix;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import neqsim.chemicalreactions.chemicalreaction.ChemicalReaction;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChemicalReactionList
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ChemicalReactionList.class);
    ArrayList<ChemicalReaction> chemicalReactionList = new ArrayList();
    String[] reactiveComponentList;
    double[][] reacMatrix;
    double[][] reacGMatrix;
    double[][] tempReacMatrix;
    double[][] tempStocMatrix;

    public void readReactions(SystemInterface system) {
        this.chemicalReactionList.clear();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> stocCoef = new ArrayList<String>();
        double r = 0.0;
        double refT = 0.0;
        double[] K = new double[4];
        boolean useReaction = false;
        try (NeqSimDataBase database = new NeqSimDataBase();){
            ResultSet dataSet = null;
            dataSet = system.getModelName().equals("Kent Eisenberg-model") ? database.getResultSet("SELECT * FROM reactiondatakenteisenberg") : database.getResultSet("SELECT * FROM reactiondata");
            dataSet.next();
            do {
                boolean bl = useReaction = Integer.parseInt(dataSet.getString("usereaction")) == 1;
                if (!useReaction) continue;
                names.clear();
                stocCoef.clear();
                String reacname = dataSet.getString("NAME");
                K[0] = Double.parseDouble(dataSet.getString("K1"));
                K[1] = Double.parseDouble(dataSet.getString("K2"));
                K[2] = Double.parseDouble(dataSet.getString("K3"));
                K[3] = Double.parseDouble(dataSet.getString("K4"));
                refT = Double.parseDouble(dataSet.getString("Tref"));
                r = Double.parseDouble(dataSet.getString("r"));
                double actH = Double.parseDouble(dataSet.getString("ACTENERGY"));
                try (NeqSimDataBase database2 = new NeqSimDataBase();
                     ResultSet dataSet2 = database2.getResultSet("SELECT * FROM stoccoefdata where REACNAME='" + reacname + "'");){
                    dataSet2.next();
                    do {
                        names.add(dataSet2.getString("compname").trim());
                        stocCoef.add(dataSet2.getString("stoccoef").trim());
                    } while (dataSet2.next());
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                String[] nameArray = new String[names.size()];
                double[] coefArray = new double[nameArray.length];
                for (int i = 0; i < nameArray.length; ++i) {
                    coefArray[i] = Double.parseDouble((String)stocCoef.get(i));
                    nameArray[i] = (String)names.get(i);
                }
                ChemicalReaction reaction = new ChemicalReaction(reacname, nameArray, coefArray, K, r, actH, refT);
                this.chemicalReactionList.add(reaction);
            } while (dataSet.next());
        }
        catch (Exception ex) {
            logger.error("could not add reaction: ", (Throwable)ex);
        }
    }

    public ChemicalReaction getReaction(int i) {
        return this.chemicalReactionList.get(i);
    }

    public ChemicalReaction getReaction(String name) {
        for (int i = 0; i < this.chemicalReactionList.size(); ++i) {
            if (!this.chemicalReactionList.get(i).getName().equals(name)) continue;
            return this.chemicalReactionList.get(i);
        }
        logger.warn("did not find reaction: " + name);
        return null;
    }

    public void removeJunkReactions(String[] names) {
        Iterator<ChemicalReaction> e = this.chemicalReactionList.iterator();
        while (e.hasNext()) {
            if (e.next().reactantsContains(names)) continue;
            e.remove();
        }
    }

    public void checkReactions(PhaseInterface phase) {
        Iterator<ChemicalReaction> e = this.chemicalReactionList.iterator();
        while (e.hasNext()) {
            e.next().init(phase);
        }
    }

    public void initMoleNumbers(PhaseInterface phase, ComponentInterface[] components, double[][] Amatrix, double[] chemRefPot) {
        Iterator<ChemicalReaction> e = this.chemicalReactionList.iterator();
        while (e.hasNext()) {
            e.next().initMoleNumbers(phase, components, Amatrix, chemRefPot);
        }
    }

    public String[] getAllComponents() {
        HashSet<String> components = new HashSet<String>();
        for (ChemicalReaction reaction : this.chemicalReactionList) {
            components.addAll(Arrays.asList(reaction.getNames()));
        }
        String[] componentList = new String[components.size()];
        int k = 0;
        Iterator newe = components.iterator();
        while (newe.hasNext()) {
            componentList[k++] = (String)newe.next();
        }
        this.reactiveComponentList = componentList;
        return componentList;
    }

    public double[][] createReactionMatrix(PhaseInterface phase, ComponentInterface[] components) {
        Iterator<ChemicalReaction> e = this.chemicalReactionList.iterator();
        int reactionNumber = 0;
        this.reacMatrix = new double[this.chemicalReactionList.size()][this.reactiveComponentList.length];
        this.reacGMatrix = new double[this.chemicalReactionList.size()][this.reactiveComponentList.length + 1];
        try {
            while (e.hasNext()) {
                ChemicalReaction reaction = e.next();
                for (int i = 0; i < components.length; ++i) {
                    this.reacMatrix[reactionNumber][i] = 0.0;
                    for (int j = 0; j < reaction.getNames().length; ++j) {
                        if (!components[i].getName().equals(reaction.getNames()[j])) continue;
                        this.reacMatrix[reactionNumber][i] = reaction.getStocCoefs()[j];
                        this.reacGMatrix[reactionNumber][i] = reaction.getStocCoefs()[j];
                    }
                }
                this.reacGMatrix[reactionNumber][components.length] = 8.3144621 * phase.getTemperature() * Math.log(reaction.getK(phase));
                ++reactionNumber;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return this.reacMatrix;
    }

    public double[] updateReferencePotentials(PhaseInterface phase, ComponentInterface[] components) {
        for (int i = 0; i < this.chemicalReactionList.size(); ++i) {
            this.reacGMatrix[i][components.length] = 8.3144621 * phase.getTemperature() * Math.log(this.chemicalReactionList.get(i).getK(phase));
        }
        return this.calcReferencePotentials();
    }

    public double[][] getReactionGMatrix() {
        return this.reacGMatrix;
    }

    public double[][] getReactionMatrix() {
        return this.reacMatrix;
    }

    public double[] calcReferencePotentials() {
        Matrix reacMatr = new Matrix(this.reacGMatrix);
        Matrix Amatrix = reacMatr.copy().getMatrix(0, this.chemicalReactionList.size() - 1, 0, this.chemicalReactionList.size() - 1);
        Matrix Bmatrix = reacMatr.copy().getMatrix(0, this.chemicalReactionList.size() - 1, this.reacGMatrix[0].length - 1, this.reacGMatrix[0].length - 1);
        if (Amatrix.rank() < this.chemicalReactionList.size()) {
            System.out.println("rank of A matrix too low !!" + Amatrix.rank());
            return null;
        }
        Matrix solv = Amatrix.solve(Bmatrix.timesEquals(-1.0));
        return solv.transpose().getArrayCopy()[0];
    }

    public void calcReacMatrix(PhaseInterface phase) {
        this.tempReacMatrix = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        this.tempStocMatrix = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        for (int i = 0; i < phase.getNumberOfComponents(); ++i) {
            for (ChemicalReaction reaction : this.chemicalReactionList) {
                for (int j = 0; j < reaction.getNames().length; ++j) {
                    if (!phase.getComponents()[i].getName().equals(reaction.getNames()[j])) continue;
                    for (int k = 0; k < phase.getNumberOfComponents(); ++k) {
                        for (int o = 0; o < reaction.getNames().length; ++o) {
                            if (!phase.getComponents()[k].getName().equals(reaction.getNames()[o])) continue;
                            this.tempReacMatrix[i][k] = reaction.getRateFactor(phase);
                            this.tempStocMatrix[i][k] = -reaction.getStocCoefs()[o];
                        }
                    }
                }
            }
        }
    }

    public double[][] getReacMatrix() {
        return this.tempReacMatrix;
    }

    public double[][] getStocMatrix() {
        return this.tempStocMatrix;
    }

    public Matrix calcReacRates(PhaseInterface phase, ComponentInterface[] components) {
        int j;
        Matrix modReacMatrix = new Matrix(this.reacMatrix).copy();
        for (int i = 0; i < this.chemicalReactionList.size(); ++i) {
            for (int j2 = 0; j2 < components.length; ++j2) {
                modReacMatrix.set(i, j2, Math.pow(components[j2].getx() * phase.getDensity() / phase.getMolarMass(), Math.abs(this.reacMatrix[i][j2])));
            }
        }
        double[] tempForward = new double[this.chemicalReactionList.size()];
        double[] tempBackward = new double[this.chemicalReactionList.size()];
        double[] reacVec = new double[this.chemicalReactionList.size()];
        for (int i = 0; i < this.chemicalReactionList.size(); ++i) {
            tempForward[i] = this.chemicalReactionList.get(i).getRateFactor();
            tempBackward[i] = this.chemicalReactionList.get(i).getK(phase) / this.chemicalReactionList.get(i).getRateFactor();
            for (int j3 = 0; j3 < components.length; ++j3) {
                if (this.reacMatrix[i][j3] > 0.0) {
                    int n = i;
                    tempForward[n] = tempForward[n] * modReacMatrix.get(i, j3);
                }
                if (!(this.reacMatrix[i][j3] < 0.0)) continue;
                int n = i;
                tempBackward[n] = tempBackward[n] * modReacMatrix.get(i, j3);
            }
            reacVec[i] = tempForward[i] - tempBackward[i];
        }
        Matrix reacMatVec = new Matrix(reacVec, 1);
        Matrix reacMat = new Matrix(this.reacMatrix).transpose().times(reacMatVec);
        double[] reactRates = new double[phase.getComponents().length];
        for (j = 0; j < components.length; ++j) {
            reactRates[components[j].getComponentNumber()] = reacMat.get(j, 0);
        }
        for (j = 0; j < phase.getNumberOfComponents(); ++j) {
        }
        return reacMat;
    }

    public ArrayList<ChemicalReaction> getChemicalReactionList() {
        return this.chemicalReactionList;
    }

    public void setChemicalReactionList(ArrayList<ChemicalReaction> chemicalReactionList) {
        this.chemicalReactionList = chemicalReactionList;
    }

    public double reacHeat(PhaseInterface phase, String comp) {
        double heat = 0.0;
        for (ChemicalReaction reaction : this.chemicalReactionList) {
            heat += phase.getComponent(comp).getNumberOfmoles() * reaction.getReactionHeat(phase);
        }
        return heat;
    }
}

