/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary;

import Jama.Matrix;
import neqsim.fluidmechanics.flownode.FlowNodeInterface;
import neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.FluidBoundary;
import neqsim.thermo.system.SystemInterface;

public abstract class NonEquilibriumFluidBoundary
extends FluidBoundary {
    private static final long serialVersionUID = 1000L;
    protected int neq = 3 * this.bulkSystem.getPhases()[0].getNumberOfComponents();
    protected Matrix dx;
    protected Matrix Jac = new Matrix(this.neq, this.neq);
    protected Matrix fvec = new Matrix(this.neq, 1);
    protected Matrix uMassTrans;
    protected Matrix uMassTransold;
    protected Matrix Xgij;
    public double[][] molFractionDifference;

    public NonEquilibriumFluidBoundary(SystemInterface system) {
        super(system);
        this.massTransferCoefficientMatrix[0] = new Matrix(this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1, this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1);
        this.massTransferCoefficientMatrix[1] = new Matrix(this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1, this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1);
        this.totalMassTransferCoefficientMatrix[0] = new Matrix(this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1, this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1);
        this.totalMassTransferCoefficientMatrix[1] = new Matrix(this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1, this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1);
        this.molFractionDifference = new double[2][this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1];
    }

    public NonEquilibriumFluidBoundary(FlowNodeInterface flowNode) {
        super(flowNode);
        this.massTransferCoefficientMatrix[0] = new Matrix(this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1, this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1);
        this.massTransferCoefficientMatrix[1] = new Matrix(this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1, this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1);
        this.totalMassTransferCoefficientMatrix[0] = new Matrix(this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1, this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1);
        this.totalMassTransferCoefficientMatrix[1] = new Matrix(this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1, this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1);
        this.molFractionDifference = new double[2][this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1];
    }

    @Override
    public NonEquilibriumFluidBoundary clone() {
        NonEquilibriumFluidBoundary clonedSystem = null;
        try {
            clonedSystem = (NonEquilibriumFluidBoundary)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    public void setfvecMassTrans() {
        int i;
        double sumx = 0.0;
        double sumy = 0.0;
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            this.fvec.set(i, 0, Math.log(this.interphaseSystem.getPhases()[0].getComponents()[i].getFugacityCoefficient() * this.interphaseSystem.getPhases()[0].getComponents()[i].getx()) - Math.log(this.interphaseSystem.getPhases()[1].getComponents()[i].getFugacityCoefficient() * this.interphaseSystem.getPhases()[1].getComponents()[i].getx()));
            sumx += this.interphaseSystem.getPhases()[0].getComponents()[i].getx();
            sumy += this.interphaseSystem.getPhases()[1].getComponents()[i].getx();
        }
        this.fvec.set(this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1, 0, 1.0 - sumx);
        this.fvec.set(this.bulkSystem.getPhases()[0].getNumberOfComponents(), 0, 1.0 - sumy);
        for (i = this.bulkSystem.getPhases()[0].getNumberOfComponents() + 1; i < 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            this.fvec.set(i, 0, this.totalMassTransferCoefficientMatrix[1].get(i - (this.bulkSystem.getPhases()[0].getNumberOfComponents() + 1), i - (this.bulkSystem.getPhases()[0].getNumberOfComponents() + 1)) * (this.bulkSystem.getPhases()[0].getComponents()[i - (this.bulkSystem.getPhases()[0].getNumberOfComponents() + 1)].getx() - this.interphaseSystem.getPhases()[0].getComponents()[i - (this.bulkSystem.getPhases()[0].getNumberOfComponents() + 1)].getx()) + this.totalMassTransferCoefficientMatrix[0].get(i - (this.bulkSystem.getPhases()[0].getNumberOfComponents() + 1), i - (this.bulkSystem.getPhases()[0].getNumberOfComponents() + 1)) * (this.bulkSystem.getPhases()[1].getComponents()[i - (this.bulkSystem.getPhases()[0].getNumberOfComponents() + 1)].getx() - this.interphaseSystem.getPhases()[1].getComponents()[i - (this.bulkSystem.getPhases()[0].getNumberOfComponents() + 1)].getx()));
        }
    }

    public void setfvecMassTrans2() {
        double sumx = 0.0;
        double sumy = 0.0;
        for (int i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            this.fvec.set(i, 0, Math.log(this.interphaseSystem.getPhases()[0].getComponents()[i].getFugacityCoefficient() * this.interphaseSystem.getPhases()[0].getComponents()[i].getx()) - Math.log(this.interphaseSystem.getPhases()[1].getComponents()[i].getFugacityCoefficient() * this.interphaseSystem.getPhases()[1].getComponents()[i].getx()));
            sumx += this.interphaseSystem.getPhases()[1].getComponents()[i].getx();
            sumy += this.interphaseSystem.getPhases()[0].getComponents()[i].getx();
        }
        this.fvec.set(this.bulkSystem.getPhases()[0].getNumberOfComponents(), 0, 1.0 - sumx);
        this.fvec.set(this.bulkSystem.getPhases()[0].getNumberOfComponents() + 1, 0, 1.0 - sumy);
        Matrix dx = new Matrix(1, this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1);
        Matrix dy = new Matrix(1, this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1);
        Matrix x = new Matrix(1, this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1);
        Matrix y = new Matrix(1, this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1);
        for (int i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1; ++i) {
            dy.set(0, i, this.bulkSystem.getPhases()[0].getComponents()[i].getx() - this.interphaseSystem.getPhases()[0].getComponents()[i].getx());
            dx.set(0, i, this.bulkSystem.getPhases()[1].getComponents()[i].getx() - this.interphaseSystem.getPhases()[1].getComponents()[i].getx());
            y.set(0, i, this.bulkSystem.getPhases()[0].getComponents()[i].getx());
            x.set(0, i, this.bulkSystem.getPhases()[1].getComponents()[i].getx());
        }
        Matrix fluxX = this.totalMassTransferCoefficientMatrix[1].times(dx.transpose()).times(this.bulkSystem.getPhases()[1].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[1].getMolarMass());
        Matrix fluxY = this.totalMassTransferCoefficientMatrix[0].times(dy.transpose()).times(this.bulkSystem.getPhases()[0].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[0].getMolarMass());
        Matrix errX = this.nFlux.getMatrix(0, this.bulkSystem.getPhases()[1].getNumberOfComponents() - 2, 0, 0).plus(fluxX).minus(x.transpose().times(this.totalFlux));
        Matrix errY = this.nFlux.getMatrix(0, this.bulkSystem.getPhases()[0].getNumberOfComponents() - 2, 0, 0).minus(fluxY).minus(y.transpose().times(this.totalFlux));
        for (int i = this.bulkSystem.getPhases()[0].getNumberOfComponents() + 2; i < 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 1; ++i) {
            this.fvec.set(i, 0, errX.get(i - (this.bulkSystem.getPhases()[0].getNumberOfComponents() + 2), 0));
            this.fvec.set(i + (this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1), 0, errY.get(i - (this.bulkSystem.getPhases()[0].getNumberOfComponents() + 2), 0));
        }
    }

    public void setJacMassTrans() {
        int j;
        int i;
        double dij = 0.0;
        double tempJ = 0.0;
        this.Jac.timesEquals(0.0);
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1; ++i) {
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = dij * 1.0 / this.interphaseSystem.getPhases()[0].getComponents()[i].getx() + this.interphaseSystem.getPhases()[0].getComponents()[i].getdfugdx(j);
                this.Jac.set(i, j, tempJ);
            }
        }
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1, i, -1.0);
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1, this.bulkSystem.getPhases()[0].getNumberOfComponents() + i, 0.0);
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfComponents(), i, 0.0);
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfComponents(), this.bulkSystem.getPhases()[0].getNumberOfComponents() + i, -1.0);
        }
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1; ++i) {
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = dij * 1.0 / this.interphaseSystem.getPhases()[1].getComponents()[i].getx() + this.interphaseSystem.getPhases()[1].getComponents()[i].getdfugdx(j);
                this.Jac.set(i, j + this.bulkSystem.getPhases()[0].getNumberOfComponents(), -tempJ);
            }
        }
        for (i = this.bulkSystem.getPhases()[0].getNumberOfComponents(); i < 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1; ++i) {
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                dij = i == j + this.bulkSystem.getPhases()[0].getNumberOfComponents() ? 1.0 : 0.0;
                tempJ = -dij * this.totalMassTransferCoefficientMatrix[1].get(i - this.bulkSystem.getPhases()[0].getNumberOfComponents(), i - this.bulkSystem.getPhases()[0].getNumberOfComponents());
                this.Jac.set(i + 1, j, tempJ);
            }
        }
        for (i = this.bulkSystem.getPhases()[0].getNumberOfComponents(); i < 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1; ++i) {
            for (j = this.bulkSystem.getPhases()[0].getNumberOfComponents(); j < 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = -dij * this.totalMassTransferCoefficientMatrix[0].get(i - this.bulkSystem.getPhases()[0].getNumberOfComponents(), i - this.bulkSystem.getPhases()[0].getNumberOfComponents());
                this.Jac.set(i + 1, j, tempJ);
            }
        }
    }

    public void setJacMassTrans2() {
        int j;
        int i;
        double dij = 0.0;
        double tempJ = 0.0;
        this.Jac.timesEquals(0.0);
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = dij * 1.0 / this.interphaseSystem.getPhases()[0].getComponents()[i].getx() + this.interphaseSystem.getPhases()[0].getComponents()[i].getdfugdx(j);
                this.Jac.set(i, j, tempJ);
            }
        }
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfComponents(), i, 0.0);
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfComponents(), this.bulkSystem.getPhases()[0].getNumberOfComponents() + i, -1.0);
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfComponents() + 1, i, -1.0);
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfComponents() + 1, this.bulkSystem.getPhases()[0].getNumberOfComponents() + i, 0.0);
        }
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = dij * 1.0 / this.interphaseSystem.getPhases()[1].getComponents()[i].getx() + this.interphaseSystem.getPhases()[1].getComponents()[i].getdfugdx(j);
                this.Jac.set(i, j + this.bulkSystem.getPhases()[0].getNumberOfComponents(), -tempJ);
            }
        }
        for (i = this.bulkSystem.getPhases()[0].getNumberOfComponents(); i < 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1; ++i) {
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                double d = dij = i == j + this.bulkSystem.getPhases()[0].getNumberOfComponents() ? 1.0 : 0.0;
                if (j != this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1) {
                    this.Jac.set(i + 2, j + this.bulkSystem.getPhases()[0].getNumberOfComponents(), -this.totalMassTransferCoefficientMatrix[1].get(i - this.bulkSystem.getPhases()[0].getNumberOfComponents(), j) * this.bulkSystem.getPhases()[1].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[1].getMolarMass());
                }
                this.Jac.set(i + 2, j + 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents(), dij - this.bulkSystem.getPhases()[1].getComponents()[i - this.bulkSystem.getPhases()[0].getNumberOfComponents()].getx());
            }
        }
        for (i = this.bulkSystem.getPhases()[0].getNumberOfComponents(); i < 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1; ++i) {
            for (j = this.bulkSystem.getPhases()[0].getNumberOfComponents(); j < 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                double d = dij = i == j ? 1.0 : 0.0;
                if (j != 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents() - 1) {
                    this.Jac.set(i + 1 + this.bulkSystem.getPhases()[0].getNumberOfComponents(), j - this.bulkSystem.getPhases()[0].getNumberOfComponents(), this.totalMassTransferCoefficientMatrix[0].get(i - this.bulkSystem.getPhases()[0].getNumberOfComponents(), j - this.bulkSystem.getPhases()[0].getNumberOfComponents()) * this.bulkSystem.getPhases()[0].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[0].getMolarMass());
                }
                this.Jac.set(i + 1 + this.bulkSystem.getPhases()[0].getNumberOfComponents(), j + this.bulkSystem.getPhases()[0].getNumberOfComponents(), dij - this.bulkSystem.getPhases()[0].getComponents()[i - this.bulkSystem.getPhases()[0].getNumberOfComponents()].getx());
            }
        }
    }

    public void setuMassTrans() {
        int i;
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            this.uMassTrans.set(i, 0, this.interphaseSystem.getPhases()[0].getComponents()[i].getx());
            this.uMassTrans.set(i + this.bulkSystem.getPhases()[0].getNumberOfComponents(), 0, this.interphaseSystem.getPhases()[1].getComponents()[i].getx());
        }
        for (i = 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents(); i < 3 * this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            this.uMassTrans.set(i, 0, this.nFlux.get(i - 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents(), 0));
        }
    }

    public void updateMassTrans() {
        int i;
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            this.interphaseSystem.getPhases()[0].getComponents()[i].setx(this.uMassTrans.get(i, 0));
            this.interphaseSystem.getPhases()[1].getComponents()[i].setx(this.uMassTrans.get(i + this.bulkSystem.getPhases()[0].getNumberOfComponents(), 0));
        }
        for (i = 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents(); i < 3 * this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            this.nFlux.set(i - 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents(), 0, this.uMassTrans.get(i, 0));
        }
    }

    public void calcMolFractionDifference() {
        for (int i = 0; i < this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1; ++i) {
            this.molFractionDifference[0][i] = this.bulkSystem.getPhases()[0].getComponents()[i].getx() - this.interphaseSystem.getPhases()[0].getComponents()[i].getx();
            this.molFractionDifference[1][i] = this.bulkSystem.getPhases()[1].getComponents()[i].getx() - this.interphaseSystem.getPhases()[1].getComponents()[i].getx();
        }
    }

    public void calcHeatTransferCoefficients(int phase) {
        this.prandtlNumber[phase] = this.getBulkSystem().getPhases()[phase].getCp() / this.getBulkSystem().getPhases()[phase].getNumberOfMolesInPhase() * this.getBulkSystem().getPhases()[phase].getPhysicalProperties().getViscosity() / this.getBulkSystem().getPhases()[phase].getPhysicalProperties().getConductivity();
        this.heatTransferCoefficient[phase] = this.flowNode.getInterphaseTransportCoefficient().calcInterphaseHeatTransferCoefficient(phase, this.prandtlNumber[phase], this.flowNode);
    }

    public void calcHeatTransferCorrection(int phase) {
        double temp = 1.0E-20;
        for (int i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            if (Math.abs(this.nFlux.get(i, 0)) < 1.0E-20) {
                temp += 0.0;
                continue;
            }
            temp += this.nFlux.get(i, 0) * this.getBulkSystem().getPhases()[phase].getCp() / this.getBulkSystem().getPhases()[phase].getNumberOfMolesInPhase() / this.heatTransferCoefficient[phase];
        }
        this.heatTransferCorrection[phase] = Math.abs(temp) > 1.0E-10 ? temp / (Math.exp(temp) - 1.0) : 1.0;
    }

    @Override
    public void initMassTransferCalc() {
        super.initMassTransferCalc();
    }

    @Override
    public void initHeatTransferCalc() {
        super.initHeatTransferCalc();
    }

    @Override
    public void init() {
        this.calcMolFractionDifference();
        super.init();
    }

    @Override
    public void heatTransSolve() {
        double f = 0.0;
        double df = 0.0;
        double dhtot = 0.0;
        int iter = 0;
        do {
            ++iter;
            dhtot = 0.0;
            for (int i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
                dhtot += this.nFlux.get(i, 0) * (this.bulkSystem.getPhases()[0].getComponents()[i].getEnthalpy(this.bulkSystem.getPhases()[0].getTemperature()) / this.bulkSystem.getPhases()[0].getComponents()[i].getNumberOfMolesInPhase() - this.bulkSystem.getPhases()[1].getComponents()[i].getEnthalpy(this.bulkSystem.getPhases()[1].getTemperature()) / this.bulkSystem.getPhases()[1].getComponents()[i].getNumberOfMolesInPhase());
            }
            f = this.heatTransferCoefficient[0] * this.heatTransferCorrection[0] * (this.bulkSystem.getPhases()[0].getTemperature() - this.interphaseSystem.getTemperature()) + this.heatTransferCoefficient[1] * this.heatTransferCorrection[1] * (this.bulkSystem.getPhases()[1].getTemperature() - this.interphaseSystem.getTemperature()) + dhtot;
            df = -this.heatTransferCoefficient[0] * this.heatTransferCorrection[0] - this.heatTransferCoefficient[1] * this.heatTransferCorrection[1];
            this.interphaseSystem.setTemperature(this.interphaseSystem.getTemperature() - f / df);
        } while (Math.abs(f) > 1.0E-6 && iter < 100);
        this.interphaseHeatFlux[0] = -this.heatTransferCoefficient[0] * this.heatTransferCorrection[0] * (this.bulkSystem.getPhases()[0].getTemperature() - this.interphaseSystem.getTemperature());
        this.interphaseHeatFlux[1] = -this.heatTransferCoefficient[1] * this.heatTransferCorrection[1] * (this.bulkSystem.getPhases()[1].getTemperature() - this.interphaseSystem.getTemperature());
    }

    @Override
    public void massTransSolve() {
        int iter = 1;
        double err = 1.0E10;
        double factor = 10.0;
        this.setuMassTrans();
        do {
            ++iter;
            this.init();
            this.setfvecMassTrans2();
            this.setJacMassTrans2();
            this.dx = this.Jac.solve(this.fvec);
            if (!Double.valueOf(this.dx.norm2()).isNaN()) {
                this.uMassTrans.minusEquals(this.dx.times((double)iter / ((double)iter + factor)));
                err = Math.abs(this.dx.norm2() / this.uMassTrans.norm2());
                this.updateMassTrans();
                this.calcFluxes();
                continue;
            }
            System.out.println("dx: NaN in mass trans calc");
            err = 10.0;
        } while (err > 1.0E-4 && iter < 100 || iter < 5);
        this.calcFluxes();
    }

    @Override
    public double[] calcFluxes() {
        double sum = 0.0;
        for (int i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++i) {
            sum += this.nFlux.get(i, 0);
        }
        this.totalFlux = sum;
        return this.nFlux.transpose().getArray()[0];
    }

    @Override
    public void solve() {
        this.initInterphaseSystem();
        this.init();
        int iterOuter = 0;
        int iterInner = 0;
        double totalFluxOld = this.totalFlux;
        double heatFlux = 0.0;
        double oldHeatFlux = 0.0;
        if (this.heatTransferCalc) {
            this.heatTransSolve();
            heatFlux = this.getInterphaseHeatFlux(0);
        }
        do {
            ++iterInner;
            iterOuter = 0;
            oldHeatFlux = heatFlux;
            do {
                ++iterOuter;
                totalFluxOld = this.totalFlux;
                if (!this.massTransferCalc) continue;
                this.massTransSolve();
            } while (Math.abs((totalFluxOld - this.totalFlux) / this.totalFlux) > 1.0E-6 && iterOuter < 50);
            if (!this.heatTransferCalc) continue;
            this.heatTransSolve();
            heatFlux = this.getInterphaseHeatFlux(0);
        } while (Math.abs((oldHeatFlux - heatFlux) / heatFlux) > 1.0E-6 && this.heatTransferCalc && iterInner < 50);
        this.init();
    }
}

