/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flownode.multiphasenode;

import neqsim.fluidmechanics.flownode.FlowNode;
import neqsim.fluidmechanics.flownode.twophasenode.TwoPhaseFlowNode;
import neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface;
import neqsim.thermo.system.SystemInterface;

public abstract class MultiPhaseFlowNode
extends FlowNode {
    private static final long serialVersionUID = 1000L;

    public MultiPhaseFlowNode() {
    }

    public MultiPhaseFlowNode(SystemInterface system, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.getBulkSystem().initBeta();
        this.getBulkSystem().init_x_y();
    }

    @Override
    public TwoPhaseFlowNode clone() {
        TwoPhaseFlowNode clonedSystem = null;
        try {
            clonedSystem = (TwoPhaseFlowNode)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    public double initVelocity() {
        this.getBulkSystem().init(1);
        this.getBulkSystem().initPhysicalProperties();
        this.molarFlowRate[1] = this.getBulkSystem().getPhases()[1].getNumberOfMolesInPhase();
        this.molarFlowRate[0] = this.getBulkSystem().getPhases()[0].getNumberOfMolesInPhase();
        this.massFlowRate[1] = this.molarFlowRate[1] * this.getBulkSystem().getPhases()[1].getMolarMass();
        this.massFlowRate[0] = this.molarFlowRate[0] * this.getBulkSystem().getPhases()[0].getMolarMass();
        this.volumetricFlowRate[0] = this.massFlowRate[0] / this.getBulkSystem().getPhases()[0].getPhysicalProperties().getDensity();
        this.volumetricFlowRate[1] = this.massFlowRate[1] / this.getBulkSystem().getPhases()[1].getPhysicalProperties().getDensity();
        this.velocity[0] = this.volumetricFlowRate[0] / (this.phaseFraction[0] * this.pipe.getArea());
        this.velocity[1] = this.volumetricFlowRate[1] / (this.phaseFraction[1] * this.pipe.getArea());
        return this.velocity[1];
    }

    @Override
    public void initFlowCalc() {
        this.init();
        this.initVelocity();
        this.phaseFraction[0] = 0.9999999999;
        this.phaseFraction[1] = 1.0 - this.phaseFraction[0];
        double f = 0.0;
        double fOld = 0.0;
        double betaOld = 0.0;
        int iterations = 0;
        double step = 100.0;
        do {
            ++iterations;
            fOld = f;
            this.initVelocity();
            this.init();
            double Fg = 0.5 * this.bulkSystem.getPhases()[0].getPhysicalProperties().getDensity() * this.wallFrictionFactor[0] * Math.pow(this.velocity[0], 2.0) * this.wallContactLength[0] / (this.pipe.getArea() * 4.0);
            double Fl = 0.5 * this.bulkSystem.getPhases()[1].getPhysicalProperties().getDensity() * this.wallFrictionFactor[1] * Math.pow(this.velocity[1], 2.0) * this.wallContactLength[1] / (this.pipe.getArea() * 4.0);
            double Fi = 0.5 * this.bulkSystem.getPhases()[0].getPhysicalProperties().getDensity() * this.interphaseFrictionFactor[0] * Math.pow(this.velocity[0] - this.velocity[1], 2.0) * this.interphaseContactLength[0] / (this.pipe.getArea() * 4.0);
            f = -this.phaseFraction[0] * Fl + (1.0 - this.phaseFraction[0]) * Fg + Fi + (1.0 - this.phaseFraction[0]) * this.phaseFraction[0] * (this.bulkSystem.getPhases()[1].getPhysicalProperties().getDensity() - this.bulkSystem.getPhases()[0].getPhysicalProperties().getDensity()) * 9.80665 * this.inclination;
            if (f > 0.0) {
                this.phaseFraction[0] = this.phaseFraction[0] + (betaOld - this.phaseFraction[0]);
                if (fOld < 0.0) {
                    step *= 5.0;
                }
            } else {
                betaOld = this.phaseFraction[0];
                this.phaseFraction[0] = this.phaseFraction[0] - this.phaseFraction[0] / step;
            }
            this.phaseFraction[1] = 1.0 - this.phaseFraction[0];
        } while (Math.abs(f) > 0.01 && iterations < 100);
        if (iterations == 100) {
            System.out.println("error in void init calc");
        }
        this.init();
    }

    public double calcHydraulicDiameter() {
        this.hydraulicDiameter[0] = 4.0 * this.phaseFraction[0] * this.pipe.getArea() / (this.wallContactLength[0] + this.interphaseContactLength[0]);
        this.hydraulicDiameter[1] = 4.0 * this.phaseFraction[1] * this.pipe.getArea() / this.wallContactLength[1];
        return this.hydraulicDiameter[0];
    }

    public double calcReynoldNumber() {
        this.reynoldsNumber[1] = this.velocity[1] * this.hydraulicDiameter[1] * this.bulkSystem.getPhases()[1].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[1].getPhysicalProperties().getViscosity();
        this.reynoldsNumber[0] = this.velocity[0] * this.hydraulicDiameter[0] * this.bulkSystem.getPhases()[0].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[0].getPhysicalProperties().getViscosity();
        return this.reynoldsNumber[1];
    }

    public double calcWallFrictionFactor() {
        for (int i = 0; i < 2; ++i) {
            this.wallFrictionFactor[i] = Math.pow(1.0 / (-1.8 * Math.log10(6.9 / this.getReynoldsNumber(i) * Math.pow(this.pipe.getRelativeRoughnes(this.getHydraulicDiameter(i)) / 3.7, 1.11))), 2.0);
        }
        return this.wallFrictionFactor[0];
    }

    @Override
    public void setFluxes(double[] dn) {
        for (int i = 0; i < this.getBulkSystem().getPhases()[0].getNumberOfComponents(); ++i) {
            this.getBulkSystem().getPhases()[0].addMoles(i, -dn[i]);
            this.getBulkSystem().getPhases()[1].addMoles(i, dn[i]);
            this.getInterphaseSystem().getPhases()[0].addMoles(i, -dn[i]);
            this.getInterphaseSystem().getPhases()[1].addMoles(i, dn[i]);
        }
    }

    @Override
    public void updateMolarFlow() {
        for (int phase = 0; phase < 2; ++phase) {
            for (int i = 0; i < this.getBulkSystem().getPhases()[0].getNumberOfComponents(); ++i) {
                this.getBulkSystem().getPhases()[phase].addMoles(i, this.getBulkSystem().getPhases()[phase].getComponents()[i].getx() * (this.molarFlowRate[phase] - this.getBulkSystem().getPhases()[phase].getNumberOfMolesInPhase()));
            }
        }
        this.getBulkSystem().init(1);
    }

    public double calcContactLength() {
        return 0.0;
    }

    @Override
    public void init() {
        super.init();
        this.massFlowRate[0] = this.velocity[0] * this.getBulkSystem().getPhases()[0].getPhysicalProperties().getDensity() * this.pipe.getArea() * this.phaseFraction[0];
        this.massFlowRate[1] = this.velocity[1] * this.getBulkSystem().getPhases()[1].getPhysicalProperties().getDensity() * this.pipe.getArea() * this.phaseFraction[1];
        this.molarFlowRate[0] = this.massFlowRate[0] / this.getBulkSystem().getPhases()[0].getMolarMass();
        this.molarFlowRate[1] = this.massFlowRate[1] / this.getBulkSystem().getPhases()[1].getMolarMass();
        this.superficialVelocity[0] = this.velocity[0] * this.phaseFraction[0];
        this.superficialVelocity[1] = this.velocity[1] * this.phaseFraction[1];
        this.volumetricFlowRate[0] = this.superficialVelocity[0] * this.pipe.getArea();
        this.volumetricFlowRate[1] = this.superficialVelocity[1] * this.pipe.getArea();
        this.updateMolarFlow();
        this.calcHydraulicDiameter();
        this.calcReynoldNumber();
        this.interphaseContactArea = this.calcGasLiquidContactArea();
        this.wallFrictionFactor[0] = this.interphaseTransportCoefficient.calcWallFrictionFactor(0, this);
        this.wallFrictionFactor[1] = this.interphaseTransportCoefficient.calcWallFrictionFactor(1, this);
        this.interphaseFrictionFactor[0] = this.interphaseTransportCoefficient.calcInterPhaseFrictionFactor(0, this);
        this.interphaseFrictionFactor[1] = this.interphaseTransportCoefficient.calcInterPhaseFrictionFactor(0, this);
    }

    public double calcGasLiquidContactArea() {
        this.interphaseContactArea = this.pipe.getNodeLength() * this.interphaseContactLength[0];
        return this.interphaseContactArea;
    }

    @Override
    public void calcFluxes() {
        if (this.bulkSystem.isChemicalSystem()) {
            // empty if block
        }
        this.fluidBoundary.solve();
        this.fluidBoundary.calcFluxes();
    }

    @Override
    public void update() {
        double heatFluxGas = this.getFluidBoundary().getInterphaseHeatFlux(0);
        double heatFluxLiquid = this.getFluidBoundary().getInterphaseHeatFlux(1);
        double liquid_dT = (double)this.flowDirection[1] * heatFluxLiquid * this.getGeometry().getNodeLength() / this.getVelocity(1) / this.getBulkSystem().getPhase(1).getCp();
        double gas_dT = (double)this.flowDirection[0] * heatFluxGas * this.getGeometry().getNodeLength() / this.getVelocity(0) / this.getBulkSystem().getPhase(0).getCp();
        liquid_dT -= this.getInterphaseTransportCoefficient().calcWallHeatTransferCoefficient(1, this) * (this.getBulkSystem().getPhase(1).getTemperature() - this.pipe.getInnerWallTemperature()) * this.getWallContactLength(1) * this.getGeometry().getNodeLength() / this.getBulkSystem().getPhase(1).getCp();
        gas_dT -= this.getInterphaseTransportCoefficient().calcWallHeatTransferCoefficient(0, this) * (this.getBulkSystem().getPhase(0).getTemperature() - this.pipe.getInnerWallTemperature()) * this.getWallContactLength(0) * this.getGeometry().getNodeLength() / this.getBulkSystem().getPhase(0).getCp();
        double fluxwallinternal = this.getInterphaseTransportCoefficient().calcWallHeatTransferCoefficient(1, this) * (this.getBulkSystem().getPhase(1).getTemperature() - this.pipe.getInnerWallTemperature()) * this.getWallContactLength(1) * this.getGeometry().getNodeLength() + this.getInterphaseTransportCoefficient().calcWallHeatTransferCoefficient(0, this) * (this.getBulkSystem().getPhase(0).getTemperature() - this.pipe.getInnerWallTemperature()) * this.getWallContactLength(0) * this.getGeometry().getNodeLength();
        double JolprK = 0.0059976512 * this.getGeometry().getNodeLength() * 7500.0 * 500.0;
        double fluxOut = -33.4724 * this.getGeometry().getNodeLength() * (this.pipe.getInnerWallTemperature() - this.pipe.getSurroundingEnvironment().getTemperature());
        double dTwall = (fluxOut + fluxwallinternal) / JolprK;
        this.pipe.setInnerWallTemperature(this.pipe.getInnerWallTemperature() + dTwall);
        this.getBulkSystem().getPhase(1).setTemperature(this.getBulkSystem().getPhase(1).getTemperature() + liquid_dT);
        this.getBulkSystem().getPhase(0).setTemperature(this.getBulkSystem().getPhase(0).getTemperature() + gas_dT);
        for (int componentNumber = 0; componentNumber < this.getBulkSystem().getPhases()[0].getNumberOfComponents(); ++componentNumber) {
            double liquidMolarRate = this.getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.getInterphaseContactArea();
            double gasMolarRate = -this.getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.getInterphaseContactArea();
            this.getBulkSystem().getPhase(0).addMoles(componentNumber, (double)this.flowDirection[0] * gasMolarRate);
            this.getBulkSystem().getPhase(1).addMoles(componentNumber, (double)this.flowDirection[1] * liquidMolarRate);
        }
        this.getBulkSystem().initBeta();
        this.getBulkSystem().init_x_y();
        this.getBulkSystem().init(3);
        if (this.bulkSystem.isChemicalSystem()) {
            this.getBulkSystem().getChemicalReactionOperations().setSystem(this.getBulkSystem());
            this.getOperations().chemicalEquilibrium();
        }
    }
}

