/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flownode.multiphasenode.waxnode;

import neqsim.fluidmechanics.flownode.FlowNodeInterface;
import neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.filmmodelboundary.KrishnaStandartFilmModel;
import neqsim.fluidmechanics.flownode.fluidboundary.interphasetransportcoefficient.interphasetwophase.interphasepipeflow.InterphaseStratifiedFlow;
import neqsim.fluidmechanics.flownode.multiphasenode.MultiPhaseFlowNode;
import neqsim.fluidmechanics.flownode.twophasenode.twophasepipeflownode.StratifiedFlowNode;
import neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface;
import neqsim.fluidmechanics.geometrydefinitions.pipe.PipeData;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public class WaxDepositionFlowNode
extends MultiPhaseFlowNode {
    private static final long serialVersionUID = 1000L;

    public WaxDepositionFlowNode() {
        this.flowNodeType = "wax deposition node";
    }

    public WaxDepositionFlowNode(SystemInterface system, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "wax deposition node";
        this.interphaseTransportCoefficient = new InterphaseStratifiedFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    public WaxDepositionFlowNode(SystemInterface system, SystemInterface interphaseSystem, GeometryDefinitionInterface pipe) {
        this(system, pipe);
    }

    @Override
    public StratifiedFlowNode clone() {
        StratifiedFlowNode clonedSystem = null;
        try {
            clonedSystem = (StratifiedFlowNode)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    @Override
    public void init() {
        this.inclination = 0.0;
        this.calcContactLength();
        super.init();
    }

    @Override
    public double calcContactLength() {
        double phaseAngel = 3.14159265 * this.phaseFraction[1] + Math.pow(4.7123889750000005, 0.3333333333333333) * (1.0 - 2.0 * this.phaseFraction[1] + Math.pow(this.phaseFraction[1], 0.3333333333333333) - Math.pow(this.phaseFraction[0], 0.3333333333333333));
        this.wallContactLength[1] = phaseAngel * this.pipe.getDiameter();
        this.wallContactLength[0] = 3.14159265 * this.pipe.getDiameter() - this.wallContactLength[1];
        this.interphaseContactLength[0] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        this.interphaseContactLength[1] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        return this.wallContactLength[0];
    }

    @Override
    public FlowNodeInterface getNextNode() {
        StratifiedFlowNode newNode = this.clone();
        for (int i = 0; i < this.getBulkSystem().getPhases()[0].getNumberOfComponents(); ++i) {
        }
        return newNode;
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(313.15, 10.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        PipeData pipe1 = new PipeData(0.203, 2.5E-4);
        testSystem.addComponent("methane", 25.0, 0);
        testSystem.addComponent("nC16", 1.5, 1);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        testSystem.init_x_y();
        testSystem.initBeta();
        testSystem.display();
        StratifiedFlowNode test = new StratifiedFlowNode(testSystem, pipe1);
        test.setInterphaseModelType(1);
        test.setLengthOfNode(0.005);
        test.getGeometry().getSurroundingEnvironment().setTemperature(313.15);
        test.getFluidBoundary().setHeatTransferCalc(true);
        test.getFluidBoundary().setMassTransferCalc(true);
        test.initFlowCalc();
        test.calcFluxes();
        test.update();
        test.getInterphaseSystem().display();
        test.getFluidBoundary().display("");
        test.getFluidBoundary().getInterphaseSystem().display();
        for (int i = 0; i < 5; ++i) {
            test.initFlowCalc();
            test.calcFluxes();
            test.update();
        }
        test.getBulkSystem().display();
    }
}

