/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flownode.twophasenode.twophasepipeflownode;

import neqsim.fluidmechanics.flownode.FlowNodeInterface;
import neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.filmmodelboundary.KrishnaStandartFilmModel;
import neqsim.fluidmechanics.flownode.fluidboundary.interphasetransportcoefficient.interphasetwophase.interphasepipeflow.InterphaseStratifiedFlow;
import neqsim.fluidmechanics.flownode.twophasenode.TwoPhaseFlowNode;
import neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface;
import neqsim.fluidmechanics.geometrydefinitions.internalgeometry.wall.MaterialLayer;
import neqsim.fluidmechanics.geometrydefinitions.pipe.PipeData;
import neqsim.fluidmechanics.geometrydefinitions.surrounding.PipeSurroundingEnvironment;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public class AnnularFlow
extends TwoPhaseFlowNode {
    private static final long serialVersionUID = 1000L;

    public AnnularFlow() {
        this.flowNodeType = "annular";
    }

    public AnnularFlow(SystemInterface system, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "annular";
        this.interphaseTransportCoefficient = new InterphaseStratifiedFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    public AnnularFlow(SystemInterface system, SystemInterface interphaseSystem, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "annular";
        this.interphaseTransportCoefficient = new InterphaseStratifiedFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    @Override
    public AnnularFlow clone() {
        AnnularFlow clonedSystem = null;
        try {
            clonedSystem = (AnnularFlow)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    @Override
    public void init() {
        this.inclination = 1.0;
        this.calcContactLength();
        super.init();
    }

    @Override
    public double calcContactLength() {
        this.wallContactLength[1] = 3.14159265 * this.pipe.getDiameter();
        this.wallContactLength[0] = 0.0;
        this.interphaseContactLength[0] = 3.14159265 * this.pipe.getDiameter() * Math.sqrt(this.phaseFraction[0]);
        this.interphaseContactLength[1] = 3.14159265 * this.pipe.getDiameter() * Math.sqrt(this.phaseFraction[0]);
        return this.wallContactLength[0];
    }

    @Override
    public FlowNodeInterface getNextNode() {
        AnnularFlow newNode = this.clone();
        for (int i = 0; i < this.getBulkSystem().getPhases()[0].getNumberOfComponents(); ++i) {
        }
        return newNode;
    }

    public static void main(String[] args) {
        int i;
        System.out.println("Starter.....");
        String fileName = "c:/labsim/exp-heat.txt";
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(328.15, 70.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        PipeData pipe1 = new PipeData(0.5, 1.0E-6);
        MaterialLayer epoxmat = new MaterialLayer("epoxy", 0.01);
        MaterialLayer steelmat = new MaterialLayer("steel", 0.02);
        MaterialLayer concretemat = new MaterialLayer("concrete", 0.05);
        pipe1.getWall().addMaterialLayer(epoxmat);
        pipe1.getWall().addMaterialLayer(steelmat);
        pipe1.getWall().addMaterialLayer(concretemat);
        System.out.println("pipe heat trans coef " + pipe1.getWall().getHeatTransferCoefficient());
        System.out.println("pipe heat trans coef " + pipe1.getWallHeatTransferCoefficient());
        PipeSurroundingEnvironment surrEnv = new PipeSurroundingEnvironment("sea");
        pipe1.setSurroundingEnvironment(surrEnv);
        double gasflow = 10.0;
        double outtemperature = 368.15;
        pipe1.getSurroundingEnvironment().setTemperature(outtemperature);
        testSystem.addComponent("methane", 0.99847 * gasflow, "MSm^3/day", 0);
        testSystem.addComponent("water", 0.99847 * gasflow * 0.002, "MSm^3/day", 0);
        double flow = 1000.0;
        double wtpr = 0.99;
        testSystem.addComponent("water", 5.0 * (1.0 - wtpr) * flow, "kg/min", 1);
        testSystem.addComponent("MEG", wtpr * flow, "kg/min", 1);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(10);
        testSystem.initPhysicalProperties();
        testSystem.getPhase(0).setTemperature(358.15);
        testSystem.getPhase(1).setTemperature(358.15);
        AnnularFlow test = new AnnularFlow(testSystem, pipe1);
        test.setInterphaseModelType(1);
        test.setLengthOfNode(0.01);
        test.getFluidBoundary().setHeatTransferCalc(true);
        test.getFluidBoundary().setMassTransferCalc(true);
        test.getFluidBoundary().useFiniteFluxCorrection(true);
        test.getFluidBoundary().useThermodynamicCorrections(true);
        test.initFlowCalc();
        System.out.println("rate " + test.getBulkSystem().getPhase(0).getComponent(1).getRate("Nlitre/min"));
        double oldRate = test.getBulkSystem().getPhase(0).getComponent(1).getRate("Nlitre/min");
        for (i = 0; i < 1; ++i) {
            test.initFlowCalc();
            test.init();
            test.calcFluxes();
            test.getBulkSystem().prettyPrint();
        }
        System.out.println("rate " + test.getBulkSystem().getPhase(0).getComponent(1).getRate("Nlitre/min"));
        System.out.println("diff " + (test.getBulkSystem().getPhase(0).getComponent(1).getRate("Nlitre/min") - oldRate));
        for (i = 0; i < 1000; ++i) {
            test.calcFluxes();
            test.update();
            if (i % 100 == 0) {
                test.getBulkSystem().prettyPrint();
            }
            System.out.println("aqueous phase " + test.getBulkSystem().getPhaseFraction("oil", "wt"));
        }
    }
}

