/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flownode.twophasenode.twophasepipeflownode;

import neqsim.fluidmechanics.flownode.FlowNodeInterface;
import neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.filmmodelboundary.KrishnaStandartFilmModel;
import neqsim.fluidmechanics.flownode.fluidboundary.interphasetransportcoefficient.interphasetwophase.interphasepipeflow.InterphaseDropletFlow;
import neqsim.fluidmechanics.flownode.twophasenode.TwoPhaseFlowNode;
import neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface;
import neqsim.fluidmechanics.geometrydefinitions.pipe.PipeData;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public class DropletFlowNode
extends TwoPhaseFlowNode {
    private static final long serialVersionUID = 1000L;
    private double averageDropletDiameter = 1.0E-4;

    public DropletFlowNode() {
        this.flowNodeType = "droplet";
    }

    public DropletFlowNode(SystemInterface system, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "droplet";
        this.interphaseTransportCoefficient = new InterphaseDropletFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    public DropletFlowNode(SystemInterface system, SystemInterface interphaseSystem, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "stratified";
        this.interphaseTransportCoefficient = new InterphaseDropletFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    @Override
    public double calcGasLiquidContactArea() {
        this.interphaseContactArea = this.pipe.getNodeLength() * this.interphaseContactLength[0];
        return this.interphaseContactArea;
    }

    @Override
    public void initFlowCalc() {
        this.phaseFraction[0] = this.getBulkSystem().getVolumeFraction(0);
        this.phaseFraction[1] = 1.0 - this.phaseFraction[0];
        this.initVelocity();
        this.init();
        this.initVelocity();
    }

    @Override
    public DropletFlowNode clone() {
        DropletFlowNode clonedSystem = null;
        try {
            clonedSystem = (DropletFlowNode)super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clonedSystem;
    }

    @Override
    public void init() {
        this.inclination = 0.0;
        this.calcContactLength();
        super.init();
    }

    @Override
    public double calcContactLength() {
        double phaseAngel = 3.14159265 * this.phaseFraction[1] + Math.pow(4.7123889750000005, 0.3333333333333333) * (1.0 - 2.0 * this.phaseFraction[1] + Math.pow(this.phaseFraction[1], 0.3333333333333333) - Math.pow(this.phaseFraction[0], 0.3333333333333333));
        this.wallContactLength[1] = phaseAngel * this.pipe.getDiameter();
        this.wallContactLength[0] = 3.14159265 * this.pipe.getDiameter() - this.wallContactLength[1];
        this.interphaseContactLength[0] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        this.interphaseContactLength[1] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        double volumeOfDroplet = 4.1887902047863905 * Math.pow(this.averageDropletDiameter / 2.0, 3.0);
        double surfaceAreaOfDroplet = Math.PI * 4 * Math.pow(this.averageDropletDiameter / 2.0, 2.0);
        double numbDropletsPerTime = this.getBulkSystem().getPhase(1).getVolume("m3") / volumeOfDroplet;
        this.interphaseContactLength[0] = numbDropletsPerTime * surfaceAreaOfDroplet / this.velocity[0];
        this.interphaseContactLength[1] = this.interphaseContactLength[0];
        return this.wallContactLength[0];
    }

    @Override
    public FlowNodeInterface getNextNode() {
        DropletFlowNode newNode = this.clone();
        for (int i = 0; i < this.getBulkSystem().getPhases()[0].getNumberOfComponents(); ++i) {
        }
        return newNode;
    }

    public static void mainOld(String[] args) {
        int i;
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(284.15, 60.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        PipeData pipe1 = new PipeData(0.203, 2.5E-4);
        testSystem.addComponent("methane", 250.0, "Nliter/min", 0);
        testSystem.addComponent("water", 1.0E-4, "Nliter/min", 0);
        testSystem.addComponent("TEG", 90.0, "kg/min", 1);
        testSystem.addComponent("water", 1.0, "kg/min", 1);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(10);
        testSystem.initPhysicalProperties();
        testSystem.init_x_y();
        testSystem.initBeta();
        testSystem.init(3);
        testSystem.display();
        DropletFlowNode test = new DropletFlowNode(testSystem, pipe1);
        test.setInterphaseModelType(1);
        test.setLengthOfNode(0.1);
        test.getGeometry().getSurroundingEnvironment().setTemperature(284.15);
        test.getFluidBoundary().setHeatTransferCalc(true);
        test.getFluidBoundary().setMassTransferCalc(true);
        double length = 0.0;
        test.initFlowCalc();
        test.calcFluxes();
        test.getFluidBoundary().display("test");
        double[][] temperatures2 = new double[3][1000];
        int k = 0;
        for (i = 0; i < 1000; ++i) {
            length += test.getLengthOfNode();
            test.initFlowCalc();
            test.calcFluxes();
            if (i > 1 && i % 1 == 0) {
                temperatures2[0][++k] = length;
                temperatures2[1][k] = test.getGeometry().getInnerWallTemperature();
                System.out.println(test.getBulkSystem().getPhase(0).getComponent("water").getx());
            }
            test.update();
        }
        for (i = 0; i < k; ++i) {
            System.out.println("len temp  " + temperatures2[0][i] + " " + temperatures2[1][i]);
        }
        ThermodynamicOperations ops = new ThermodynamicOperations(testSystem);
        ops.TPflash();
        testSystem.display();
    }

    public static void main(String[] args) {
        int i;
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(278.15, 0.01);
        testSystem.addComponent("oxygen", 5.0E-5, "kg/min", 0);
        testSystem.addComponent("oxygen", 8.0E-6, "kg/min", 1);
        testSystem.addComponent("water", 100.0, "kg/min", 1);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(10);
        testSystem.initPhysicalProperties();
        testSystem.init_x_y();
        testSystem.initBeta();
        testSystem.init(3);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        testOps.TPflash();
        testSystem.display();
        PipeData pipe1 = new PipeData(0.203, 2.5E-4);
        DropletFlowNode test = new DropletFlowNode(testSystem, pipe1);
        test.setInterphaseModelType(1);
        test.setLengthOfNode(0.1);
        test.getGeometry().getSurroundingEnvironment().setTemperature(284.15);
        test.getFluidBoundary().setHeatTransferCalc(true);
        test.getFluidBoundary().setMassTransferCalc(true);
        double length = 0.0;
        test.initFlowCalc();
        test.calcFluxes();
        test.getFluidBoundary().display("test");
        double[][] temperatures2 = new double[3][1000];
        int k = 0;
        for (i = 0; i < 1000; ++i) {
            length += test.getLengthOfNode();
            test.initFlowCalc();
            test.calcFluxes();
            if (i > 1 && i % 1 == 0) {
                temperatures2[0][++k] = length;
                temperatures2[1][k] = test.getGeometry().getInnerWallTemperature();
                System.out.println(test.getBulkSystem().getPhase(0).getComponent("water").getx());
            }
            test.update();
        }
        for (i = 0; i < k; ++i) {
            System.out.println("len temp  " + temperatures2[0][i] + " " + temperatures2[1][i]);
        }
        ThermodynamicOperations ops = new ThermodynamicOperations(testSystem);
        ops.TPflash();
        testSystem.display();
    }

    public double getAverageDropletDiameter() {
        return this.averageDropletDiameter;
    }

    public void setAverageDropletDiameter(double averageDropletDiameter) {
        this.averageDropletDiameter = averageDropletDiameter;
    }
}

