/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flownode.twophasenode.twophasepipeflownode;

import neqsim.fluidmechanics.flownode.FlowNodeInterface;
import neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.filmmodelboundary.KrishnaStandartFilmModel;
import neqsim.fluidmechanics.flownode.fluidboundary.interphasetransportcoefficient.interphasetwophase.interphasepipeflow.InterphaseStratifiedFlow;
import neqsim.fluidmechanics.flownode.twophasenode.TwoPhaseFlowNode;
import neqsim.fluidmechanics.flownode.twophasenode.twophasepipeflownode.DropletFlowNode;
import neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface;
import neqsim.fluidmechanics.geometrydefinitions.pipe.PipeData;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public class StratifiedFlowNode
extends TwoPhaseFlowNode {
    private static final long serialVersionUID = 1000L;

    public StratifiedFlowNode() {
        this.flowNodeType = "stratified";
    }

    public StratifiedFlowNode(SystemInterface system, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "stratified";
        this.interphaseTransportCoefficient = new InterphaseStratifiedFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    public StratifiedFlowNode(SystemInterface system, SystemInterface interphaseSystem, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "stratified";
        this.interphaseTransportCoefficient = new InterphaseStratifiedFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    @Override
    public StratifiedFlowNode clone() {
        StratifiedFlowNode clonedSystem = null;
        try {
            clonedSystem = (StratifiedFlowNode)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    @Override
    public void init() {
        this.inclination = 0.0;
        this.calcContactLength();
        super.init();
    }

    @Override
    public double calcContactLength() {
        double phaseAngel = 3.14159265 * this.phaseFraction[1] + Math.pow(4.7123889750000005, 0.3333333333333333) * (1.0 - 2.0 * this.phaseFraction[1] + Math.pow(this.phaseFraction[1], 0.3333333333333333) - Math.pow(this.phaseFraction[0], 0.3333333333333333));
        this.wallContactLength[1] = phaseAngel * this.pipe.getDiameter();
        this.wallContactLength[0] = 3.14159265 * this.pipe.getDiameter() - this.wallContactLength[1];
        this.interphaseContactLength[0] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        this.interphaseContactLength[1] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        return this.wallContactLength[0];
    }

    @Override
    public FlowNodeInterface getNextNode() {
        StratifiedFlowNode newNode = this.clone();
        for (int i = 0; i < this.getBulkSystem().getPhases()[0].getNumberOfComponents(); ++i) {
        }
        return newNode;
    }

    public static void main(String[] args) {
        int i;
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(325.3, 100.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        PipeData pipe1 = new PipeData(0.250203, 2.5E-4);
        testSystem.addComponent("methane", 0.1, "MSm3/day", 0);
        testSystem.addComponent("water", 2.0, "kg/hr", 1);
        testSystem.addComponent("MEG", 3.0, "kg/hr", 1);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(10);
        testSystem.initPhysicalProperties();
        testSystem.init_x_y();
        testSystem.initBeta();
        testSystem.init(3);
        testSystem.display();
        DropletFlowNode test = new DropletFlowNode(testSystem, pipe1);
        test.setInterphaseModelType(1);
        test.setLengthOfNode(0.001);
        test.getGeometry().getSurroundingEnvironment().setTemperature(277.15);
        test.getFluidBoundary().setHeatTransferCalc(false);
        test.getFluidBoundary().setMassTransferCalc(true);
        double length = 0.0;
        test.initFlowCalc();
        double[][] temperatures2 = new double[3][1000];
        int k = 0;
        for (i = 0; i < 100000; ++i) {
            length += test.getLengthOfNode();
            test.initFlowCalc();
            test.calcFluxes();
            if (i > 1 && i % 1000 == 0) {
                test.display("length " + length);
                System.out.println("length " + length + " wt% MEG " + test.getBulkSystem().getPhase("aqueous").getWtFrac("MEG") * 100.0);
                temperatures2[0][++k] = length;
                temperatures2[1][k] = test.getGeometry().getInnerWallTemperature();
            }
            test.update();
        }
        for (i = 0; i < k; ++i) {
            System.out.println("len temp  " + temperatures2[0][i] + " " + temperatures2[1][i]);
        }
        System.out.println("contact length " + test.getInterphaseContactArea());
    }
}

