/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flowsystem.twophaseflowsystem.shipsystem;

import java.text.DecimalFormat;
import java.util.UUID;
import neqsim.fluidmechanics.flowsystem.twophaseflowsystem.TwoPhaseFlowSystem;
import neqsim.standards.StandardInterface;
import neqsim.standards.gasquality.Standard_ISO6578;
import neqsim.standards.gasquality.Standard_ISO6976;
import neqsim.standards.gasquality.Standard_ISO6976_2016;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LNGship
extends TwoPhaseFlowSystem {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(LNGship.class);
    double[] temperature = null;
    double dailyBoilOffRatio = 0.005;
    public double totalTankVolume = 140000.0;
    private double liquidDensity = 0.7;
    public int numberOffTimeSteps = 100;
    private double initialTemperature = 111.0;
    private boolean setInitialTemperature = false;
    private SystemInterface thermoSystem = null;
    public double initialNumberOffMoles;
    double molarBoilOffRate = 0.0;
    public double dailyBoilOffVolume = 0.0;
    private double endTime = 960.0;
    private Standard_ISO6976 standardISO6976 = null;
    StandardInterface standardDensity = null;
    double[] WI = null;
    double[] density = null;
    public double[] volume = null;
    double[] xmethane;
    double[] xethane;
    double[] xpropane;
    double[] xiC4;
    double[] xnC4;
    double[] xiC5;
    double[] xnC5;
    double[] xnC6;
    double[] xnitrogen;
    double[] ymethane;
    double[] yethane;
    double[] ypropane;
    double[] yiC4;
    double[] ynC4;
    double[] yiC5;
    double[] ynC5;
    double[] ynC6;
    double[] ynitrogen;
    double[] GCV;
    double[] GCVmass;
    double[] totalEnergy;
    double[] time;
    public double[] tankTemperature = null;
    double timeStep = 0.0;
    private String[][] resultTable = null;
    private boolean backCalculate = false;
    public double endVolume = 0.0;

    public LNGship(SystemInterface thermoSystem, double totalTankVolume, double dailyBoilOffRatio) {
        this.thermoSystem = thermoSystem;
        this.totalTankVolume = totalTankVolume;
        this.dailyBoilOffRatio = dailyBoilOffRatio;
        this.setStandardISO6976(new Standard_ISO6976_2016(thermoSystem, 0.0, 25.0, "volume"));
    }

    public void useStandardVersion(String isoName, String version) {
        if (version.equals("2016")) {
            this.setStandardISO6976(new Standard_ISO6976_2016(this.thermoSystem, this.getStandardISO6976().getVolRefT(), this.getStandardISO6976().getEnergyRefT(), "volume"));
            logger.info("using  ISO6976 version 2016");
        } else {
            this.setStandardISO6976(new Standard_ISO6976(this.thermoSystem, this.getStandardISO6976().getVolRefT(), this.getStandardISO6976().getEnergyRefT(), "volume"));
            logger.info("using  ISO6976 version 1995");
        }
    }

    @Override
    public void createSystem() {
        this.getThermoSystem().init(0);
        this.thermoOperations = new ThermodynamicOperations(this.getThermoSystem());
        try {
            if (this.isSetInitialTemperature()) {
                this.getThermoSystem().setTemperature(this.getInitialTemperature());
            } else {
                this.thermoOperations.bubblePointTemperatureFlash();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.getThermoSystem().init(0);
        this.standardDensity = new Standard_ISO6578(this.getThermoSystem());
        this.standardDensity.calculate();
        this.liquidDensity = this.standardDensity.getValue("density");
        logger.info("density start " + this.standardDensity.getValue("density"));
        this.timeStep = this.getEndTime() / ((double)this.numberOffTimeSteps * 1.0 - 1.0);
        this.dailyBoilOffVolume = this.totalTankVolume * this.dailyBoilOffRatio;
        logger.info("daily boiloff volume " + this.dailyBoilOffVolume);
        this.initialNumberOffMoles = this.totalTankVolume * this.getLiquidDensity() / this.getThermoSystem().getPhase(1).getMolarMass();
        double oldMoles = this.getThermoSystem().getTotalNumberOfMoles();
        for (int i = 0; i < this.getThermoSystem().getPhase(0).getNumberOfComponents(); ++i) {
            this.getThermoSystem().addComponent(this.getThermoSystem().getPhase(0).getComponent(i).getName(), (this.initialNumberOffMoles - oldMoles) * this.getThermoSystem().getPhase(0).getComponent(i).getz());
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void solveSteadyState(int type, UUID id) {
        try {
            if (!this.isSetInitialTemperature()) {
                this.thermoOperations.bubblePointTemperatureFlash();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        logger.info("temperature start " + this.getThermoSystem().getTemperature());
        this.calcIdentifier = id;
    }

    @Override
    public void solveTransient(int type, UUID id) {
        SystemInterface tempThermoSystem = this.getThermoSystem().clone();
        this.WI = new double[this.numberOffTimeSteps];
        this.GCV = new double[this.numberOffTimeSteps];
        this.GCVmass = new double[this.numberOffTimeSteps];
        this.totalEnergy = new double[this.numberOffTimeSteps];
        this.time = new double[this.numberOffTimeSteps];
        this.density = new double[this.numberOffTimeSteps];
        this.tankTemperature = new double[this.numberOffTimeSteps];
        this.volume = new double[this.numberOffTimeSteps];
        this.xnitrogen = new double[this.numberOffTimeSteps];
        this.xmethane = new double[this.numberOffTimeSteps];
        this.xethane = new double[this.numberOffTimeSteps];
        this.xpropane = new double[this.numberOffTimeSteps];
        this.xiC4 = new double[this.numberOffTimeSteps];
        this.xnC4 = new double[this.numberOffTimeSteps];
        this.xiC5 = new double[this.numberOffTimeSteps];
        this.xnC5 = new double[this.numberOffTimeSteps];
        this.xnC6 = new double[this.numberOffTimeSteps];
        this.ynitrogen = new double[this.numberOffTimeSteps];
        this.ymethane = new double[this.numberOffTimeSteps];
        this.yethane = new double[this.numberOffTimeSteps];
        this.ypropane = new double[this.numberOffTimeSteps];
        this.yiC4 = new double[this.numberOffTimeSteps];
        this.ynC4 = new double[this.numberOffTimeSteps];
        this.yiC5 = new double[this.numberOffTimeSteps];
        this.ynC5 = new double[this.numberOffTimeSteps];
        this.ynC6 = new double[this.numberOffTimeSteps];
        double error = 100.0;
        double mulitplicator = 1.0;
        if (this.backCalculate) {
            mulitplicator = -1.0;
        }
        this.endVolume = this.totalTankVolume - mulitplicator * this.dailyBoilOffVolume * this.getEndTime() / 24.0;
        this.molarBoilOffRate = this.dailyBoilOffVolume * this.liquidDensity / this.getThermoSystem().getPhase(1).getMolarMass() / 24.0 * this.timeStep;
        if (this.backCalculate) {
            this.molarBoilOffRate = -this.molarBoilOffRate;
        }
        logger.info("end Volume " + this.endVolume);
        int iterations = 0;
        double boilOffCorrection = 0.0;
        do {
            double oldmolarBoilOffRate;
            double oldVolume;
            this.setThermoSystem(tempThermoSystem.clone());
            this.thermoOperations = new ThermodynamicOperations(this.getThermoSystem());
            this.standardDensity = new Standard_ISO6578(this.getThermoSystem());
            this.getStandardISO6976().setThermoSystem(this.getThermoSystem());
            ++iterations;
            for (int j = 0; j < this.numberOffTimeSteps; ++j) {
                this.time[j] = (double)j * this.timeStep;
                try {
                    if (j != 0 || !this.isSetInitialTemperature()) {
                        this.thermoOperations.bubblePointTemperatureFlash();
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                double[] xgas = new double[this.getThermoSystem().getPhase(0).getNumberOfComponents()];
                for (int kk = 0; kk < this.getThermoSystem().getPhase(0).getNumberOfComponents(); ++kk) {
                    xgas[kk] = this.getThermoSystem().getPhase(0).getComponent(kk).getx();
                }
                if (this.getThermoSystem().getPhase(0).hasComponent("nitrogen")) {
                    this.xnitrogen[j] = this.getThermoSystem().getPhase(1).getComponent("nitrogen").getx();
                    this.ynitrogen[j] = this.getThermoSystem().getPhase(0).getComponent("nitrogen").getx();
                }
                if (this.getThermoSystem().getPhase(0).hasComponent("methane")) {
                    this.xmethane[j] = this.getThermoSystem().getPhase(1).getComponent("methane").getx();
                    this.ymethane[j] = this.getThermoSystem().getPhase(0).getComponent("methane").getx();
                }
                if (this.getThermoSystem().getPhase(0).hasComponent("ethane")) {
                    this.xethane[j] = this.getThermoSystem().getPhase(1).getComponent("ethane").getx();
                    this.yethane[j] = this.getThermoSystem().getPhase(0).getComponent("ethane").getx();
                }
                if (this.getThermoSystem().getPhase(0).hasComponent("propane")) {
                    this.xpropane[j] = this.getThermoSystem().getPhase(1).getComponent("propane").getx();
                    this.ypropane[j] = this.getThermoSystem().getPhase(0).getComponent("propane").getx();
                }
                if (this.getThermoSystem().getPhase(0).hasComponent("i-butane")) {
                    this.xiC4[j] = this.getThermoSystem().getPhase(1).getComponent("i-butane").getx();
                    this.yiC4[j] = this.getThermoSystem().getPhase(0).getComponent("i-butane").getx();
                }
                if (this.getThermoSystem().getPhase(0).hasComponent("n-butane")) {
                    this.xnC4[j] = this.getThermoSystem().getPhase(1).getComponent("n-butane").getx();
                    this.ynC4[j] = this.getThermoSystem().getPhase(0).getComponent("n-butane").getx();
                }
                if (this.getThermoSystem().getPhase(0).hasComponent("i-pentane")) {
                    this.xiC5[j] = this.getThermoSystem().getPhase(1).getComponent("i-pentane").getx();
                    this.yiC5[j] = this.getThermoSystem().getPhase(0).getComponent("i-pentane").getx();
                }
                if (this.getThermoSystem().getPhase(0).hasComponent("n-pentane")) {
                    this.xnC5[j] = this.getThermoSystem().getPhase(1).getComponent("n-pentane").getx();
                    this.ynC5[j] = this.getThermoSystem().getPhase(0).getComponent("n-pentane").getx();
                }
                if (this.getThermoSystem().getPhase(0).hasComponent("n-hexane")) {
                    this.xnC6[j] = this.getThermoSystem().getPhase(1).getComponent("n-hexane").getx();
                    this.ynC6[j] = this.getThermoSystem().getPhase(0).getComponent("n-hexane").getx();
                }
                this.getThermoSystem().init(0);
                this.standardDensity.calculate();
                this.density[j] = this.standardDensity.getValue("density");
                this.getStandardISO6976().calculate();
                this.WI[j] = this.getStandardISO6976().getValue("SuperiorWobbeIndex");
                this.GCV[j] = this.getStandardISO6976().getValue("SuperiorCalorificValue");
                this.tankTemperature[j] = this.getThermoSystem().getTemperature();
                this.volume[j] = this.getThermoSystem().getNumberOfMoles() * this.getThermoSystem().getPhase(1).getMolarMass() / this.density[j];
                this.standardISO6976.setReferenceType("mass");
                this.totalEnergy[j] = this.getStandardISO6976().getValue("SuperiorCalorificValue") * this.volume[j] * this.density[j];
                this.GCVmass[j] = this.getStandardISO6976().getValue("SuperiorCalorificValue");
                this.standardISO6976.setReferenceType("volume");
                for (int i = 0; i < this.getThermoSystem().getPhase(0).getNumberOfComponents(); ++i) {
                    this.getThermoSystem().addComponent(this.getThermoSystem().getPhase(0).getComponent(i).getName(), -xgas[i] * this.molarBoilOffRate);
                }
            }
            double oldoldVolume = oldVolume = 0.0;
            oldVolume = this.volume[0] - this.volume[this.numberOffTimeSteps - 1];
            double oldoldmolarBoilOffRate = oldmolarBoilOffRate = 0.0;
            oldmolarBoilOffRate = this.molarBoilOffRate;
            error = this.volume[this.numberOffTimeSteps - 1] / this.endVolume - 1.0;
            double derrordn = (oldVolume - oldoldVolume) / (oldmolarBoilOffRate - oldoldmolarBoilOffRate);
            boilOffCorrection = (this.volume[this.numberOffTimeSteps - 1] - this.endVolume) / derrordn;
            if (iterations > 1) {
                this.molarBoilOffRate += boilOffCorrection;
                continue;
            }
            this.molarBoilOffRate = this.molarBoilOffRate * this.volume[this.numberOffTimeSteps - 1] / this.endVolume;
        } while (Math.abs(error) > 1.0E-8 && iterations < 100);
        try {
            this.thermoOperations.bubblePointTemperatureFlash();
            this.calcIdentifier = id;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public String[][] getResultTable() {
        return this.resultTable;
    }

    public String[][] getResults(String name) {
        int j;
        String[][] table = new String[this.numberOffTimeSteps + 1][26];
        String[] names = new String[]{"Time", "temperature", "WI", "GCV", "density", "volume", "energy"};
        for (int i = 0; i < 13; ++i) {
            for (j = 0; j < this.numberOffTimeSteps + 1; ++j) {
                table[j][i] = "";
            }
        }
        System.arraycopy(names, 0, table[0], 0, 7);
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        for (j = 0; j < this.numberOffTimeSteps; ++j) {
            table[j + 1][0] = nf.format(this.time[j]);
            table[j + 1][1] = nf.format(this.tankTemperature[j] - 273.15);
            table[j + 1][2] = nf.format(this.WI[j] / 1000.0);
            table[j + 1][3] = nf.format(this.GCV[j] / 1000.0);
            table[j + 1][4] = nf.format(this.density[j]);
            table[j + 1][5] = nf.format(this.volume[j]);
            table[j + 1][15] = nf.format(this.totalEnergy[j] / 1000.0);
            table[j + 1][6] = nf.format(this.xmethane[j]);
            table[j + 1][7] = nf.format(this.xethane[j]);
            table[j + 1][8] = nf.format(this.xpropane[j]);
            table[j + 1][9] = nf.format(this.xiC4[j]);
            table[j + 1][10] = nf.format(this.xnC4[j]);
            table[j + 1][11] = nf.format(this.xiC5[j]);
            table[j + 1][12] = nf.format(this.xnC5[j]);
            table[j + 1][13] = nf.format(this.xnC6[j]);
            table[j + 1][14] = nf.format(this.xnitrogen[j]);
            table[j + 1][16] = nf.format(this.GCVmass[j] / 1000.0);
            table[j + 1][17] = nf.format(this.ymethane[j]);
            table[j + 1][18] = nf.format(this.yethane[j]);
            table[j + 1][19] = nf.format(this.ypropane[j]);
            table[j + 1][20] = nf.format(this.yiC4[j]);
            table[j + 1][21] = nf.format(this.ynC4[j]);
            table[j + 1][22] = nf.format(this.yiC5[j]);
            table[j + 1][23] = nf.format(this.ynC5[j]);
            table[j + 1][24] = nf.format(this.ynC6[j]);
            table[j + 1][25] = nf.format(this.ynitrogen[j]);
        }
        this.setResultTable(table);
        return table;
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(111.74999999999997, 1.01325);
        testSystem.addComponent("nitrogen", 0.691);
        testSystem.addComponent("methane", 91.93);
        testSystem.addComponent("ethane", 5.651);
        testSystem.addComponent("propane", 1.296);
        testSystem.addComponent("i-butane", 0.122);
        testSystem.addComponent("n-butane", 0.289);
        testSystem.addComponent("i-pentane", 0.018);
        testSystem.addComponent("n-pentane", 0.003);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        LNGship ship = new LNGship(testSystem, 140000.0, 0.0015);
        ship.useStandardVersion("", "2016");
        ship.getStandardISO6976().setEnergyRefT(15.0);
        ship.getStandardISO6976().setVolRefT(15.0);
        ship.createSystem();
        ship.init();
        ship.solveSteadyState(0);
        ship.solveTransient(0);
        ship.getResults("test");
        ship.getThermoSystem().display();
    }

    public void setResultTable(String[][] resultTable) {
        this.resultTable = resultTable;
    }

    public double getLiquidDensity() {
        return this.liquidDensity;
    }

    public void setLiquidDensity(double liquidDensity) {
        this.liquidDensity = liquidDensity;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    public Standard_ISO6976 getStandardISO6976() {
        return this.standardISO6976;
    }

    public void setStandardISO6976(Standard_ISO6976 standardISO6976) {
        this.standardISO6976 = standardISO6976;
    }

    public boolean isBackCalculate() {
        return this.backCalculate;
    }

    public void setBackCalculate(boolean backCalculate) {
        this.backCalculate = backCalculate;
    }

    public SystemInterface getThermoSystem() {
        return this.thermoSystem;
    }

    public void setThermoSystem(SystemInterface thermoSystem) {
        this.thermoSystem = thermoSystem;
    }

    public boolean isSetInitialTemperature() {
        return this.setInitialTemperature;
    }

    public double getInitialTemperature() {
        return this.initialTemperature;
    }

    public void setInitialTemperature(double initialTemperature) {
        this.setInitialTemperature = true;
        this.initialTemperature = initialTemperature;
    }

    public void setInitialTemperature(boolean setInitialTemperature) {
        this.setInitialTemperature = setInitialTemperature;
    }
}

