/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.geometrydefinitions.reactor;

import neqsim.fluidmechanics.geometrydefinitions.GeometryDefinition;
import neqsim.fluidmechanics.geometrydefinitions.internalgeometry.packings.PallRingPacking;
import neqsim.fluidmechanics.geometrydefinitions.internalgeometry.packings.RachigRingPacking;

public class ReactorData
extends GeometryDefinition {
    private static final long serialVersionUID = 1000L;

    public ReactorData() {
    }

    public ReactorData(double diameter) {
        super(diameter);
    }

    public ReactorData(double diameter, double roughness) {
        super(diameter, roughness);
        this.packing = new PallRingPacking();
    }

    public ReactorData(double diameter, int packingType) {
        super(diameter);
        this.setPackingType(packingType);
    }

    @Override
    public void setPackingType(int i) {
        this.packing = new PallRingPacking();
    }

    public void setPackingType(String name) {
        if (name.equals("pallring")) {
            this.packing = new PallRingPacking();
        } else if (name.equals("rashigring")) {
            this.packing = new RachigRingPacking();
        } else {
            System.out.println("packing " + name + " not defined in database - using pallrings");
            this.packing = new PallRingPacking();
        }
    }

    @Override
    public void setPackingType(String name, String material, int size) {
        if (name.equals("pallring")) {
            this.packing = new PallRingPacking(material, size);
        } else if (name.equals("rashigring")) {
            this.packing = new RachigRingPacking(material, size);
        } else {
            System.out.println("packing " + name + " not defined in database - using pallrings");
            this.packing = new PallRingPacking(material, size);
        }
    }

    @Override
    public ReactorData clone() {
        ReactorData clonedPipe = null;
        try {
            clonedPipe = (ReactorData)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedPipe;
    }
}

