/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.interfaceproperties.solidadsorption;

import java.sql.ResultSet;
import neqsim.physicalproperties.interfaceproperties.solidadsorption.AdsorptionInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PotentialTheoryAdsorption
implements AdsorptionInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PotentialTheoryAdsorption.class);
    SystemInterface system;
    double[] eps0;
    double[] z0;
    double[] beta;
    int integrationSteps = 500;
    double totalSurfaceExcess;
    double[][] compositionSurface;
    double[][] fugacityField;
    double[][] zField;
    double[][] epsField;
    double[] pressureField;
    double[] surfaceExcess;
    double[] surfaceExcessMolFraction;
    double[] deltaz;
    String solidMaterial = "AC";

    public PotentialTheoryAdsorption() {
    }

    public PotentialTheoryAdsorption(SystemInterface system) {
        this.system = system;
        this.compositionSurface = new double[this.integrationSteps][system.getPhase(0).getNumberOfComponents()];
        this.pressureField = new double[this.integrationSteps];
        this.zField = new double[system.getPhase(0).getNumberOfComponents()][this.integrationSteps];
        this.epsField = new double[system.getPhase(0).getNumberOfComponents()][this.integrationSteps];
        this.fugacityField = new double[system.getPhase(0).getNumberOfComponents()][this.integrationSteps];
        this.deltaz = new double[system.getPhase(0).getNumberOfComponents()];
    }

    @Override
    public void setSolidMaterial(String solidM) {
        this.solidMaterial = solidM;
    }

    @Override
    public void calcAdsorption(int phase) {
        int comp;
        SystemInterface tempSystem = this.system.clone();
        tempSystem.init(3);
        double[] bulkFug = new double[this.system.getPhase(phase).getNumberOfComponents()];
        double[] corrx = new double[this.system.getPhase(phase).getNumberOfComponents()];
        this.surfaceExcess = new double[this.system.getPhase(phase).getNumberOfComponents()];
        this.surfaceExcessMolFraction = new double[this.system.getPhase(phase).getNumberOfComponents()];
        this.eps0 = new double[this.system.getPhase(phase).getNumberOfComponents()];
        this.z0 = new double[this.system.getPhase(phase).getNumberOfComponents()];
        this.beta = new double[this.system.getPhase(phase).getNumberOfComponents()];
        this.readDBParameters();
        for (comp = 0; comp < this.system.getPhase(phase).getNumberOfComponents(); ++comp) {
            bulkFug[comp] = this.system.getPhase(phase).getComponent(comp).getx() * this.system.getPhase(phase).getComponent(comp).getFugacityCoefficient() * this.system.getPhase(phase).getPressure();
            this.deltaz[comp] = this.z0[comp] / ((double)this.integrationSteps * 1.0);
            this.zField[comp][0] = this.z0[comp];
            for (int i = 0; i < this.integrationSteps; ++i) {
                this.zField[comp][i] = this.zField[comp][0] - this.deltaz[comp] * (double)i;
                this.epsField[comp][i] = this.eps0[comp] * Math.pow(Math.log(this.z0[comp] / this.zField[comp][i]), 1.0 / this.beta[comp]);
            }
        }
        for (int i = 0; i < this.integrationSteps; ++i) {
            int comp2;
            int iter = 0;
            double sumx = 0.0;
            double pressure = 0.0;
            do {
                ++iter;
                sumx = 0.0;
                pressure = 0.0;
                for (comp2 = 0; comp2 < this.system.getPhase(phase).getNumberOfComponents(); ++comp2) {
                    double correction = Math.exp(this.epsField[comp2][i] / 8.3144621 / this.system.getPhase(phase).getTemperature());
                    this.fugacityField[comp2][i] = correction * bulkFug[comp2];
                    double fugComp = tempSystem.getPhase(phase).getComponent(comp2).getFugacityCoefficient() * tempSystem.getPhase(phase).getPressure();
                    corrx[comp2] = this.fugacityField[comp2][i] / fugComp;
                    pressure += this.fugacityField[comp2][i] / tempSystem.getPhase(phase).getComponent(comp2).getFugacityCoefficient();
                }
                for (comp2 = 0; comp2 < this.system.getPhase(phase).getNumberOfComponents(); ++comp2) {
                    tempSystem.getPhase(phase).getComponent(comp2).setx(corrx[comp2]);
                    sumx += corrx[comp2];
                }
                tempSystem.setPressure(pressure);
                tempSystem.init(1);
            } while (Math.abs(sumx - 1.0) > 1.0E-12 && iter < 100);
            for (comp2 = 0; comp2 < this.system.getPhase(phase).getNumberOfComponents(); ++comp2) {
                int n = comp2;
                this.surfaceExcess[n] = this.surfaceExcess[n] + this.deltaz[comp2] * (100000.0 / tempSystem.getPhase(phase).getMolarVolume() * tempSystem.getPhase(phase).getComponent(comp2).getx() - 100000.0 / this.system.getPhase(phase).getMolarVolume() * this.system.getPhase(phase).getComponent(comp2).getx());
            }
        }
        this.totalSurfaceExcess = 0.0;
        for (comp = 0; comp < this.system.getPhase(phase).getNumberOfComponents(); ++comp) {
            this.totalSurfaceExcess += this.surfaceExcess[comp];
        }
        for (comp = 0; comp < this.system.getPhase(phase).getNumberOfComponents(); ++comp) {
            this.surfaceExcessMolFraction[comp] = this.surfaceExcess[comp] / this.totalSurfaceExcess;
        }
    }

    @Override
    public double getSurfaceExcess(int component) {
        throw new UnsupportedOperationException("Unimplemented method 'getSurfaceExcess'");
    }

    @Override
    public double getSurfaceExcess(String componentName) {
        int componentNumber = this.system.getPhase(0).getComponent(componentName).getComponentNumber();
        return this.surfaceExcess[componentNumber];
    }

    public void readDBParameters() {
        for (int comp = 0; comp < this.system.getPhase(0).getNumberOfComponents(); ++comp) {
            try (NeqSimDataBase database = new NeqSimDataBase();
                 ResultSet dataSet = database.getResultSet("SELECT * FROM adsorptionparameters WHERE name='" + this.system.getPhase(0).getComponent(comp).getComponentName() + "' AND Solid='" + this.solidMaterial + "'");){
                dataSet.next();
                this.eps0[comp] = Double.parseDouble(dataSet.getString("eps"));
                this.beta[comp] = Double.parseDouble(dataSet.getString("z0"));
                this.z0[comp] = Double.parseDouble(dataSet.getString("beta"));
                logger.info("adsorption parameters read ok for " + this.system.getPhase(0).getComponent(comp).getComponentName() + " eps " + this.eps0[comp]);
                continue;
            }
            catch (Exception ex) {
                logger.info("Component not found in adsorption DB " + this.system.getPhase(0).getComponent(comp).getComponentName() + " on solid " + this.solidMaterial);
                logger.info("using default parameters");
                this.eps0[comp] = 7.2;
                this.beta[comp] = 2.0;
                this.z0[comp] = 3.2;
            }
        }
    }
}

