/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.interfaceproperties.surfacetension;

import Jama.Matrix;
import neqsim.physicalproperties.interfaceproperties.surfacetension.SurfaceTension;
import neqsim.thermo.system.SystemInterface;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GTSurfaceTensionSimple
extends SurfaceTension {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(GTSurfaceTensionSimple.class);
    int ite_step = 200;
    SystemInterface localSystem = null;
    double[][] den_interface = null;
    double[] z_step = null;
    double[] pressure_interface = null;
    boolean calcInfluenceParameter = true;
    double[] influenceParam;
    private double[][][] dmudn2 = null;

    public GTSurfaceTensionSimple() {
    }

    public GTSurfaceTensionSimple(SystemInterface system) {
        super(system);
    }

    public void calcInfluenceParameters() {
        this.influenceParam = new double[this.localSystem.getPhase(0).getNumberOfComponents()];
        for (int i = 0; i < this.localSystem.getPhase(0).getNumberOfComponents(); ++i) {
            this.influenceParam[i] = this.localSystem.getPhase(0).getComponent(i).getSurfaceTenisionInfluenceParameter(this.localSystem.getPhase(0).getTemperature());
        }
    }

    @Override
    public double calcSurfaceTension(int interface1, int interface2) {
        int j;
        this.localSystem = this.system.clone();
        double surdenstemp = 0.0;
        int referenceComponentNumber = this.getComponentWithHighestBoilingpoint();
        double[] del_den_interface = new double[this.localSystem.getPhase(0).getNumberOfComponents()];
        double[] del_den_interface_old = new double[this.localSystem.getPhase(0).getNumberOfComponents()];
        double[] mu_equi = new double[this.localSystem.getPhase(0).getNumberOfComponents()];
        double[][][] dmudn = new double[this.ite_step][this.localSystem.getPhase(0).getNumberOfComponents()][this.localSystem.getPhase(0).getNumberOfComponents()];
        this.dmudn2 = new double[this.ite_step][this.localSystem.getPhase(0).getNumberOfComponents()][this.localSystem.getPhase(0).getNumberOfComponents()];
        double[][] mu_inter = new double[this.ite_step][this.localSystem.getPhase(0).getNumberOfComponents()];
        double[] mu_times_den = new double[this.ite_step];
        double[][] fmatrix = new double[this.localSystem.getPhase(0).getNumberOfComponents() - 1][this.localSystem.getPhase(0).getNumberOfComponents() - 1];
        double[] bmatrix = new double[this.localSystem.getPhase(0).getNumberOfComponents() - 1];
        Matrix ans = null;
        this.z_step = new double[this.ite_step];
        this.den_interface = new double[this.ite_step][this.localSystem.getPhase(0).getNumberOfComponents()];
        this.pressure_interface = new double[this.ite_step];
        this.pressure_interface[0] = 100000.0 * this.system.getPressure();
        if (this.calcInfluenceParameter) {
            this.calcInfluenceParameters();
        }
        for (int i = 0; i < this.localSystem.getPhase(0).getNumberOfComponents(); ++i) {
            mu_equi[i] = this.system.getPhase(interface1).getComponent(i).getChemicalPotential(this.system.getPhase(interface1));
            this.den_interface[0][i] = 100000.0 * this.system.getPhase(interface1).getComponent(i).getx() / this.system.getPhase(interface1).getMolarVolume();
            this.localSystem.addComponent(this.localSystem.getPhase(0).getComponent(i).getName(), -this.system.getPhase(0).getComponent(i).getNumberOfmoles());
            this.localSystem.addComponent(this.localSystem.getPhase(0).getComponent(i).getName(), this.system.getPhase(interface1).getComponent(i).getx() / this.system.getPhase(interface1).getMolarVolume());
        }
        del_den_interface[referenceComponentNumber] = (100000.0 * this.system.getPhase(interface2).getComponent(referenceComponentNumber).getx() / this.system.getPhase(interface2).getMolarVolume() - 100000.0 * this.system.getPhase(interface1).getComponent(referenceComponentNumber).getx() / this.system.getPhase(interface1).getMolarVolume()) / ((double)this.ite_step * 1.0);
        this.localSystem.init(0);
        this.localSystem.setUseTVasIndependentVariables(true);
        this.localSystem.setNumberOfPhases(1);
        this.localSystem.getPhase(0).setTotalVolume(1.0);
        this.localSystem.useVolumeCorrection(false);
        this.localSystem.init_x_y();
        this.localSystem.init(3);
        for (j = 1; j < this.ite_step; ++j) {
            for (int i = 0; i < this.localSystem.getPhase(0).getNumberOfComponents(); ++i) {
                mu_inter[j][i] = this.localSystem.getPhase(0).getComponent(i).getChemicalPotential(this.localSystem.getPhase(0));
                for (int k = 0; k < this.localSystem.getPhase(0).getNumberOfComponents(); ++k) {
                    dmudn[j][i][k] = this.localSystem.getPhase(0).getComponent(i).getChemicalPotentialdNTV(k, this.localSystem.getPhase(0));
                }
            }
            int ii = 0;
            int kk = 0;
            for (int i = 0; i < this.localSystem.getPhase(0).getNumberOfComponents(); ++i) {
                if (i == referenceComponentNumber) continue;
                bmatrix[ii] = Math.sqrt(this.influenceParam[referenceComponentNumber]) * dmudn[j][i][referenceComponentNumber] - Math.sqrt(this.influenceParam[i]) * dmudn[j][referenceComponentNumber][referenceComponentNumber];
                kk = 0;
                for (int k = 0; k < this.localSystem.getPhase(0).getNumberOfComponents(); ++k) {
                    if (k == referenceComponentNumber) continue;
                    fmatrix[ii][kk] = Math.sqrt(this.influenceParam[i]) * dmudn[j][referenceComponentNumber][k] - Math.sqrt(this.influenceParam[referenceComponentNumber]) * dmudn[j][i][k];
                    ++kk;
                }
                ++ii;
            }
            if (this.localSystem.getPhase(0).getNumberOfComponents() > 1) {
                Matrix fmatrixJama = new Matrix(fmatrix);
                Matrix bmatrixJama = new Matrix(bmatrix, this.localSystem.getPhase(0).getNumberOfComponents() - 1);
                try {
                    ans = fmatrixJama.solveTranspose(bmatrixJama.transpose());
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            int pp = 0;
            for (int i = 0; i < this.localSystem.getPhase(0).getNumberOfComponents(); ++i) {
                if (i != referenceComponentNumber) {
                    del_den_interface[i] = ans.get(pp, 0) * del_den_interface[referenceComponentNumber];
                    if (Math.abs(ans.get(pp, 0)) * del_den_interface[referenceComponentNumber] / this.den_interface[j - 1][i] > 0.1) {
                        del_den_interface[i] = Math.signum(ans.get(pp, 0)) * this.den_interface[j - 1][i];
                    }
                    ++pp;
                }
                del_den_interface_old[i] = 0.0;
            }
            double interact = 1.0;
            double err = 1.0;
            int iterations = 0;
            while (err > 1.0E-15 && iterations < 1200) {
                int k;
                int i;
                ++iterations;
                double totalDens = 0.0;
                for (i = 0; i < this.localSystem.getPhase(0).getNumberOfComponents(); ++i) {
                    this.den_interface[j][i] = this.den_interface[j - 1][i] + del_den_interface[i];
                    totalDens += this.den_interface[j][i];
                    this.localSystem.addComponent(this.localSystem.getPhase(0).getComponent(i).getName(), (del_den_interface[i] - del_den_interface_old[i]) / 100000.0);
                    del_den_interface_old[i] = del_den_interface[i];
                }
                this.localSystem.init_x_y();
                this.localSystem.init(3);
                for (i = 0; i < this.localSystem.getPhase(0).getNumberOfComponents(); ++i) {
                    mu_inter[j][i] = this.localSystem.getPhase(0).getComponent(i).getChemicalPotential(this.localSystem.getPhase(0));
                    for (k = 0; k < this.localSystem.getPhase(0).getNumberOfComponents(); ++k) {
                        dmudn[j][i][k] = this.localSystem.getPhase(0).getComponent(i).getChemicalPotentialdNTV(k, this.localSystem.getPhase(0));
                        this.dmudn2[j][i][k] = dmudn[j][i][k];
                    }
                }
                ii = 0;
                for (i = 0; i < this.localSystem.getPhase(0).getNumberOfComponents(); ++i) {
                    if (i == referenceComponentNumber) continue;
                    bmatrix[ii] = -Math.sqrt(this.influenceParam[i]) * (mu_equi[referenceComponentNumber] - mu_inter[j][referenceComponentNumber]) + Math.sqrt(this.influenceParam[referenceComponentNumber]) * (mu_equi[i] - mu_inter[j][i]);
                    kk = 0;
                    for (k = 0; k < this.localSystem.getPhase(0).getNumberOfComponents(); ++k) {
                        if (k == referenceComponentNumber) continue;
                        fmatrix[ii][kk] = -Math.sqrt(this.influenceParam[i]) * dmudn[j][referenceComponentNumber][k] + Math.sqrt(this.influenceParam[referenceComponentNumber]) * dmudn[j][i][k];
                        ++kk;
                    }
                    ++ii;
                }
                RealMatrix ans2 = null;
                Array2DRowRealMatrix bRealMatrix = new Array2DRowRealMatrix(bmatrix);
                if (this.localSystem.getPhase(0).getNumberOfComponents() > 1) {
                    Array2DRowRealMatrix fmatrixJama = new Array2DRowRealMatrix(fmatrix);
                    try {
                        DecompositionSolver solver1 = new LUDecomposition(fmatrixJama).getSolver();
                        ans2 = solver1.solve(bRealMatrix);
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                pp = 0;
                err = 0.0;
                for (int i2 = 0; i2 < this.localSystem.getPhase(0).getNumberOfComponents(); ++i2) {
                    if (i2 == referenceComponentNumber) continue;
                    err += Math.abs(ans2.getEntry(pp, 0) * 100000.0) / totalDens;
                    int n = i2;
                    del_den_interface[n] = del_den_interface[n] + 100000.0 * ans2.getEntry(pp, 0);
                    ++pp;
                }
            }
            this.pressure_interface[j] = 100000.0 * this.localSystem.getPhase(0).getPressure();
            mu_times_den[j] = 0.0;
            double kappa = 0.0;
            double kappai = 0.0;
            double kappak = 0.0;
            for (int i = 0; i < this.localSystem.getPhase(0).getNumberOfComponents(); ++i) {
                double infli = this.influenceParam[i];
                kappai = del_den_interface[i] / del_den_interface[referenceComponentNumber];
                int n = j;
                mu_times_den[n] = mu_times_den[n] + this.den_interface[j][i] * (mu_inter[j][i] - mu_equi[i]);
                for (int k = 0; k < this.localSystem.getPhase(0).getNumberOfComponents(); ++k) {
                    interact = (this.localSystem.getPhase(0).getComponent(i).getName().equals("water") || this.localSystem.getPhase(0).getComponent(k).getName().equals("water")) && i != k ? 0.0 : 0.0;
                    double inflk = this.influenceParam[k];
                    kappak = del_den_interface[k] / del_den_interface[referenceComponentNumber];
                    kappa += Math.sqrt(infli * inflk) * kappai * kappak * (1.0 - interact);
                }
            }
            int n = j;
            mu_times_den[n] = mu_times_den[n] + -(this.pressure_interface[j] - this.pressure_interface[0]);
            this.z_step[j] = this.z_step[j - 1] + Math.sqrt(kappa / (2.0 * mu_times_den[j])) * del_den_interface[referenceComponentNumber];
            if (Double.isNaN(this.z_step[j])) break;
            surdenstemp += Math.sqrt(2.0 * kappa * mu_times_den[j]) * del_den_interface[referenceComponentNumber];
        }
        for (j = 0; j < this.ite_step; ++j) {
        }
        return Math.abs(surdenstemp);
    }

    public double[] getMolarDensity(int compnum) {
        double[] temp = new double[this.ite_step];
        for (int i = 0; i < this.ite_step; ++i) {
            temp[i] = this.den_interface[i][compnum];
        }
        return temp;
    }

    public double[] getMolarDensityTotal() {
        double[] temp = new double[this.ite_step];
        for (int i = 0; i < this.ite_step; ++i) {
            for (int j = 0; j < this.system.getPhase(0).getNumberOfComponents(); ++j) {
                int n = i;
                temp[n] = temp[n] + this.den_interface[i][j];
            }
        }
        return temp;
    }

    public double[] getz() {
        return this.z_step;
    }

    public double[] getPressure() {
        return this.pressure_interface;
    }

    public double getInfluenceParameter(double interfaceTension, int componentNumber) {
        double oldInfluenceParameter = this.influenceParam[componentNumber];
        double calcVal = 0.0;
        double oldCalcVal = 0.0;
        double dSurfTensdinfluence = 0.0;
        int iter = 0;
        this.calcInfluenceParameter = true;
        calcVal = this.calcSurfaceTension(0, 1) - interfaceTension;
        do {
            oldCalcVal = calcVal;
            this.calcInfluenceParameter = false;
            if (++iter > 1) {
                int n = componentNumber;
                this.influenceParam[n] = this.influenceParam[n] - calcVal / dSurfTensdinfluence;
            } else {
                int n = componentNumber;
                this.influenceParam[n] = this.influenceParam[n] * 1.01;
            }
            calcVal = this.calcSurfaceTension(0, 1) - interfaceTension;
            dSurfTensdinfluence = (calcVal - oldCalcVal) / (this.influenceParam[componentNumber] - oldInfluenceParameter);
            oldInfluenceParameter = this.influenceParam[componentNumber];
        } while (Math.abs(calcVal / interfaceTension) > 1.0E-8 && iter < 100);
        this.calcInfluenceParameter = true;
        return this.influenceParam[componentNumber];
    }

    public double[][][] getDmudn2() {
        return this.dmudn2;
    }

    public void setDmudn2(double[][][] dmudn2) {
        this.dmudn2 = dmudn2;
    }
}

