/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.gasphysicalproperties;

import neqsim.physicalproperties.methods.PhysicalPropertyMethod;
import neqsim.physicalproperties.system.PhysicalProperties;

public abstract class GasPhysicalPropertyMethod
extends PhysicalPropertyMethod {
    private static final long serialVersionUID = 1000L;
    protected PhysicalProperties gasPhase;
    public double[][] binaryMolecularDiameter;
    public double[][] binaryEnergyParameter;
    public double[][] binaryMolecularMass;

    public GasPhysicalPropertyMethod(PhysicalProperties gasPhase) {
        super(gasPhase);
        this.binaryMolecularDiameter = new double[gasPhase.getPhase().getNumberOfComponents()][gasPhase.getPhase().getNumberOfComponents()];
        this.binaryMolecularMass = new double[gasPhase.getPhase().getNumberOfComponents()][gasPhase.getPhase().getNumberOfComponents()];
        this.binaryEnergyParameter = new double[gasPhase.getPhase().getNumberOfComponents()][gasPhase.getPhase().getNumberOfComponents()];
        for (int i = 0; i < gasPhase.getPhase().getNumberOfComponents(); ++i) {
            for (int j = 0; j < gasPhase.getPhase().getNumberOfComponents(); ++j) {
                this.binaryMolecularMass[i][j] = 2.0 * Math.pow(1.0 / gasPhase.getPhase().getComponents()[i].getMolarMass() / 1000.0 + 1.0 / gasPhase.getPhase().getComponents()[j].getMolarMass() / 1000.0, -1.0);
                this.binaryMolecularDiameter[i][j] = (gasPhase.getPhase().getComponents()[i].getLennardJonesMolecularDiameter() + gasPhase.getPhase().getComponents()[j].getLennardJonesMolecularDiameter()) / 2.0;
                this.binaryEnergyParameter[i][j] = Math.pow(gasPhase.getPhase().getComponents()[i].getLennardJonesEnergyParameter() * gasPhase.getPhase().getComponents()[j].getLennardJonesEnergyParameter(), 0.5);
            }
        }
    }

    @Override
    public void setPhase(PhysicalProperties phase) {
        this.gasPhase = phase;
    }
}

