/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.gasphysicalproperties.density;

import neqsim.physicalproperties.methods.gasphysicalproperties.GasPhysicalPropertyMethod;
import neqsim.physicalproperties.methods.methodinterface.DensityInterface;
import neqsim.physicalproperties.system.PhysicalProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Density
extends GasPhysicalPropertyMethod
implements DensityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Density.class);

    public Density(PhysicalProperties gasPhase) {
        super(gasPhase);
    }

    @Override
    public Density clone() {
        Density properties = null;
        try {
            properties = (Density)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return properties;
    }

    @Override
    public double calcDensity() {
        double tempVar = 0.0;
        if (this.gasPhase.getPhase().useVolumeCorrection()) {
            for (int i = 0; i < this.gasPhase.getPhase().getNumberOfComponents(); ++i) {
                tempVar += this.gasPhase.getPhase().getComponents()[i].getx() * (this.gasPhase.getPhase().getComponents()[i].getVolumeCorrection() + this.gasPhase.getPhase().getComponents()[i].getVolumeCorrectionT() * (this.gasPhase.getPhase().getTemperature() - 288.15));
            }
        }
        return 1.0 / (this.gasPhase.getPhase().getMolarVolume() - tempVar) * this.gasPhase.getPhase().getMolarMass() * 100000.0;
    }
}

