/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.liquidphysicalproperties.conductivity;

import neqsim.physicalproperties.methods.liquidphysicalproperties.LiquidPhysicalPropertyMethod;
import neqsim.physicalproperties.methods.methodinterface.ConductivityInterface;
import neqsim.physicalproperties.system.PhysicalProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Conductivity
extends LiquidPhysicalPropertyMethod
implements ConductivityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Conductivity.class);
    double conductivity = 0.0;
    public double[] pureComponentConductivity;

    public Conductivity(PhysicalProperties liquidPhase) {
        super(liquidPhase);
        this.pureComponentConductivity = new double[liquidPhase.getPhase().getNumberOfComponents()];
    }

    @Override
    public Conductivity clone() {
        Conductivity properties = null;
        try {
            properties = (Conductivity)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return properties;
    }

    @Override
    public double calcConductivity() {
        this.calcPureComponentConductivity();
        this.conductivity = 0.0;
        for (int i = 0; i < this.liquidPhase.getPhase().getNumberOfComponents(); ++i) {
            for (int j = 0; j < this.liquidPhase.getPhase().getNumberOfComponents(); ++j) {
            }
            double wigthFraci = this.liquidPhase.getPhase().getWtFrac(i);
            this.conductivity += wigthFraci * this.pureComponentConductivity[i];
        }
        return this.conductivity;
    }

    public void calcPureComponentConductivity() {
        for (int i = 0; i < this.liquidPhase.getPhase().getNumberOfComponents(); ++i) {
            this.pureComponentConductivity[i] = this.liquidPhase.getPhase().getComponents()[i].getLiquidConductivityParameter(0) + this.liquidPhase.getPhase().getComponents()[i].getLiquidConductivityParameter(1) * this.liquidPhase.getPhase().getTemperature() + this.liquidPhase.getPhase().getComponents()[i].getLiquidConductivityParameter(2) * Math.pow(this.liquidPhase.getPhase().getTemperature(), 2.0);
            if (!(this.pureComponentConductivity[i] < 0.0)) continue;
            this.pureComponentConductivity[i] = 1.0E-10;
        }
    }
}

