/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.system;

import neqsim.physicalproperties.PhysicalPropertyType;
import neqsim.physicalproperties.methods.commonphasephysicalproperties.conductivity.PFCTConductivityMethodMod86;
import neqsim.physicalproperties.methods.commonphasephysicalproperties.diffusivity.CorrespondingStatesDiffusivity;
import neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity.FrictionTheoryViscosityMethod;
import neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity.LBCViscosityMethod;
import neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity.PFCTViscosityMethodHeavyOil;
import neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity.PFCTViscosityMethodMod86;
import neqsim.physicalproperties.methods.gasphysicalproperties.conductivity.ChungConductivityMethod;
import neqsim.physicalproperties.methods.gasphysicalproperties.diffusivity.WilkeLeeDiffusivity;
import neqsim.physicalproperties.methods.liquidphysicalproperties.conductivity.Conductivity;
import neqsim.physicalproperties.methods.liquidphysicalproperties.density.Costald;
import neqsim.physicalproperties.methods.liquidphysicalproperties.density.Density;
import neqsim.physicalproperties.methods.liquidphysicalproperties.diffusivity.AmineDiffusivity;
import neqsim.physicalproperties.methods.liquidphysicalproperties.diffusivity.SiddiqiLucasMethod;
import neqsim.physicalproperties.methods.liquidphysicalproperties.viscosity.Viscosity;
import neqsim.physicalproperties.methods.methodinterface.ConductivityInterface;
import neqsim.physicalproperties.methods.methodinterface.DensityInterface;
import neqsim.physicalproperties.methods.methodinterface.DiffusivityInterface;
import neqsim.physicalproperties.methods.methodinterface.ViscosityInterface;
import neqsim.physicalproperties.mixingrule.PhysicalPropertyMixingRuleInterface;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.phase.PhaseInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PhysicalProperties
implements Cloneable,
ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PhysicalProperties.class);
    protected PhaseInterface phase;
    protected int binaryDiffusionCoefficientMethod;
    protected int multicomponentDiffusionMethod;
    private PhysicalPropertyMixingRuleInterface mixingRule = null;
    public ConductivityInterface conductivityCalc;
    public ViscosityInterface viscosityCalc;
    public DiffusivityInterface diffusivityCalc;
    public DensityInterface densityCalc;
    public double kinematicViscosity = 0.0;
    public double density = 0.0;
    public double viscosity = 0.0;
    public double conductivity = 0.0;
    private double[] waxViscosityParameter = new double[]{37.82, 83.96, 8559000.0};

    public PhysicalProperties(PhaseInterface phase) {
        this.setPhase(phase);
    }

    public PhysicalProperties(PhaseInterface phase, int binaryDiffusionCoefficientMethod, int multicomponentDiffusionMethod) {
        this(phase);
        this.binaryDiffusionCoefficientMethod = binaryDiffusionCoefficientMethod;
        this.multicomponentDiffusionMethod = multicomponentDiffusionMethod;
    }

    public PhysicalProperties clone() {
        PhysicalProperties properties = null;
        try {
            properties = (PhysicalProperties)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        properties.densityCalc = this.densityCalc.clone();
        properties.diffusivityCalc = this.diffusivityCalc.clone();
        properties.viscosityCalc = this.viscosityCalc.clone();
        properties.conductivityCalc = this.conductivityCalc.clone();
        if (this.mixingRule != null) {
            properties.mixingRule = this.mixingRule.clone();
        }
        return properties;
    }

    public PhaseInterface getPhase() {
        return this.phase;
    }

    public PhysicalPropertyMixingRuleInterface getMixingRule() {
        return this.mixingRule;
    }

    public void setMixingRule(PhysicalPropertyMixingRuleInterface mixingRule) {
        this.mixingRule = mixingRule;
    }

    public void setMixingRuleNull() {
        this.setMixingRule(null);
    }

    public ViscosityInterface getViscosityModel() {
        return this.viscosityCalc;
    }

    public void setDensityModel(String model) {
        if ("Peneloux volume shift".equals(model)) {
            this.densityCalc = new Density(this);
        } else if ("Costald".equals(model)) {
            this.densityCalc = new Costald(this);
        }
    }

    public void setConductivityModel(String model) {
        this.conductivityCalc = "PFCT".equals(model) ? new PFCTConductivityMethodMod86(this) : ("polynom".equals(model) ? new Conductivity(this) : ("Chung".equals(model) ? new ChungConductivityMethod(this) : new PFCTConductivityMethodMod86(this)));
    }

    public void setViscosityModel(String model) {
        if ("polynom".equals(model)) {
            this.viscosityCalc = new Viscosity(this);
        } else if ("friction theory".equals(model)) {
            this.viscosityCalc = new FrictionTheoryViscosityMethod(this);
        } else if ("LBC".equals(model)) {
            this.viscosityCalc = new LBCViscosityMethod(this);
        } else if ("PFCT".equals(model)) {
            this.viscosityCalc = new PFCTViscosityMethodMod86(this);
        } else if ("PFCT-Heavy-Oil".equals(model)) {
            this.viscosityCalc = new PFCTViscosityMethodHeavyOil(this);
        }
    }

    public void setDiffusionCoefficientModel(String model) {
        if ("CSP".equals(model)) {
            this.diffusivityCalc = new CorrespondingStatesDiffusivity(this);
        } else if ("Wilke Lee".equals(model)) {
            this.diffusivityCalc = new WilkeLeeDiffusivity(this);
        } else if ("Siddiqi Lucas".equals(model)) {
            this.diffusivityCalc = new SiddiqiLucasMethod(this);
        } else if ("Alkanol amine".equals(model)) {
            this.diffusivityCalc = new AmineDiffusivity(this);
        }
    }

    public ConductivityInterface getConductivityModel() {
        return this.conductivityCalc;
    }

    public void setBinaryDiffusionCoefficientMethod(int i) {
        this.binaryDiffusionCoefficientMethod = i;
    }

    public void setMulticomponentDiffusionMethod(int i) {
        this.multicomponentDiffusionMethod = i;
    }

    public double calcKinematicViscosity() {
        this.kinematicViscosity = this.viscosity / this.phase.getDensity();
        return this.kinematicViscosity;
    }

    public void setPhases() {
        if (this.conductivityCalc != null) {
            this.conductivityCalc.setPhase(this);
        }
        if (this.densityCalc != null) {
            this.densityCalc.setPhase(this);
        }
        if (this.viscosityCalc != null) {
            this.viscosityCalc.setPhase(this);
        }
        if (this.diffusivityCalc != null) {
            this.diffusivityCalc.setPhase(this);
        }
    }

    public void setPhase(PhaseInterface phase) {
        this.phase = phase;
        this.setPhases();
    }

    public void init(PhaseInterface phase) {
        this.setPhase(phase);
        try {
            this.density = this.densityCalc.calcDensity();
            this.viscosity = this.viscosityCalc.calcViscosity();
            this.kinematicViscosity = this.calcKinematicViscosity();
            this.diffusivityCalc.calcDiffusionCoefficients(this.binaryDiffusionCoefficientMethod, this.multicomponentDiffusionMethod);
            this.conductivity = this.conductivityCalc.calcConductivity();
        }
        catch (Exception ex) {
            phase.resetPhysicalProperties();
            phase.initPhysicalProperties();
        }
    }

    public void init(PhaseInterface phase, PhysicalPropertyType ppt) {
        switch (ppt) {
            case MASS_DENSITY: {
                this.densityCalc.setPhase(this);
                this.density = this.densityCalc.calcDensity();
                break;
            }
            case DYNAMIC_VISCOSITY: {
                this.viscosityCalc.setPhase(this);
                this.viscosity = this.viscosityCalc.calcViscosity();
                break;
            }
            case THERMAL_CONDUCTIVITY: {
                this.conductivityCalc.setPhase(this);
                this.conductivity = this.conductivityCalc.calcConductivity();
                break;
            }
            default: {
                this.init(phase);
            }
        }
    }

    public void init(PhaseInterface phase, String name) {
        this.init(phase, PhysicalPropertyType.byName(name));
    }

    public double getViscosityOfWaxyOil(double waxVolumeFraction, double shareRate) {
        return this.viscosity * (Math.exp(this.waxViscosityParameter[0] * waxVolumeFraction) + this.waxViscosityParameter[1] * waxVolumeFraction / Math.sqrt(shareRate) + this.waxViscosityParameter[2] * Math.pow(waxVolumeFraction, 4.0) / shareRate);
    }

    public double getViscosity() {
        if (this.viscosity < 0.0) {
            return 1.0E-5;
        }
        return this.viscosity;
    }

    public double getPureComponentViscosity(int i) {
        return this.viscosityCalc.getPureComponentViscosity(i);
    }

    public double getConductivity() {
        if (this.conductivity < 0.0) {
            return 1.0E-5;
        }
        return this.conductivity;
    }

    public double calcDensity() {
        return this.densityCalc.calcDensity();
    }

    public double getDensity() {
        return this.density;
    }

    public double getKinematicViscosity() {
        if (this.kinematicViscosity < 0.0) {
            return 1.0E-5;
        }
        return this.kinematicViscosity;
    }

    public double getDiffusionCoefficient(int i, int j) {
        return this.diffusivityCalc.getMaxwellStefanBinaryDiffusionCoefficient(i, j);
    }

    public double getDiffusionCoefficient(String comp1, String comp2) {
        return this.diffusivityCalc.getMaxwellStefanBinaryDiffusionCoefficient(this.phase.getComponent(comp1).getComponentNumber(), this.phase.getComponent(comp2).getComponentNumber());
    }

    public double getFickDiffusionCoefficient(int i, int j) {
        return this.diffusivityCalc.getFickBinaryDiffusionCoefficient(i, j);
    }

    public void calcEffectiveDiffusionCoefficients() {
        this.init(this.phase);
        this.diffusivityCalc.calcEffectiveDiffusionCoefficients();
    }

    public double getEffectiveDiffusionCoefficient(int i) {
        return this.diffusivityCalc.getEffectiveDiffusionCoefficient(i);
    }

    public double getEffectiveDiffusionCoefficient(String compName) {
        return this.diffusivityCalc.getEffectiveDiffusionCoefficient(this.phase.getComponent(compName).getComponentNumber());
    }

    public double getEffectiveSchmidtNumber(int i) {
        return this.getKinematicViscosity() / this.diffusivityCalc.getEffectiveDiffusionCoefficient(i);
    }

    public double[] getWaxViscosityParameter() {
        return this.waxViscosityParameter;
    }

    public void setWaxViscosityParameter(double[] waxViscosityParameter) {
        this.waxViscosityParameter = waxViscosityParameter;
    }

    public void setWaxViscosityParameter(int paramNumber, double waxViscosityParameter) {
        this.waxViscosityParameter[paramNumber] = waxViscosityParameter;
    }
}

