/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.costestimation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.mechanicaldesign.SystemMechanicalDesign;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CostEstimateBaseClass
implements Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(CostEstimateBaseClass.class);
    private SystemMechanicalDesign processdesign;
    private double CAPEXperWeight = 1000.0;

    public CostEstimateBaseClass(SystemMechanicalDesign processdesign) {
        this.processdesign = processdesign;
    }

    public CostEstimateBaseClass(SystemMechanicalDesign processdesign, double costFactor) {
        this(processdesign);
        this.CAPEXperWeight = costFactor;
    }

    public double getWeightBasedCAPEXEstimate() {
        return this.processdesign.getTotalWeight() * this.CAPEXperWeight;
    }

    public double getCAPEXestimate() {
        double cost = 0.0;
        ArrayList<String> names = this.processdesign.getProcess().getAllUnitNames();
        for (int i = 0; i < names.size(); ++i) {
            try {
                if ((ProcessEquipmentInterface)this.processdesign.getProcess().getUnit(names.get(i)) == null) continue;
                cost += ((ProcessEquipmentInterface)this.processdesign.getProcess().getUnit(names.get(i))).getMechanicalDesign().getCostEstimate().getTotaltCost();
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return cost;
    }

    public int hashCode() {
        return Objects.hash(this.CAPEXperWeight);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CostEstimateBaseClass other = (CostEstimateBaseClass)obj;
        return Double.doubleToLongBits(this.CAPEXperWeight) == Double.doubleToLongBits(other.CAPEXperWeight);
    }
}

