/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import neqsim.process.SimulationBaseClass;
import neqsim.process.controllerdevice.ControllerDeviceInterface;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.stream.EnergyStream;
import neqsim.process.mechanicaldesign.MechanicalDesign;
import neqsim.process.util.report.Report;
import neqsim.thermo.system.SystemInterface;
import org.apache.commons.lang.SerializationUtils;

public abstract class ProcessEquipmentBaseClass
extends SimulationBaseClass
implements ProcessEquipmentInterface {
    private static final long serialVersionUID = 1000L;
    private ControllerDeviceInterface controller = null;
    ControllerDeviceInterface flowValveController = null;
    public boolean hasController = false;
    private String specification = "TP";
    public String[][] report = new String[0][0];
    public HashMap<String, String> properties = new HashMap();
    public EnergyStream energyStream = new EnergyStream();
    private boolean isSetEnergyStream = false;
    protected boolean isSolved = false;
    public String conditionAnalysisMessage = "";

    public ProcessEquipmentBaseClass(String name) {
        super(name);
    }

    @Override
    public SystemInterface getThermoSystem() {
        return null;
    }

    @Override
    public void displayResult() {
    }

    public ProcessEquipmentInterface copy() {
        byte[] bytes = SerializationUtils.serialize(this);
        return (ProcessEquipmentInterface)SerializationUtils.deserialize(bytes);
    }

    public Object getProperty(String propertyName) {
        return null;
    }

    @Override
    public void setRegulatorOutSignal(double signal) {
    }

    @Override
    public void setController(ControllerDeviceInterface controller) {
        this.controller = controller;
        this.hasController = controller != null;
    }

    public void setFlowValveController(ControllerDeviceInterface controller) {
        this.flowValveController = controller;
    }

    @Override
    public ControllerDeviceInterface getController() {
        return this.controller;
    }

    @Override
    public MechanicalDesign getMechanicalDesign() {
        return new MechanicalDesign(this);
    }

    @Override
    public void initMechanicalDesign() {
    }

    @Override
    public String getSpecification() {
        return this.specification;
    }

    @Override
    public void setSpecification(String specification) {
        this.specification = specification;
    }

    @Override
    public String[][] reportResults() {
        return this.report;
    }

    @Override
    public boolean solved() {
        return this.isSolved;
    }

    public EnergyStream getEnergyStream() {
        return this.energyStream;
    }

    public void setEnergyStream(EnergyStream energyStream) {
        this.setEnergyStream(true);
        this.energyStream = energyStream;
    }

    public void setEnergyStream(boolean isSetEnergyStream) {
        this.isSetEnergyStream = isSetEnergyStream;
    }

    public boolean isSetEnergyStream() {
        return this.isSetEnergyStream;
    }

    @Override
    public double getPressure() {
        return this.getFluid().getPressure();
    }

    @Override
    public double getPressure(String unit) {
        return this.getFluid().getPressure(unit);
    }

    @Override
    public void setPressure(double pressure) {
        this.getFluid().setPressure(pressure);
    }

    @Override
    public double getEntropyProduction(String unit) {
        return 0.0;
    }

    @Override
    public double getMassBalance(String unit) {
        return 0.0;
    }

    @Override
    public double getExergyChange(String unit, double surroundingTemperature) {
        return 0.0;
    }

    @Override
    public void runConditionAnalysis(ProcessEquipmentInterface refExchanger) {
    }

    @Override
    public String getConditionAnalysisMessage() {
        return this.conditionAnalysisMessage;
    }

    @Override
    public String[][] getResultTable() {
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode((Object[])this.report);
        result = 31 * result + Objects.hash(this.conditionAnalysisMessage, this.controller, this.energyStream, this.flowValveController, this.hasController, this.isSetEnergyStream, this.name, this.properties, this.specification);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessEquipmentBaseClass other = (ProcessEquipmentBaseClass)obj;
        return Objects.equals(this.conditionAnalysisMessage, other.conditionAnalysisMessage) && Objects.equals(this.controller, other.controller) && Objects.equals(this.energyStream, other.energyStream) && Objects.equals(this.flowValveController, other.flowValveController) && this.hasController == other.hasController && this.isSetEnergyStream == other.isSetEnergyStream && Objects.equals(this.name, other.name) && Objects.equals(this.properties, other.properties) && Arrays.deepEquals((Object[])this.report, (Object[])other.report) && Objects.equals(this.specification, other.specification);
    }

    @Override
    public String toJson() {
        return null;
    }

    @Override
    public String getReport_json() {
        return new Report(this).generateJsonReport();
    }

    @Override
    public void run_step(UUID id) {
    }
}

