/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.adsorber;

import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.mechanicaldesign.adsorber.AdsorberMechanicalDesign;
import neqsim.thermo.system.SystemInterface;

public class SimpleAdsorber
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    boolean setTemperature = false;
    StreamInterface[] outStream = new Stream[2];
    StreamInterface[] inStream = new Stream[2];
    SystemInterface system;
    protected double temperatureOut = 0.0;
    protected double dT = 0.0;
    private int numberOfStages = 5;
    private double numberOfTheoreticalStages = 3.0;
    double absorptionEfficiency = 0.5;
    private double HTU = 0.85;
    private double NTU = 2.0;
    private double stageEfficiency = 0.25;

    public SimpleAdsorber(String name) {
        super(name);
    }

    public SimpleAdsorber(String name, StreamInterface inStream1) {
        this(name);
        this.inStream[0] = inStream1;
        this.inStream[1] = inStream1;
        this.outStream[0] = inStream1.clone();
        this.outStream[1] = inStream1.clone();
        this.setName(name);
        SystemInterface systemOut1 = inStream1.getThermoSystem().clone();
        this.outStream[0].setThermoSystem(systemOut1);
        double molCO2 = inStream1.getThermoSystem().getPhase(0).getComponent("CO2").getNumberOfmoles();
        System.out.println("mol CO2 " + molCO2);
        SystemInterface systemOut0 = inStream1.getThermoSystem().clone();
        systemOut0.init(0);
        systemOut0.addComponent("MDEA", molCO2 * this.absorptionEfficiency);
        systemOut0.addComponent("water", molCO2 * this.absorptionEfficiency * 10.0);
        systemOut0.chemicalReactionInit();
        systemOut0.createDatabase(true);
        systemOut0.setMixingRule(4);
        this.outStream[1].setThermoSystem(systemOut0);
        this.outStream[1].run();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.outStream[0].setName(name + "_Sout1");
        this.outStream[1].setName(name + "_Sout2");
    }

    public void setdT(double dT) {
        this.dT = dT;
    }

    public StreamInterface getOutStream(int i) {
        return this.outStream[i];
    }

    public void setOutTemperature(double temperature) {
        this.temperatureOut = temperature;
    }

    public double getOutTemperature(int i) {
        return this.outStream[i].getThermoSystem().getTemperature();
    }

    public double getInTemperature(int i) {
        return this.inStream[i].getThermoSystem().getTemperature();
    }

    @Override
    public void run(UUID id) {
        SystemInterface systemOut1 = this.inStream[1].getThermoSystem().clone();
        this.outStream[0].setThermoSystem(systemOut1);
        this.outStream[0].run(id);
        this.outStream[1].run(id);
        double error = 100000.0;
        error = this.absorptionEfficiency - (this.outStream[1].getThermoSystem().getPhase(1).getComponent("CO2").getNumberOfMolesInPhase() + this.outStream[1].getThermoSystem().getPhase(1).getComponent("HCO3-").getNumberOfMolesInPhase()) / (this.outStream[1].getThermoSystem().getPhase(1).getComponent("MDEA").getNumberOfMolesInPhase() + this.outStream[1].getThermoSystem().getPhase(1).getComponent("MDEA+").getNumberOfMolesInPhase());
        int iter = 0;
        do {
            ++iter;
            double factor = this.outStream[1].getThermoSystem().getPhase(1).getComponent("MDEA").getNumberOfMolesInPhase() + this.outStream[1].getThermoSystem().getPhase(1).getComponent("MDEA+").getNumberOfMolesInPhase();
            this.outStream[1].getThermoSystem().addComponent("MDEA", -error * factor);
            this.outStream[1].getThermoSystem().addComponent("water", -error * 10.0 * factor);
            this.outStream[1].run(id);
            error = this.absorptionEfficiency - (this.outStream[1].getThermoSystem().getPhase(1).getComponent("CO2").getNumberOfMolesInPhase() + this.outStream[1].getThermoSystem().getPhase(1).getComponent("HCO3-").getNumberOfMolesInPhase()) / (this.outStream[1].getThermoSystem().getPhase(1).getComponent("MDEA").getNumberOfMolesInPhase() + this.outStream[1].getThermoSystem().getPhase(1).getComponent("MDEA+").getNumberOfMolesInPhase());
            System.out.println("error " + error);
        } while (Math.abs(error) > 1.0E-4 && iter < 30 && this.outStream[1].getThermoSystem().getPhase(1).getBeta() > 0.0 && this.outStream[0].getThermoSystem().getPhase(1).getBeta() > 0.0);
        this.outStream[1].setCalculationIdentifier(id);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.outStream[0].displayResult();
        this.outStream[1].displayResult();
    }

    public void setAproachToEquilibrium(double eff) {
        this.absorptionEfficiency = eff;
    }

    public double getNumberOfTheoreticalStages() {
        return this.numberOfTheoreticalStages;
    }

    public void setNumberOfTheoreticalStages(double numberOfTheoreticalStages) {
        this.numberOfTheoreticalStages = numberOfTheoreticalStages;
    }

    public int getNumberOfStages() {
        return this.numberOfStages;
    }

    public void setNumberOfStages(int numberOfStages) {
        this.numberOfStages = numberOfStages;
    }

    public double getStageEfficiency() {
        return this.stageEfficiency;
    }

    public void setStageEfficiency(double stageEfficiency) {
        this.stageEfficiency = stageEfficiency;
    }

    public double getHTU() {
        return this.HTU;
    }

    public void setHTU(double HTU) {
        this.HTU = HTU;
    }

    public double getNTU() {
        return this.NTU;
    }

    public void setNTU(double NTU) {
        this.NTU = NTU;
    }

    @Override
    public AdsorberMechanicalDesign getMechanicalDesign() {
        return new AdsorberMechanicalDesign(this);
    }
}

