/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.compressor;

import neqsim.physicalproperties.PhysicalPropertyType;
import neqsim.process.equipment.compressor.Compressor;
import neqsim.process.equipment.compressor.CompressorChart;
import neqsim.process.equipment.compressor.SurgeCurve;

public class CompressorChartGenerator {
    Compressor compressor = null;

    public CompressorChartGenerator(Compressor inpcompressor) {
        this.compressor = inpcompressor;
    }

    public CompressorChart generateCompressorChart(String generationOption) {
        double[] chartConditions = new double[3];
        chartConditions[0] = this.compressor.getOutletStream().getFluid().getMolarMass("kg/mol");
        double refspeed = this.compressor.getSpeed();
        double[] speed = new double[]{refspeed};
        double minSpeed = refspeed / 2.0;
        double maxSpeed = refspeed * 2.0;
        this.compressor.getInletStream().getFluid().initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
        double refflow = this.compressor.getInletStream().getFlowRate("m3/hr");
        double[][] flow = new double[1][3];
        flow[0][0] = refflow * 0.7;
        flow[0][1] = refflow * 1.0;
        flow[0][2] = refflow * 1.43;
        double minFlow = refflow / 2.0;
        double maxFlow = refflow * 2.0;
        double refhead = this.compressor.getPolytropicFluidHead();
        double[][] head = new double[1][3];
        head[0][0] = refhead * 1.5;
        head[0][1] = refhead;
        head[0][2] = refhead * 0.5;
        double[][] polyEff = new double[1][3];
        polyEff[0][0] = this.compressor.getPolytropicEfficiency() * 100.0 * 0.9;
        polyEff[0][1] = this.compressor.getPolytropicEfficiency() * 100.0;
        polyEff[0][2] = this.compressor.getPolytropicEfficiency() * 100.0 * 0.85;
        CompressorChart compChart = new CompressorChart();
        compChart.setUseCompressorChart(true);
        compChart.setHeadUnit("kJ/kg");
        compChart.setCurves(chartConditions, speed, flow, head, polyEff);
        double minFlowSurgeFlow = 0.7 * refflow;
        double refSurgeFlow = 0.8 * refflow;
        double maxSurgeFlow = 0.9 * refflow;
        double headSurgeRef = compChart.getPolytropicHead(refSurgeFlow, refspeed);
        double headSurgeMin = compChart.getPolytropicHead(minFlow, minSpeed);
        double headSurgeMax = compChart.getPolytropicHead(maxSurgeFlow, maxSpeed);
        SurgeCurve surgecurve = new SurgeCurve();
        surgecurve.setCurve(new double[3], new double[]{minFlowSurgeFlow, refSurgeFlow, maxSurgeFlow}, new double[]{headSurgeMin, headSurgeRef, headSurgeMax});
        compChart.setSurgeCurve(surgecurve);
        return compChart;
    }
}

