/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.compressor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class CompressorCurve
implements Serializable {
    private static final long serialVersionUID = 1000L;
    public double[] flow;
    public double[] head;
    public double[] polytropicEfficiency;
    public double speed = 1000.0;

    public CompressorCurve() {
        this.flow = new double[]{453.2, 600.0, 750.0};
        this.head = new double[]{1000.0, 900.0, 800.0};
        this.polytropicEfficiency = new double[]{78.0, 79.0, 78.0};
    }

    public CompressorCurve(double speed, double[] flow, double[] head, double[] polytropicEfficiency) {
        this.speed = speed;
        this.flow = flow;
        this.head = head;
        this.polytropicEfficiency = polytropicEfficiency;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.flow);
        result = 31 * result + Arrays.hashCode(this.head);
        result = 31 * result + Arrays.hashCode(this.polytropicEfficiency);
        result = 31 * result + Objects.hash(this.speed);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompressorCurve other = (CompressorCurve)obj;
        return Arrays.equals(this.flow, other.flow) && Arrays.equals(this.head, other.head) && Arrays.equals(this.polytropicEfficiency, other.polytropicEfficiency) && Double.doubleToLongBits(this.speed) == Double.doubleToLongBits(other.speed);
    }
}

