/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.distillation;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.distillation.Condenser;
import neqsim.process.equipment.distillation.DistillationInterface;
import neqsim.process.equipment.distillation.Reboiler;
import neqsim.process.equipment.distillation.SimpleTray;
import neqsim.process.equipment.heatexchanger.Heater;
import neqsim.process.equipment.separator.Separator;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DistillationColumn
extends ProcessEquipmentBaseClass
implements DistillationInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(DistillationColumn.class);
    private boolean doInitializion = true;
    boolean hasReboiler = false;
    boolean hasCondenser = false;
    protected ArrayList<SimpleTray> trays = new ArrayList(0);
    double condenserCoolingDuty = 10.0;
    private double reboilerTemperature = 273.15;
    private double condenserTemperature = 270.15;
    double topTrayPressure = -1.0;
    double bottomTrayPressure = -1.0;
    int numberOfTrays = 1;
    int maxNumberOfIterations = 10;
    private int feedTrayNumber = 1;
    StreamInterface stream_3 = new Stream("stream_3");
    StreamInterface gasOutStream = new Stream("gasOutStream");
    StreamInterface liquidOutStream = new Stream("liquidOutStream");
    StreamInterface feedStream = null;
    boolean stream_3isset = false;
    private double internalDiameter = 1.0;
    ProcessSystem distoperations;
    Heater heater;
    Separator separator2;
    private double err = 1.0E10;

    public DistillationColumn(String name, int numberOfTraysLocal, boolean hasReboiler, boolean hasCondenser) {
        super(name);
        int i;
        this.hasReboiler = hasReboiler;
        this.hasCondenser = hasCondenser;
        this.distoperations = new ProcessSystem();
        this.numberOfTrays = numberOfTraysLocal;
        if (hasReboiler) {
            this.trays.add(new Reboiler("Reboiler"));
            ++this.numberOfTrays;
        }
        for (i = 0; i < numberOfTraysLocal; ++i) {
            this.trays.add(new SimpleTray("SimpleTray" + i + 1));
        }
        if (hasCondenser) {
            this.trays.add(new Condenser("Condenser"));
            ++this.numberOfTrays;
        }
        for (i = 0; i < this.numberOfTrays; ++i) {
            this.distoperations.add(this.trays.get(i));
        }
    }

    public void addFeedStream(StreamInterface inputStream, int feedTrayNumber) {
        this.feedStream = inputStream;
        this.getTray(feedTrayNumber).addStream(inputStream);
        this.setFeedTrayNumber(feedTrayNumber);
        double moles = inputStream.getThermoSystem().getTotalNumberOfMoles();
        this.gasOutStream.setThermoSystem(inputStream.getThermoSystem().clone());
        this.gasOutStream.getThermoSystem().setTotalNumberOfMoles(moles / 2.0);
        this.liquidOutStream.setThermoSystem(inputStream.getThermoSystem().clone());
        this.liquidOutStream.getThermoSystem().setTotalNumberOfMoles(moles / 2.0);
    }

    public void init() {
        int i;
        if (!this.isDoInitializion()) {
            return;
        }
        this.setDoInitializion(false);
        this.trays.get(this.feedTrayNumber).run();
        if (this.getTray(this.feedTrayNumber).getFluid().getNumberOfPhases() == 1) {
            for (int i2 = 0; i2 < this.numberOfTrays; ++i2) {
                if (this.getTray(i2).getNumberOfInputStreams() > 0 && i2 != this.feedTrayNumber) {
                    this.getTray(this.feedTrayNumber).addStream(this.trays.get(i2).getStream(0));
                    this.getTray(this.feedTrayNumber).run();
                    this.getTray(this.feedTrayNumber).removeInputStream(this.getTray(this.feedTrayNumber).getNumberOfInputStreams() - 1);
                    if (this.getTray(this.feedTrayNumber).getThermoSystem().getNumberOfPhases() <= 1) continue;
                    break;
                }
                if (i2 != this.feedTrayNumber || this.getTray(i2).getNumberOfInputStreams() <= 1) continue;
                this.getTray(this.feedTrayNumber).addStream(this.trays.get(i2).getStream(1));
                this.trays.get(this.feedTrayNumber).run();
                this.getTray(this.feedTrayNumber).removeInputStream(this.getTray(this.feedTrayNumber).getNumberOfInputStreams() - 1);
                if (this.getTray(this.feedTrayNumber).getThermoSystem().getNumberOfPhases() > 1) break;
            }
        }
        if (this.getTray(this.feedTrayNumber).getFluid().getNumberOfPhases() == 1) {
            this.getTray(this.feedTrayNumber).getThermoSystem().init(0);
            this.getTray(this.feedTrayNumber).getThermoSystem().init(3);
        }
        this.trays.get(0).addStream(this.trays.get(this.feedTrayNumber).getLiquidOutStream().clone());
        this.trays.get(0).run();
        double feedTrayTemperature = this.getTray(this.getFeedTrayNumber()).getTemperature();
        this.condenserTemperature = this.trays.get(this.numberOfTrays - 1).getNumberOfInputStreams() > 0 ? this.trays.get(this.numberOfTrays - 1).getThermoSystem().getTemperature() : feedTrayTemperature - 1.0;
        this.reboilerTemperature = this.trays.get(0).getThermoSystem().getTemperature();
        double deltaTempCondenser = (feedTrayTemperature - this.condenserTemperature) / ((double)this.numberOfTrays * 1.0 - (double)this.feedTrayNumber - 1.0);
        double deltaTempReboiler = (this.reboilerTemperature - feedTrayTemperature) / ((double)this.feedTrayNumber * 1.0);
        double delta = 0.0;
        for (i = this.feedTrayNumber + 1; i < this.numberOfTrays; ++i) {
            this.trays.get(i).setTemperature(this.getTray(this.getFeedTrayNumber()).getThermoSystem().getTemperature() - (delta += deltaTempCondenser));
        }
        delta = 0.0;
        for (i = this.feedTrayNumber - 1; i >= 0; --i) {
            this.trays.get(i).setTemperature(this.getTray(this.getFeedTrayNumber()).getThermoSystem().getTemperature() + (delta += deltaTempReboiler));
        }
        for (i = 1; i < this.numberOfTrays; ++i) {
            this.trays.get(i).addStream(this.trays.get(i - 1).getGasOutStream());
            this.trays.get(i).init();
            this.trays.get(i).run();
        }
        for (i = this.numberOfTrays - 2; i >= 1; --i) {
            this.trays.get(i).addStream(this.trays.get(i + 1).getLiquidOutStream());
            this.trays.get(i).init();
            this.trays.get(i).run();
        }
        int streamNumb = this.trays.get(0).getNumberOfInputStreams() - 1;
        this.trays.get(0).replaceStream(streamNumb, this.trays.get(1).getLiquidOutStream());
        this.trays.get(0).init();
        this.trays.get(0).run();
    }

    public StreamInterface getGasOutStream() {
        return this.gasOutStream;
    }

    public StreamInterface getLiquidOutStream() {
        return this.liquidOutStream;
    }

    public SimpleTray getTray(int trayNumber) {
        return this.trays.get(trayNumber);
    }

    @Override
    public void setNumberOfTrays(int number) {
        int change;
        int oldNumberOfTrays = this.numberOfTrays;
        int tempNumberOfTrays = number;
        if (this.hasReboiler) {
            ++tempNumberOfTrays;
        }
        if (this.hasCondenser) {
            ++tempNumberOfTrays;
        }
        if ((change = tempNumberOfTrays - oldNumberOfTrays) > 0) {
            for (int i = 0; i < change; ++i) {
                this.trays.add(1, new SimpleTray("SimpleTray" + oldNumberOfTrays + i + 1));
            }
        } else if (change < 0) {
            for (int i = 0; i > change; --i) {
                this.trays.remove(1);
            }
        }
        this.numberOfTrays = tempNumberOfTrays;
        this.setDoInitializion(true);
        this.init();
    }

    public void setTopCondenserDuty(double duty) {
        this.condenserCoolingDuty = duty;
    }

    public void setTopPressure(double topPressure) {
        this.topTrayPressure = topPressure;
    }

    public void setBottomPressure(double bottomPressure) {
        this.bottomTrayPressure = bottomPressure;
    }

    @Override
    public void run(UUID id) {
        if (this.bottomTrayPressure < 0.0) {
            this.bottomTrayPressure = this.getTray(this.feedTrayNumber).getStream(0).getPressure();
        }
        if (this.topTrayPressure < 0.0) {
            this.topTrayPressure = this.getTray(this.feedTrayNumber).getStream(0).getPressure();
        }
        double dp = 0.0;
        if (this.numberOfTrays > 1) {
            dp = (this.bottomTrayPressure - this.topTrayPressure) / ((double)this.numberOfTrays - 1.0);
        }
        for (int i = 0; i < this.numberOfTrays; ++i) {
            this.trays.get(i).setPressure(this.bottomTrayPressure - (double)i * dp);
        }
        SystemInterface inpS = this.feedStream.getThermoSystem().clone();
        this.getTray(this.feedTrayNumber).getStream(0).setThermoSystem(inpS);
        if (this.numberOfTrays == 1) {
            this.trays.get(0).run(id);
            this.gasOutStream.setThermoSystem(this.trays.get(0).getGasOutStream().getThermoSystem().clone());
            this.liquidOutStream.setThermoSystem(this.trays.get(0).getLiquidOutStream().getThermoSystem().clone());
        } else {
            int i;
            double errOld;
            if (this.isDoInitializion()) {
                this.init();
            }
            this.err = 1.0E10;
            int iter = 0;
            double[] oldtemps = new double[this.numberOfTrays];
            this.trays.get(this.feedTrayNumber).run(id);
            do {
                int replaceStream;
                int i2;
                ++iter;
                errOld = this.err;
                this.err = 0.0;
                for (i = 0; i < this.numberOfTrays; ++i) {
                    oldtemps[i] = this.trays.get(i).getThermoSystem().getTemperature();
                }
                for (i = this.feedTrayNumber; i > 1; --i) {
                    int replaceStream1 = this.trays.get(i - 1).getNumberOfInputStreams() - 1;
                    this.trays.get(i - 1).replaceStream(replaceStream1, this.trays.get(i).getLiquidOutStream());
                    this.trays.get(i - 1).setPressure(this.bottomTrayPressure - (double)(i - 1) * dp);
                    this.trays.get(i - 1).run(id);
                }
                int streamNumb = this.trays.get(0).getNumberOfInputStreams() - 1;
                this.trays.get(0).setPressure(this.bottomTrayPressure);
                this.trays.get(0).replaceStream(streamNumb, this.trays.get(1).getLiquidOutStream());
                this.trays.get(0).run(id);
                for (i2 = 1; i2 <= this.numberOfTrays - 1; ++i2) {
                    replaceStream = this.trays.get(i2).getNumberOfInputStreams() - 2;
                    if (i2 == this.numberOfTrays - 1) {
                        replaceStream = this.trays.get(i2).getNumberOfInputStreams() - 1;
                    }
                    this.trays.get(i2).replaceStream(replaceStream, this.trays.get(i2 - 1).getGasOutStream());
                    this.trays.get(i2).run(id);
                }
                for (i2 = this.numberOfTrays - 2; i2 >= this.feedTrayNumber; --i2) {
                    replaceStream = this.trays.get(i2).getNumberOfInputStreams() - 1;
                    this.trays.get(i2).replaceStream(replaceStream, this.trays.get(i2 + 1).getLiquidOutStream());
                    this.trays.get(i2).run(id);
                }
                for (i2 = 0; i2 < this.numberOfTrays; ++i2) {
                    this.err += Math.abs(oldtemps[i2] - this.trays.get(i2).getThermoSystem().getTemperature());
                }
                logger.info("error iter " + this.err + " iteration " + iter);
            } while (this.err > 1.0E-4 && this.err < errOld && iter < this.maxNumberOfIterations);
            this.gasOutStream.setThermoSystem(this.trays.get(this.numberOfTrays - 1).getGasOutStream().getThermoSystem().clone());
            this.gasOutStream.setCalculationIdentifier(id);
            this.liquidOutStream.setThermoSystem(this.trays.get(0).getLiquidOutStream().getThermoSystem().clone());
            this.liquidOutStream.setCalculationIdentifier(id);
            for (i = 0; i < this.numberOfTrays; ++i) {
                this.trays.get(i).setCalculationIdentifier(id);
            }
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.distoperations.displayResult();
    }

    public boolean componentMassBalanceCheck(String componentName) {
        int k;
        int j;
        int numberOfInputStreams;
        int i;
        double[] massInput = new double[this.numberOfTrays];
        double[] massOutput = new double[this.numberOfTrays];
        double[] massBalance = new double[this.numberOfTrays];
        double[] massFeedInput = new double[this.numberOfTrays];
        for (i = 0; i < this.numberOfTrays; ++i) {
            numberOfInputStreams = this.trays.get(i).getNumberOfInputStreams() - 2;
            if (i == 0 || i == this.numberOfTrays - 1) {
                numberOfInputStreams = this.trays.get(i).getNumberOfInputStreams() - 1;
            }
            for (j = 0; j < numberOfInputStreams; ++j) {
                for (k = 0; k < this.trays.get(i).getStream(j).getFluid().getNumberOfPhases(); ++k) {
                    int n = i;
                    massFeedInput[n] = massFeedInput[n] + this.trays.get(i).getStream(j).getFluid().getPhase(k).getComponent(componentName).getFlowRate("kg/hr");
                }
            }
        }
        for (i = 0; i < this.numberOfTrays; ++i) {
            numberOfInputStreams = this.trays.get(i).getNumberOfInputStreams();
            for (j = 0; j < numberOfInputStreams; ++j) {
                for (k = 0; k < this.trays.get(i).getStream(j).getFluid().getNumberOfPhases(); ++k) {
                    int n = i;
                    massInput[n] = massInput[n] + this.trays.get(i).getStream(j).getFluid().getPhase(k).getComponent(componentName).getFlowRate("kg/hr");
                }
            }
            int n = i;
            massOutput[n] = massOutput[n] + this.trays.get(i).getGasOutStream().getFluid().getComponent(componentName).getFlowRate("kg/hr");
            int n2 = i;
            massOutput[n2] = massOutput[n2] + this.trays.get(i).getLiquidOutStream().getFluid().getComponent(componentName).getFlowRate("kg/hr");
            massBalance[i] = massInput[i] - massOutput[i];
            System.out.println("component " + componentName + " tray " + i + " number of input streams " + numberOfInputStreams + " massinput " + massInput[i] + " massoutput " + massOutput[i] + " massbalance " + massBalance[i] + " gasout " + this.trays.get(i).getGasOutStream().getFluid().getComponent("water").getFlowRate("kg/hr") + " liquidout " + this.trays.get(i).getLiquidOutStream().getFluid().getComponent("water").getFlowRate("kg/hr") + " pressure " + this.trays.get(i).getGasOutStream().getPressure() + " temperature " + this.trays.get(i).getGasOutStream().getTemperature("C") + " feedtotray " + massFeedInput[i]);
        }
        double massError = 0.0;
        for (int i2 = 0; i2 < this.numberOfTrays; ++i2) {
            massError += Math.abs(massBalance[i2]);
        }
        return !(massError > 1.0E-6);
    }

    public boolean massBalanceCheck() {
        double[] massInput = new double[this.numberOfTrays];
        double[] massOutput = new double[this.numberOfTrays];
        double[] massBalance = new double[this.numberOfTrays];
        for (int i = 0; i < this.numberOfTrays; ++i) {
            int numberOfInputStreams = this.trays.get(i).getNumberOfInputStreams();
            for (int j = 0; j < numberOfInputStreams; ++j) {
                int n = i;
                massInput[n] = massInput[n] + this.trays.get(i).getStream(j).getFluid().getFlowRate("kg/hr");
            }
            int n = i;
            massOutput[n] = massOutput[n] + this.trays.get(i).getGasOutStream().getFlowRate("kg/hr");
            int n2 = i;
            massOutput[n2] = massOutput[n2] + this.trays.get(i).getLiquidOutStream().getFlowRate("kg/hr");
            massBalance[i] = massInput[i] - massOutput[i];
            System.out.println("tray " + i + " number of input streams " + numberOfInputStreams + " massinput " + massInput[i] + " massoutput " + massOutput[i] + " massbalance " + massBalance[i] + " gasout " + this.trays.get(i).getGasOutStream().getFlowRate("kg/hr") + " liquidout " + this.trays.get(i).getLiquidOutStream().getFlowRate("kg/hr") + " pressure " + this.trays.get(i).getGasOutStream().getPressure() + " temperature " + this.trays.get(i).getGasOutStream().getTemperature("C"));
        }
        double massError = 0.0;
        for (int i = 0; i < this.numberOfTrays; ++i) {
            massError += Math.abs(massBalance[i]);
        }
        return !(massError > 1.0E-6);
    }

    public void energyBalanceCheck() {
        double[] energyInput = new double[this.numberOfTrays];
        double[] energyOutput = new double[this.numberOfTrays];
        double[] energyBalance = new double[this.numberOfTrays];
        for (int i = 0; i < this.numberOfTrays; ++i) {
            int numberOfInputStreams = this.trays.get(i).getNumberOfInputStreams();
            for (int j = 0; j < numberOfInputStreams; ++j) {
                int n = i;
                energyInput[n] = energyInput[n] + this.trays.get(i).getStream(j).getFluid().getEnthalpy();
            }
            int n = i;
            energyOutput[n] = energyOutput[n] + this.trays.get(i).getGasOutStream().getFluid().getEnthalpy();
            int n2 = i;
            energyOutput[n2] = energyOutput[n2] + this.trays.get(i).getLiquidOutStream().getFluid().getEnthalpy();
            energyBalance[i] = energyInput[i] - energyOutput[i];
            System.out.println("tray " + i + " number of input streams " + numberOfInputStreams + " energyinput " + energyInput[i] + " energyoutput " + energyOutput[i] + " energybalance " + energyBalance[i] + " gasout " + this.trays.get(i).getGasOutStream().getFlowRate("kg/hr") + " liquidout " + this.trays.get(i).getLiquidOutStream().getFlowRate("kg/hr") + " pressure " + this.trays.get(i).getGasOutStream().getPressure() + " temperature " + this.trays.get(i).getGasOutStream().getTemperature("C"));
        }
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(273.15, 15.0);
        testSystem.addComponent("ethane", 10.0);
        testSystem.addComponent("CO2", 10.0);
        testSystem.addComponent("propane", 20.0);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        ThermodynamicOperations ops = new ThermodynamicOperations(testSystem);
        ops.TPflash();
        testSystem.display();
        Stream stream_1 = new Stream("Stream1", testSystem);
        DistillationColumn column = new DistillationColumn("distColumn", 5, true, true);
        column.addFeedStream(stream_1, 3);
        ((Reboiler)column.getReboiler()).setRefluxRatio(0.5);
        ProcessSystem operations = new ProcessSystem();
        operations.add(stream_1);
        operations.add(column);
        operations.run();
        column.displayResult();
        System.out.println("reboiler duty" + ((Reboiler)column.getReboiler()).getDuty());
        System.out.println("condenser duty" + ((Condenser)column.getCondenser()).getDuty());
    }

    public SimpleTray getReboiler() {
        return this.trays.get(0);
    }

    public SimpleTray getCondenser() {
        return this.trays.get(this.trays.size() - 1);
    }

    public double getReboilerTemperature() {
        return this.reboilerTemperature;
    }

    public void setReboilerTemperature(double reboilerTemperature) {
        this.reboilerTemperature = reboilerTemperature;
    }

    public double getCondenserTemperature() {
        return this.condenserTemperature;
    }

    public void setCondenserTemperature(double condenserTemperature) {
        this.condenserTemperature = condenserTemperature;
    }

    public int getFeedTrayNumber() {
        return this.feedTrayNumber;
    }

    public void setFeedTrayNumber(int feedTrayNumber) {
        this.feedTrayNumber = feedTrayNumber;
    }

    public boolean isDoInitializion() {
        return this.doInitializion;
    }

    public void setDoInitializion(boolean doInitializion) {
        this.doInitializion = doInitializion;
    }

    public double getFsFactor() {
        double intArea = 3.14 * this.getInternalDiameter() * this.getInternalDiameter() / 4.0;
        return this.getGasOutStream().getThermoSystem().getFlowRate("m3/sec") / intArea * Math.sqrt(this.getGasOutStream().getThermoSystem().getDensity("kg/m3"));
    }

    public double getInternalDiameter() {
        return this.internalDiameter;
    }

    @Override
    public boolean solved() {
        return this.err < 1.0E-4;
    }

    public void setMaxNumberOfIterations(int maxIter) {
        this.maxNumberOfIterations = maxIter;
    }

    public void setInternalDiameter(double internalDiameter) {
        this.internalDiameter = internalDiameter;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.bottomTrayPressure, this.condenserCoolingDuty, this.condenserTemperature, this.distoperations, this.doInitializion, this.feedStream, this.feedTrayNumber, this.gasOutStream, this.hasCondenser, this.hasReboiler, this.heater, this.internalDiameter, this.liquidOutStream, this.numberOfTrays, this.reboilerTemperature, this.separator2, this.stream_3, this.stream_3isset, this.topTrayPressure, this.trays);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistillationColumn other = (DistillationColumn)obj;
        return Double.doubleToLongBits(this.bottomTrayPressure) == Double.doubleToLongBits(other.bottomTrayPressure) && Double.doubleToLongBits(this.condenserCoolingDuty) == Double.doubleToLongBits(other.condenserCoolingDuty) && Double.doubleToLongBits(this.condenserTemperature) == Double.doubleToLongBits(other.condenserTemperature) && Objects.equals(this.distoperations, other.distoperations) && this.doInitializion == other.doInitializion && Objects.equals(this.feedStream, other.feedStream) && this.feedTrayNumber == other.feedTrayNumber && Objects.equals(this.gasOutStream, other.gasOutStream) && this.hasCondenser == other.hasCondenser && this.hasReboiler == other.hasReboiler && Objects.equals(this.heater, other.heater) && Double.doubleToLongBits(this.internalDiameter) == Double.doubleToLongBits(other.internalDiameter) && Objects.equals(this.liquidOutStream, other.liquidOutStream) && this.numberOfTrays == other.numberOfTrays && Double.doubleToLongBits(this.reboilerTemperature) == Double.doubleToLongBits(other.reboilerTemperature) && Objects.equals(this.separator2, other.separator2) && Objects.equals(this.stream_3, other.stream_3) && this.stream_3isset == other.stream_3isset && Double.doubleToLongBits(this.topTrayPressure) == Double.doubleToLongBits(other.topTrayPressure) && Objects.equals(this.trays, other.trays);
    }
}

