/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.mixer;

import java.util.UUID;
import neqsim.process.equipment.mixer.Mixer;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public class StaticMixer
extends Mixer {
    private static final long serialVersionUID = 1000L;

    public StaticMixer(String name) {
        super(name);
    }

    @Override
    public void mixStream() {
        int index = 0;
        String compName = new String();
        for (int k = 1; k < this.streams.size(); ++k) {
            for (int i = 0; i < ((StreamInterface)this.streams.get(k)).getThermoSystem().getPhases()[0].getNumberOfComponents(); ++i) {
                boolean gotComponent = false;
                String componentName = ((StreamInterface)this.streams.get(k)).getThermoSystem().getPhases()[0].getComponents()[i].getName();
                double moles = ((StreamInterface)this.streams.get(k)).getThermoSystem().getPhases()[0].getComponents()[i].getNumberOfmoles();
                for (int p = 0; p < this.mixedStream.getThermoSystem().getPhases()[0].getNumberOfComponents(); ++p) {
                    if (!this.mixedStream.getThermoSystem().getPhases()[0].getComponents()[p].getName().equals(componentName)) continue;
                    gotComponent = true;
                    index = ((StreamInterface)this.streams.get(0)).getThermoSystem().getPhases()[0].getComponents()[p].getComponentNumber();
                    compName = ((StreamInterface)this.streams.get(0)).getThermoSystem().getPhases()[0].getComponents()[p].getComponentName();
                }
                if (gotComponent) {
                    this.mixedStream.getThermoSystem().addComponent(index, moles, 0);
                    continue;
                }
                this.mixedStream.getThermoSystem().addComponent(compName, moles, 0);
            }
        }
    }

    @Override
    public double guessTemperature() {
        double gtemp = 0.0;
        for (int k = 0; k < this.streams.size(); ++k) {
            gtemp += ((StreamInterface)this.streams.get(k)).getThermoSystem().getTemperature() * ((StreamInterface)this.streams.get(k)).getThermoSystem().getNumberOfMoles() / this.mixedStream.getThermoSystem().getNumberOfMoles();
        }
        return gtemp;
    }

    @Override
    public double calcMixStreamEnthalpy() {
        double enthalpy = 0.0;
        for (int k = 0; k < this.streams.size(); ++k) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().init(3);
            enthalpy += ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy();
            System.out.println("total enthalpy k : " + ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy());
        }
        System.out.println("total enthalpy of streams: " + enthalpy);
        return enthalpy;
    }

    @Override
    public void run(UUID id) {
        double enthalpy = 0.0;
        for (int k = 0; k < this.streams.size(); ++k) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().init(3);
            enthalpy += ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy();
        }
        this.mixedStream.setThermoSystem(((StreamInterface)this.streams.get(0)).getThermoSystem().clone());
        this.mixedStream.getThermoSystem().setNumberOfPhases(2);
        this.mixedStream.getThermoSystem().reInitPhaseType();
        this.mixStream();
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.mixedStream.getThermoSystem());
        try {
            if (Double.isNaN(enthalpy)) {
                logger.error("error in StaticMixer calc0 - enthalpy NaN");
                testOps.TPflash();
            } else {
                testOps.PHflash(enthalpy, 0);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.mixedStream.getThermoSystem().init(3);
        this.setCalculationIdentifier(id);
    }
}

