/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.mixer;

import java.util.UUID;
import neqsim.process.equipment.mixer.StaticMixer;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public class StaticNeqMixer
extends StaticMixer {
    private static final long serialVersionUID = 1000L;

    public StaticNeqMixer(String name) {
        super(name);
    }

    @Override
    public void mixStream() {
        int index = 0;
        String compName = new String();
        for (int k = 1; k < this.streams.size(); ++k) {
            for (int i = 0; i < ((StreamInterface)this.streams.get(k)).getThermoSystem().getPhases()[0].getNumberOfComponents(); ++i) {
                int p;
                boolean gotComponent = false;
                String componentName = ((StreamInterface)this.streams.get(k)).getThermoSystem().getPhases()[0].getComponents()[i].getName();
                System.out.println("adding: " + componentName);
                int numberOfPhases = ((StreamInterface)this.streams.get(k)).getThermoSystem().getNumberOfPhases();
                double[] moles = new double[numberOfPhases];
                for (p = 0; p < numberOfPhases; ++p) {
                    moles[p] = ((StreamInterface)this.streams.get(k)).getThermoSystem().getPhases()[p].getComponents()[i].getNumberOfMolesInPhase();
                }
                for (p = 0; p < this.mixedStream.getThermoSystem().getPhases()[0].getNumberOfComponents(); ++p) {
                    if (!this.mixedStream.getThermoSystem().getPhases()[0].getComponents()[p].getName().equals(componentName)) continue;
                    gotComponent = true;
                    index = ((StreamInterface)this.streams.get(0)).getThermoSystem().getPhases()[0].getComponents()[p].getComponentNumber();
                    compName = ((StreamInterface)this.streams.get(0)).getThermoSystem().getPhases()[0].getComponents()[p].getComponentName();
                }
                if (gotComponent) {
                    System.out.println("adding moles starting....");
                    for (p = 0; p < numberOfPhases; ++p) {
                        this.mixedStream.getThermoSystem().addComponent(index, moles[p], p);
                    }
                    System.out.println("adding moles finished");
                    continue;
                }
                System.out.println("ikke gaa hit");
                for (p = 0; p < numberOfPhases; ++p) {
                    this.mixedStream.getThermoSystem().addComponent(compName, moles[p], p);
                }
            }
        }
        this.mixedStream.getThermoSystem().init_x_y();
        this.mixedStream.getThermoSystem().initBeta();
        this.mixedStream.getThermoSystem().init(2);
    }

    @Override
    public void run(UUID id) {
        double enthalpy = 0.0;
        for (int k = 0; k < this.streams.size(); ++k) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().init(3);
            enthalpy += ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy();
        }
        this.mixedStream.setThermoSystem(((StreamInterface)this.streams.get(0)).getThermoSystem().clone());
        this.mixedStream.getThermoSystem().setNumberOfPhases(2);
        this.mixedStream.getThermoSystem().reInitPhaseType();
        this.mixStream();
        SystemInterface syst = this.mixedStream.getThermoSystem().clone();
        syst.setTemperature(((StreamInterface)this.streams.get(0)).getThermoSystem().getTemperature());
        syst.setPressure(((StreamInterface)this.streams.get(0)).getThermoSystem().getPressure());
        ThermodynamicOperations testOps = new ThermodynamicOperations(syst);
        testOps.PHflash(enthalpy, 0);
        System.out.println("temp " + syst.getTemperature());
        this.mixedStream.getThermoSystem().setTemperature(syst.getTemperature());
        this.mixedStream.getThermoSystem().init(3);
        this.mixedStream.setCalculationIdentifier(id);
        this.setCalculationIdentifier(id);
    }
}

