/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.pipeline;

import java.util.UUID;
import neqsim.fluidmechanics.flowsystem.FlowSystemInterface;
import neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface;
import neqsim.fluidmechanics.geometrydefinitions.pipe.PipeData;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.pipeline.PipeLineInterface;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.mechanicaldesign.pipeline.PipelineMechanicalDesign;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Pipeline
extends TwoPortEquipment
implements PipeLineInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Pipeline.class);
    protected String fileName = "c:/test5.nc";
    protected FlowSystemInterface pipe;
    protected SystemInterface system;
    String flowPattern = "stratified";
    double[] times;
    boolean equilibriumHeatTransfer = true;
    boolean equilibriumMassTransfer = false;
    int numberOfLegs = 1;
    int numberOfNodesInLeg = 30;
    double[] legHeights = new double[]{0.0, 0.0};
    double[] legPositions = new double[]{0.0, 1.0};
    double[] pipeDiameters = new double[]{0.1507588, 0.1507588};
    double[] outerTemperature = new double[]{278.0, 278.0};
    double[] pipeWallRoughness = new double[]{1.0E-5, 1.0E-5};
    double[] outerHeatTransferCoeffs = new double[]{1.0E-5, 1.0E-5};
    double[] wallHeatTransferCoeffs = new double[]{1.0E-5, 1.0E-5};
    PipelineMechanicalDesign pipelineMechanicalDesign = null;

    public Pipeline(String name) {
        super(name);
    }

    public Pipeline(String name, StreamInterface inStream) {
        super(name, inStream);
    }

    @Override
    public void initMechanicalDesign() {
        this.pipelineMechanicalDesign = new PipelineMechanicalDesign(this);
    }

    @Override
    public PipelineMechanicalDesign getMechanicalDesign() {
        return this.pipelineMechanicalDesign;
    }

    @Override
    public void setOutputFileName(String name) {
        this.fileName = name;
    }

    @Override
    public void setNumberOfLegs(int number) {
        this.numberOfLegs = number;
    }

    @Override
    public void setNumberOfNodesInLeg(int number) {
        this.numberOfNodesInLeg = number;
    }

    @Override
    public void setHeightProfile(double[] heights) {
        if (heights.length != this.numberOfLegs + 1) {
            System.out.println("Wrong number of heights specified.");
            System.out.println("Number of heights must be number of legs + 1 ");
            return;
        }
        this.legHeights = new double[heights.length];
        System.arraycopy(heights, 0, this.legHeights, 0, this.legHeights.length);
    }

    @Override
    public void setLegPositions(double[] positions) {
        if (positions.length != this.numberOfLegs + 1) {
            System.out.println("Wrong number of legpositions specified.");
            System.out.println("Number of legpositions must be number of legs + 1 ");
            return;
        }
        this.legPositions = new double[positions.length];
        System.arraycopy(positions, 0, this.legPositions, 0, this.legPositions.length);
    }

    @Override
    public void setPipeDiameters(double[] diameter) {
        if (diameter.length != this.numberOfLegs + 1) {
            System.out.println("Wrong number of diameters specified.");
            System.out.println("Number of diameters must be number of legs + 1 ");
            return;
        }
        this.pipeDiameters = new double[diameter.length];
        System.arraycopy(diameter, 0, this.pipeDiameters, 0, this.pipeDiameters.length);
    }

    public void setPipeOuterHeatTransferCoefficients(double[] heatCoefs) {
        if (heatCoefs.length != this.numberOfLegs + 1) {
            System.out.println("Wrong number of heatCoefs specified.");
            System.out.println("Number of heatCoefs must be number of legs + 1 ");
            return;
        }
        this.outerHeatTransferCoeffs = new double[heatCoefs.length];
        System.arraycopy(heatCoefs, 0, this.outerHeatTransferCoeffs, 0, this.outerHeatTransferCoeffs.length);
    }

    public void setPipeWallHeatTransferCoefficients(double[] heatCoefs) {
        if (heatCoefs.length != this.numberOfLegs + 1) {
            System.out.println("Wrong number of heatCoefs specified.");
            System.out.println("Number of heatCoefs must be number of legs + 1 ");
            return;
        }
        this.wallHeatTransferCoeffs = new double[heatCoefs.length];
        System.arraycopy(heatCoefs, 0, this.wallHeatTransferCoeffs, 0, this.wallHeatTransferCoeffs.length);
    }

    @Override
    public void setPipeWallRoughness(double[] rough) {
        if (rough.length != this.numberOfLegs + 1) {
            System.out.println("Wrong number of roughness points specified.");
            System.out.println("Number of roughness must be number of legs + 1 ");
            return;
        }
        this.pipeWallRoughness = new double[rough.length];
        System.arraycopy(rough, 0, this.pipeWallRoughness, 0, this.pipeWallRoughness.length);
    }

    @Override
    public void setOuterTemperatures(double[] outerTemp) {
        if (outerTemp.length != this.numberOfLegs + 1) {
            System.out.println("Wrong number of outer temperature points specified.");
            System.out.println("Number of outer temperature must be number of legs + 1 ");
            return;
        }
        this.outerTemperature = new double[outerTemp.length];
        System.arraycopy(outerTemp, 0, this.outerTemperature, 0, this.outerTemperature.length);
    }

    public void setEquilibriumMassTransfer(boolean test) {
        this.equilibriumMassTransfer = test;
    }

    public void setEquilibriumHeatTransfer(boolean test) {
        this.equilibriumHeatTransfer = test;
    }

    @Override
    public void run(UUID id) {
        this.system = this.inStream.getThermoSystem().clone();
        GeometryDefinitionInterface[] pipeGemometry = new PipeData[this.numberOfLegs + 1];
        for (int i = 0; i < this.pipeDiameters.length; ++i) {
            pipeGemometry[i] = new PipeData(this.pipeDiameters[i], this.pipeWallRoughness[i]);
        }
        this.pipe.setInletThermoSystem(this.system);
        this.pipe.setNumberOfLegs(this.numberOfLegs);
        this.pipe.setNumberOfNodesInLeg(this.numberOfNodesInLeg);
        this.pipe.setEquipmentGeometry(pipeGemometry);
        this.pipe.setLegOuterTemperatures(this.outerTemperature);
        this.pipe.setLegHeights(this.legHeights);
        this.pipe.setLegOuterHeatTransferCoefficients(this.outerHeatTransferCoeffs);
        this.pipe.setLegWallHeatTransferCoefficients(this.wallHeatTransferCoeffs);
        this.pipe.setLegPositions(this.legPositions);
        this.pipe.setInitialFlowPattern(this.flowPattern);
        this.pipe.createSystem();
        this.pipe.setEquilibriumMassTransfer(this.equilibriumMassTransfer);
        this.pipe.setEquilibriumHeatTransfer(this.equilibriumHeatTransfer);
        this.pipe.init();
        this.setCalculationIdentifier(id);
    }

    @Override
    public void runTransient(double dt, UUID id) {
        this.pipe.solveTransient(2, id);
    }

    @Override
    public void displayResult() {
    }

    @Override
    public FlowSystemInterface getPipe() {
        return this.pipe;
    }

    @Override
    public void setInitialFlowPattern(String flowPattern) {
        this.flowPattern = flowPattern;
    }

    public double[] getTimes() {
        return this.times;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSuperficialVelocity(int phase, int node) {
        try {
            double d = this.outStream.getThermoSystem().getPhase(phase).getNumberOfMolesInPhase() * this.outStream.getThermoSystem().getPhase(phase).getMolarMass() / this.outStream.getThermoSystem().getPhase(phase).getPhysicalProperties().getDensity() / (3.14 * this.pipeDiameters[node] * this.pipeDiameters[node] / 4.0);
            return d;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return 0.0;
    }

    public void setTimeSeries(double[] times, SystemInterface[] systems, int timestepininterval) {
        this.times = times;
        this.pipe.getTimeSeries().setTimes(times);
        this.pipe.getTimeSeries().setInletThermoSystems(systems);
        this.pipe.getTimeSeries().setNumberOfTimeStepsInInterval(timestepininterval);
    }

    @Override
    public double getEntropyProduction(String unit) {
        return this.outStream.getThermoSystem().getEntropy(unit) - this.inStream.getThermoSystem().getEntropy(unit);
    }

    public double getOutletPressure(String unit) {
        return this.outStream.getPressure(unit);
    }
}

