/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.pipeline;

import java.util.UUID;
import neqsim.fluidmechanics.flowsystem.FlowSystemInterface;
import neqsim.process.equipment.pipeline.Pipeline;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public class SimpleTPoutPipeline
extends Pipeline {
    private static final long serialVersionUID = 1000L;
    boolean setTemperature = false;
    protected double temperatureOut = 0.0;
    protected double pressureOut = 0.0;
    double dH = 0.0;

    public SimpleTPoutPipeline(String name) {
        super(name);
    }

    public SimpleTPoutPipeline(String name, StreamInterface inStream) {
        super(name, inStream);
    }

    public void setOutTemperature(double temperature) {
        this.temperatureOut = temperature;
    }

    public void setOutPressure(double pressure) {
        this.pressureOut = pressure;
    }

    @Override
    public void run(UUID id) {
        this.system = this.inStream.getThermoSystem().clone();
        this.system.setTemperature(this.temperatureOut);
        this.system.setPressure(this.pressureOut);
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        testOps.TPflash();
        this.outStream.setThermoSystem(this.system);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.outStream.getThermoSystem().display(this.name);
        this.outStream.getThermoSystem().initPhysicalProperties();
        System.out.println("Superficial velocity out gas : " + this.getSuperficialVelocity(0, 1));
        System.out.println("Superficial velocity out condensate : " + this.getSuperficialVelocity(1, 1));
        System.out.println("Superficial velocity out MEG/water : " + this.getSuperficialVelocity(2, 1));
    }

    @Override
    public FlowSystemInterface getPipe() {
        return null;
    }

    @Override
    public void setInitialFlowPattern(String flowPattern) {
    }
}

