/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.reservoir;

import java.util.UUID;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.valve.ThrottlingValve;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.exception.InvalidInputException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WellFlow
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ThrottlingValve.class);
    SystemInterface thermoSystem;
    private double wellProductionIndex = 0.0;
    double pressureOut = 1.0;
    String pressureUnit = "bara";
    boolean useWellProductionIndex = false;
    boolean calcpressure = true;

    public WellFlow(String name) {
        super(name);
    }

    @Override
    public void run(UUID id) {
        this.thermoSystem = this.getInletStream().getThermoSystem().clone();
        this.thermoSystem.setPressure(this.pressureOut, this.pressureUnit);
        this.outStream.setThermoSystem(this.thermoSystem);
        if (this.useWellProductionIndex) {
            if (this.calcpressure) {
                double presout = 1.0;
                if (!(Math.pow(this.getInletStream().getPressure("bara"), 2.0) - this.getInletStream().getFlowRate("MSm3/day") / this.wellProductionIndex > 0.0)) {
                    logger.error("pressure lower that 0");
                    throw new RuntimeException(new InvalidInputException("WellFlow", "run: calcOutletPressure", "pressure", "- Outlet pressure is negative" + this.pressureOut));
                }
                presout = Math.sqrt(Math.pow(this.getInletStream().getPressure("bara"), 2.0) - this.getInletStream().getFlowRate("MSm3/day") / this.wellProductionIndex);
                this.outStream.setPressure(presout, "bara");
            } else {
                double flow = this.wellProductionIndex * (Math.pow(this.getInletStream().getPressure("bara"), 2.0) - Math.pow(this.thermoSystem.getPressure("bara"), 2.0));
                this.outStream.setFlowRate(flow, "MSm3/day");
            }
        } else {
            this.wellProductionIndex = this.getInletStream().getFlowRate("MSm3/day") / (Math.pow(this.getInletStream().getPressure("bara"), 2.0) - Math.pow(this.thermoSystem.getPressure("bara"), 2.0));
        }
        this.outStream.run();
    }

    @Override
    public void runTransient(double dt, UUID id) {
        if (this.getCalculateSteadyState()) {
            this.run(id);
            this.increaseTime(dt);
            return;
        }
        double flow = this.wellProductionIndex * (Math.pow(this.getInletStream().getPressure("bara"), 2.0) - Math.pow(this.thermoSystem.getPressure("bara"), 2.0));
        this.outStream.setFlowRate(flow, "MSm3/day");
        this.outStream.run();
    }

    public double getWellProductionIndex() {
        return this.wellProductionIndex;
    }

    public void setWellProductionIndex(double wellProductionIndex) {
        this.useWellProductionIndex = true;
        this.wellProductionIndex = wellProductionIndex;
    }
}

