/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.stream;

import java.util.UUID;
import neqsim.process.equipment.stream.Stream;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.exception.InvalidInputException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EquilibriumStream
extends Stream {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(EquilibriumStream.class);

    public EquilibriumStream(String name) {
        super(name);
    }

    public EquilibriumStream(String name, SystemInterface thermoSystem) {
        super(name, thermoSystem);
    }

    @Override
    public EquilibriumStream clone() {
        EquilibriumStream clonedStream = null;
        try {
            clonedStream = (EquilibriumStream)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.thermoSystem = this.thermoSystem.clone();
        return clonedStream;
    }

    @Override
    public EquilibriumStream clone(String name) {
        if (this.getName() == name) {
            throw new RuntimeException(new InvalidInputException(this, "clone", "name", "- Same name as in original object"));
        }
        EquilibriumStream s = this.clone();
        s.setName(name);
        return s;
    }

    @Override
    public void run(UUID id) {
        logger.info("start flashing stream... " + this.streamNumber);
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        thermoOps.TPflash();
        logger.info("number of phases: " + this.thermoSystem.getNumberOfPhases());
        logger.info("beta: " + this.thermoSystem.getBeta());
        this.setCalculationIdentifier(id);
    }
}

