/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.stream;

import java.util.UUID;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.exception.InvalidInputException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IronIonSaturationStream
extends Stream {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(IronIonSaturationStream.class);
    protected SystemInterface reactiveThermoSystem;

    public IronIonSaturationStream(String name) {
        super(name);
    }

    public IronIonSaturationStream(String name, StreamInterface stream) {
        super(name, stream);
    }

    public IronIonSaturationStream(String name, SystemInterface thermoSystem) {
        super(name, thermoSystem);
    }

    @Override
    public IronIonSaturationStream clone() {
        IronIonSaturationStream clonedSystem = null;
        try {
            clonedSystem = (IronIonSaturationStream)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    @Override
    public IronIonSaturationStream clone(String name) {
        if (this.getName() == name) {
            throw new RuntimeException(new InvalidInputException(this, "clone", "name", "- Same name as in original object"));
        }
        IronIonSaturationStream s = this.clone();
        s.setName(name);
        return s;
    }

    @Override
    public void run(UUID id) {
        logger.info("start flashing stream... " + this.streamNumber);
        if (this.stream != null) {
            this.thermoSystem = this.stream.getThermoSystem().clone();
        }
        if (this.stream != null) {
            this.reactiveThermoSystem = this.stream.getThermoSystem().setModel("Electrolyte-CPA-EOS-statoil");
        }
        this.reactiveThermoSystem.addComponent("Fe++", 1.0E-6);
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.reactiveThermoSystem);
        thermoOps.TPflash();
        this.reactiveThermoSystem.display();
        try {
            logger.info("aqueous phase number " + this.reactiveThermoSystem.getPhaseNumberOfPhase("aqueous"));
            thermoOps.addIonToScaleSaturation(this.reactiveThermoSystem.getPhaseNumberOfPhase("aqueous"), "FeCO3", "Fe++");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.reactiveThermoSystem.display();
        logger.info("number of phases: " + this.reactiveThermoSystem.getNumberOfPhases());
        logger.info("beta: " + this.reactiveThermoSystem.getBeta());
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.reactiveThermoSystem.display(this.name);
    }
}

