/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.stream;

import java.util.UUID;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.exception.InvalidInputException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NeqStream
extends Stream {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(NeqStream.class);

    public NeqStream(String name) {
        super(name);
    }

    public NeqStream(String name, StreamInterface stream) {
        super(name, stream);
    }

    public NeqStream(String name, SystemInterface thermoSystem) {
        super(name, thermoSystem);
    }

    @Override
    public NeqStream clone() {
        NeqStream clonedStream = null;
        try {
            clonedStream = (NeqStream)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.thermoSystem = this.thermoSystem.clone();
        return clonedStream;
    }

    @Override
    public NeqStream clone(String name) {
        if (this.getName() == name) {
            throw new RuntimeException(new InvalidInputException(this, "clone", "name", "- Same name as in original object"));
        }
        NeqStream s = this.clone();
        s.setName(name);
        return s;
    }

    @Override
    public void run(UUID id) {
        logger.info("start flashing stream... " + this.streamNumber);
        if (this.stream != null) {
            this.thermoSystem = this.stream.getThermoSystem().clone();
        }
        this.thermoSystem.init_x_y();
        this.thermoSystem.initBeta();
        this.thermoSystem.init(3);
        logger.info("number of phases: " + this.thermoSystem.getNumberOfPhases());
        logger.info("beta: " + this.thermoSystem.getBeta());
        this.setCalculationIdentifier(id);
    }
}

