/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.stream;

import java.util.UUID;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.exception.InvalidInputException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScalePotentialCheckStream
extends Stream {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ScalePotentialCheckStream.class);
    protected SystemInterface reactiveThermoSystem;

    public ScalePotentialCheckStream(String name) {
        super(name);
    }

    public ScalePotentialCheckStream(String name, StreamInterface stream) {
        super(name, stream);
    }

    public ScalePotentialCheckStream(String name, SystemInterface thermoSystem) {
        super(name, thermoSystem);
    }

    @Override
    public ScalePotentialCheckStream clone() {
        ScalePotentialCheckStream clonedSystem = null;
        try {
            clonedSystem = (ScalePotentialCheckStream)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    @Override
    public ScalePotentialCheckStream clone(String name) {
        if (this.getName() == name) {
            throw new RuntimeException(new InvalidInputException(this, "clone", "name", "- Same name as in original object"));
        }
        ScalePotentialCheckStream s = this.clone();
        s.setName(name);
        return s;
    }

    @Override
    public void run(UUID id) {
        logger.info("start flashing stream... " + this.streamNumber);
        if (this.stream != null) {
            this.thermoSystem = this.stream.getThermoSystem().clone();
        }
        if (this.stream != null) {
            this.reactiveThermoSystem = this.stream.getThermoSystem().setModel("Electrolyte-CPA-EOS-statoil");
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.reactiveThermoSystem);
        thermoOps.TPflash();
        this.reactiveThermoSystem.init(3);
        logger.info("number of phases: " + this.reactiveThermoSystem.getNumberOfPhases());
        logger.info("beta: " + this.reactiveThermoSystem.getBeta());
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.reactiveThermoSystem.display(this.name);
    }
}

